/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.orm.impl;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.zhiqim.kernel.MultiInstancer;
import org.zhiqim.kernel.extend.HashMapCV;
import org.zhiqim.kernel.extend.LinkedMapSO;
import org.zhiqim.kernel.extend.MapSS;
import org.zhiqim.kernel.transaction.TransactionManager;
import org.zhiqim.kernel.util.Sqls;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.orm.ORMConstants;
import org.zhiqim.orm.ORMException;
import org.zhiqim.orm.ORMServer;
import org.zhiqim.orm.ZSQL;
import org.zhiqim.orm.annotation.AnDbo;
import org.zhiqim.orm.annotation.AnDboField;
import org.zhiqim.orm.datasource.ZDBClose;
import org.zhiqim.orm.dbo.CallParam;
import org.zhiqim.orm.dbo.CallResult;
import org.zhiqim.orm.dbo.defined._Dbo;
import org.zhiqim.orm.executor.BatchExecutor;
import org.zhiqim.orm.executor.CallExecutor;
import org.zhiqim.orm.executor.QueryExecutor;
import org.zhiqim.orm.executor.UpdateExecutor;

public final class ZSQLImplement
extends MultiInstancer
implements ZSQL,
ORMConstants {
    private ORMServer server;
    private HashMapCV<_Dbo> dboMap;

    public ZSQLImplement(ORMServer server) {
        this.server = server;
        this.dboMap = new HashMapCV();
    }

    public ORMServer getServer() {
        return this.server;
    }

    public _Dbo getDbo(Class<?> clazz) {
        Field[] fields;
        _Dbo _dbo = (_Dbo)this.dboMap.get(clazz);
        if (_dbo != null) {
            return _dbo;
        }
        AnDbo result = clazz.getAnnotation(AnDbo.class);
        if (result == null) {
            return null;
        }
        _dbo = new _Dbo(clazz.getName());
        Field[] fieldArray = fields = clazz.getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            String fieldName = field.getName();
            AnDboField f = field.getAnnotation(AnDboField.class);
            if (f != null) {
                _dbo.addField(fieldName, f.column(), f.type());
            }
            ++n2;
        }
        this.dboMap.put(clazz, (Object)_dbo);
        return _dbo;
    }

    @Override
    public int identityInt() throws SQLException {
        return (int)this.identityLong();
    }

    @Override
    public long identityLong() throws SQLException {
        ResultSet rst;
        PreparedStatement pstmt;
        Connection conn;
        boolean isTx;
        block7: {
            isTx = true;
            conn = (Connection)TransactionManager.getInstance((String)this.server.getId());
            if (conn == null) {
                isTx = false;
                conn = this.server.getConnection();
            }
            pstmt = null;
            rst = null;
            try {
                pstmt = conn.prepareStatement("select @@IDENTITY");
                rst = pstmt.executeQuery();
                if (rst.next()) break block7;
            }
            catch (Throwable throwable) {
                ZDBClose.close(rst, pstmt);
                if (!isTx) {
                    conn.close();
                }
                throw throwable;
            }
            ZDBClose.close(rst, pstmt);
            if (!isTx) {
                conn.close();
            }
            return -1L;
        }
        long l = rst.getLong(1);
        ZDBClose.close(rst, pstmt);
        if (!isTx) {
            conn.close();
        }
        return l;
    }

    @Override
    public void execute(String sql) throws SQLException {
        if (Validates.isEmptyBlank((String)sql)) {
            return;
        }
        if (this.server.isSqlite()) {
            sql = Sqls.formatSpace((String)sql);
            sql = sql.replaceAll("truncate table", "delete from");
        }
        boolean isTx = true;
        Connection conn = (Connection)TransactionManager.getInstance((String)this.server.getId());
        if (conn == null) {
            isTx = false;
            conn = this.server.getConnection();
        }
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            stmt.execute(sql);
        }
        finally {
            ZDBClose.close(stmt);
            if (!isTx) {
                conn.close();
            }
        }
    }

    @Override
    public void execute(List<String> sqlList) throws SQLException {
        if (Validates.isEmpty(sqlList)) {
            return;
        }
        boolean isTx = true;
        Connection conn = (Connection)TransactionManager.getInstance((String)this.server.getId());
        if (conn == null) {
            isTx = false;
            conn = this.server.getConnection();
        }
        Statement stmt = null;
        boolean autoCommit = true;
        try {
            try {
                autoCommit = conn.getAutoCommit();
                if (!isTx) {
                    conn.setAutoCommit(false);
                }
                stmt = conn.createStatement();
                for (String sql : sqlList) {
                    if (this.server.isSqlite()) {
                        sql = Sqls.formatSpace((String)sql);
                        sql = sql.replaceAll("truncate table", "delete from");
                    }
                    stmt.execute(sql);
                }
                if (!isTx) {
                    conn.commit();
                }
            }
            catch (SQLException e) {
                if (!isTx) {
                    conn.rollback();
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            ZDBClose.close(stmt);
            if (!isTx) {
                conn.setAutoCommit(autoCommit);
                conn.close();
            }
            throw throwable;
        }
        ZDBClose.close(stmt);
        if (!isTx) {
            conn.setAutoCommit(autoCommit);
            conn.close();
        }
    }

    @Override
    public int executeUpdateId(String id) throws ORMException, SQLException {
        return this.executeUpdate(id, null, null);
    }

    @Override
    public int executeUpdateId(String id, Object param) throws ORMException, SQLException {
        return this.executeUpdateId(id, param, null);
    }

    @Override
    public int executeUpdateId(String id, Object param, MapSS replaceMap) throws ORMException, SQLException {
        String sql = this.server.getSQL(id);
        if (sql == null) {
            throw new ORMException("ZSQL[executeUpdateId][" + id + "]\u672a\u627e\u5230\u914d\u7f6e");
        }
        return this.executeUpdate(sql, param, replaceMap);
    }

    @Override
    public int executeUpdate(String sql) throws ORMException, SQLException {
        return this.executeUpdate(sql, null, null);
    }

    @Override
    public int executeUpdate(String sql, Object param) throws ORMException, SQLException {
        return this.executeUpdate(sql, param, null);
    }

    @Override
    public int executeUpdate(String sql, Object param, MapSS replaceMap) throws ORMException, SQLException {
        UpdateExecutor updateExecutor = this.server.getUpdateExecutor(param);
        if (updateExecutor == null) {
            throw new ORMException("ZSQL[executeUpdate]\u4e0d\u652f\u6301\u7684\u53c2\u6570\u7c7b\u578b");
        }
        boolean isTx = true;
        Connection conn = (Connection)TransactionManager.getInstance((String)this.server.getId());
        if (conn == null) {
            isTx = false;
            conn = this.server.getConnection();
        }
        try {
            int n = updateExecutor.execute(this.server, conn, sql, param, replaceMap);
            return n;
        }
        finally {
            if (!isTx) {
                conn.close();
            }
        }
    }

    @Override
    public int[] executeBatchId(String id, List<?> paramList) throws ORMException, SQLException {
        return this.executeBatchId(id, paramList, null);
    }

    @Override
    public int[] executeBatchId(String id, List<?> paramList, MapSS replaceMap) throws ORMException, SQLException {
        String sql = this.server.getSQL(id);
        if (sql == null) {
            throw new ORMException("ZSQL[executeBatchId][" + id + "]\u672a\u627e\u5230\u914d\u7f6e");
        }
        return this.executeBatch(sql, paramList, replaceMap);
    }

    @Override
    public int[] executeBatch(String sql, List<?> paramList) throws ORMException, SQLException {
        return this.executeBatch(sql, paramList, null);
    }

    @Override
    public int[] executeBatch(String sql, List<?> paramList, MapSS replaceMap) throws ORMException, SQLException {
        if (paramList == null || paramList.isEmpty()) {
            return new int[0];
        }
        BatchExecutor batchExecutor = this.server.getBatchExecutor(paramList.get(0));
        if (batchExecutor == null) {
            throw new ORMException("ZSQL[executeBatch]\u4e0d\u652f\u6301\u7684\u53c2\u6570\u7c7b\u578b");
        }
        boolean isTx = true;
        Connection conn = (Connection)TransactionManager.getInstance((String)this.server.getId());
        if (conn == null) {
            isTx = false;
            conn = this.server.getConnection();
        }
        boolean autoCommit = true;
        try {
            autoCommit = conn.getAutoCommit();
            if (!isTx) {
                conn.setAutoCommit(false);
            }
            int[] result = batchExecutor.execute(this.server, conn, sql, paramList, replaceMap);
            if (!isTx) {
                conn.commit();
            }
            int[] nArray = result;
            return nArray;
        }
        catch (SQLException | ORMException e) {
            if (!isTx) {
                conn.rollback();
            }
            throw e;
        }
        finally {
            if (!isTx) {
                conn.setAutoCommit(autoCommit);
                conn.close();
            }
        }
    }

    @Override
    public <T> List<T> executeQueryId(String id, Class<T> resultClass) throws ORMException, SQLException {
        return this.executeQueryId(id, resultClass, null, null);
    }

    @Override
    public <T> List<T> executeQueryId(String id, Class<T> resultClass, Object param) throws ORMException, SQLException {
        return this.executeQueryId(id, resultClass, param, null);
    }

    @Override
    public <T> List<T> executeQueryId(String id, Class<T> resultClass, Object param, MapSS replaceMap) throws ORMException, SQLException {
        String sql = this.server.getSQL(id);
        if (sql == null) {
            throw new ORMException("ZSQL[executeQueryId][" + id + "]\u672a\u627e\u5230\u914d\u7f6e");
        }
        return this.executeQuery(sql, resultClass, param, replaceMap);
    }

    @Override
    public List<LinkedMapSO> executeQuery(String sql) throws ORMException, SQLException {
        return this.executeQuery(sql, LinkedMapSO.class);
    }

    @Override
    public <T> List<T> executeQuery(String sql, Class<T> resultClass) throws ORMException, SQLException {
        return this.executeQuery(sql, resultClass, null, null);
    }

    @Override
    public <T> List<T> executeQuery(String sql, Class<T> resultClass, Object param) throws ORMException, SQLException {
        return this.executeQuery(sql, resultClass, param, null);
    }

    @Override
    public <T> List<T> executeQuery(String sql, Class<T> resultClass, Object param, MapSS replaceMap) throws ORMException, SQLException {
        QueryExecutor queryExecutor = this.server.getQueryExecutor(param, resultClass);
        if (queryExecutor == null) {
            throw new ORMException("ZSQL[executeQuery]\u4e0d\u652f\u6301\u7684\u53c2\u6570\u6216\u7ed3\u679c\u7c7b\u578b");
        }
        boolean isTx = true;
        Connection conn = (Connection)TransactionManager.getInstance((String)this.server.getId());
        if (conn == null) {
            isTx = false;
            conn = this.server.getConnection();
        }
        try {
            List<?> list = queryExecutor.execute(this.server, conn, sql, resultClass, param, replaceMap);
            return list;
        }
        finally {
            if (!isTx) {
                conn.close();
            }
        }
    }

    @Override
    public void call(String sql, List<CallParam> paramList) throws ORMException, SQLException {
        this.call(sql, paramList, null, null);
    }

    @Override
    public void call(String sql, List<CallParam> paramList, MapSS replaceMap) throws ORMException, SQLException {
        this.call(sql, paramList, null, replaceMap);
    }

    @Override
    public <T> List<T> call(String sql, List<CallParam> paramList, Class<T> resultClass) throws ORMException, SQLException {
        ArrayList<CallResult> resultList = new ArrayList<CallResult>(1);
        resultList.add(CallResult.set(resultClass));
        this.call(sql, paramList, resultList, null);
        return ((CallResult)resultList.get(0)).getResultList();
    }

    @Override
    public void call(String sql, List<CallParam> paramList, List<CallResult> resultList) throws ORMException, SQLException {
        this.call(sql, paramList, resultList, null);
    }

    @Override
    public void call(String sql, List<CallParam> paramList, List<CallResult> resultList, MapSS replaceMap) throws ORMException, SQLException {
        boolean isTx = true;
        Connection conn = (Connection)TransactionManager.getInstance((String)this.server.getId());
        if (conn == null) {
            isTx = false;
            conn = this.server.getConnection();
        }
        try {
            CallExecutor executor = this.server.getCallExecutor();
            executor.execute(this.server, conn, sql, paramList, resultList, replaceMap);
        }
        finally {
            if (!isTx) {
                conn.close();
            }
        }
    }

    @Override
    public boolean existTable(String table) throws ORMException, SQLException {
        String sql = this.server.getPolicy().toExistsSQL(this.server.getDatabaseName(), table);
        List<Integer> result = this.executeQuery(sql, Integer.class);
        return result.get(0) > 0;
    }
}

