/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.orm.dbo;

import org.zhiqim.kernel.extend.MapSS;
import org.zhiqim.orm.dbo.BatchType;
import org.zhiqim.orm.dbo.Selector;
import org.zhiqim.orm.dbo.Updater;

public class Batcher {
    private BatchType type;
    private Object insertData;
    private MapSS insertReplaceMap;
    private Object replaceData;
    private MapSS replaceReplaceMap;
    private Object insertOrUpdateData;
    private Updater insertOrUpdateUpdater;
    private Object updateData;
    private MapSS updateReplaceMap;
    private Class<?> updaterClass;
    private Updater updaterUpdater;
    private Class<?> deleteClass;
    private MapSS deleteReplaceMap;
    private Object[] deleteIds;
    private Selector deleteSelector;

    public Batcher insert(Object data) {
        this.insertData = data;
        this.type = BatchType.INSERT;
        return this;
    }

    public Batcher insert(Object data, MapSS replaceMap) {
        this.insertData = data;
        this.insertReplaceMap = replaceMap;
        this.type = BatchType.INSERT;
        return this;
    }

    public Batcher insertOrUpdate(Object data, Updater updater) {
        this.insertOrUpdateData = data;
        this.insertOrUpdateUpdater = updater;
        this.type = BatchType.INSERT_OR_UPDATE;
        return this;
    }

    public Batcher replace(Object data) {
        this.replaceData = data;
        this.type = BatchType.REPLACE;
        return this;
    }

    public Batcher replace(Object data, MapSS replaceMap) {
        this.replaceData = data;
        this.replaceReplaceMap = replaceMap;
        this.type = BatchType.REPLACE;
        return this;
    }

    public Batcher update(Class<?> cls, Updater updater) {
        this.updaterClass = cls;
        this.updaterUpdater = updater;
        this.type = BatchType.UPDATE;
        return this;
    }

    public Batcher update(Object data) {
        this.updateData = data;
        this.type = BatchType.UPDATE;
        return this;
    }

    public Batcher update(Object data, MapSS replaceMap) {
        this.updateData = data;
        this.updateReplaceMap = replaceMap;
        return this;
    }

    public Batcher delete(Class<?> cls, Object ... ids) {
        this.deleteClass = cls;
        this.deleteIds = ids;
        this.type = BatchType.DELETE_ID;
        return this;
    }

    public Batcher delete(Class<?> cls, MapSS replaceMap, Object ... ids) {
        this.deleteClass = cls;
        this.deleteReplaceMap = replaceMap;
        this.deleteIds = ids;
        this.type = BatchType.DELETE_ID;
        return this;
    }

    public Batcher delete(Class<?> cls, Selector selector) {
        this.deleteClass = cls;
        this.deleteSelector = selector == null ? new Selector() : selector;
        this.type = BatchType.DELETE_SELECTOR;
        return this;
    }

    public BatchType getType() {
        return this.type;
    }

    public Object getInsertData() {
        return this.insertData;
    }

    public MapSS getInsertReplaceMap() {
        return this.insertReplaceMap;
    }

    public Object getReplaceData() {
        return this.replaceData;
    }

    public MapSS getReplaceReplaceMap() {
        return this.replaceReplaceMap;
    }

    public Object getInsertOrUpdateData() {
        return this.insertOrUpdateData;
    }

    public Updater getInsertOrUpdateUpdater() {
        return this.insertOrUpdateUpdater;
    }

    public Object getUpdateData() {
        return this.updateData;
    }

    public MapSS getUpdateReplaceMap() {
        return this.updateReplaceMap;
    }

    public Class<?> getUpdaterClass() {
        return this.updaterClass;
    }

    public Updater getUpdaterUpdater() {
        return this.updaterUpdater;
    }

    public Class<?> getDeleteClass() {
        return this.deleteClass;
    }

    public MapSS getDeleteReplaceMap() {
        return this.deleteReplaceMap;
    }

    public Object[] getDeleteIds() {
        return this.deleteIds;
    }

    public Selector getDeleteSelector() {
        return this.deleteSelector;
    }
}

