/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.orm.datasource;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import org.zhiqim.kernel.extend.MapSO;
import org.zhiqim.kernel.util.Hexs;
import org.zhiqim.kernel.util.Replaces;
import org.zhiqim.kernel.util.Sqls;
import org.zhiqim.orm.ORMServer;

public class ZStatement {
    public static String setParameter(ORMServer server, PreparedStatement pstmt, int index, Object value, String str) throws SQLException, IOException {
        if (value == null) {
            pstmt.setNull(index, 1);
            str = str.replaceFirst("\\?", "null");
        } else if (value instanceof Boolean) {
            pstmt.setBoolean(index, (Boolean)value);
            str = str.replaceFirst("\\?", String.valueOf(value));
        } else if (value instanceof Byte) {
            pstmt.setByte(index, (Byte)value);
            str = str.replaceFirst("\\?", String.valueOf(value));
        } else if (value instanceof Short) {
            pstmt.setShort(index, (Short)value);
            str = str.replaceFirst("\\?", String.valueOf(value));
        } else if (value instanceof Integer) {
            pstmt.setInt(index, (Integer)value);
            str = str.replaceFirst("\\?", String.valueOf(value));
        } else if (value instanceof Long) {
            pstmt.setLong(index, (Long)value);
            str = str.replaceFirst("\\?", String.valueOf(value));
        } else if (value instanceof Timestamp) {
            Timestamp time = (Timestamp)value;
            pstmt.setTimestamp(index, time);
            str = str.replaceFirst("\\?", "'" + Sqls.toDateTimeString((Timestamp)time) + "'");
        } else if (value instanceof Date) {
            Date date = (Date)value;
            pstmt.setDate(index, date);
            str = str.replaceFirst("\\?", "'" + Sqls.toDateString((Date)date) + "'");
        } else if (value instanceof Time) {
            Time time = (Time)value;
            pstmt.setTime(index, time);
            str = str.replaceFirst("\\?", "'" + Sqls.toTimeString((Time)time) + "'");
        } else if (value instanceof String) {
            String v = (String)value;
            if (v.length() <= 2000) {
                pstmt.setString(index, v);
            } else if (server.isOracle()) {
                CLOB clob = CLOB.createTemporary((Connection)pstmt.getConnection(), (boolean)false, (int)10);
                clob.open(1);
                Writer writer = clob.getCharacterOutputStream();
                writer.write(v);
                writer.close();
                clob.close();
                pstmt.setClob(index, (Clob)clob);
            } else {
                StringReader reader = new StringReader(v);
                pstmt.setCharacterStream(index, (Reader)reader, v.length());
            }
            v = v.replaceAll("'", "''");
            if (v.indexOf("?") != -1) {
                v = v.replaceAll("\\?", "-%6-%-3%-");
            }
            v = Replaces.toReplaceEscape((String)v);
            str = str.replaceFirst("\\?", "'" + v + "'");
        } else if (value instanceof byte[]) {
            byte[] v = (byte[])value;
            if (!server.isOracle()) {
                pstmt.setBytes(index, v);
            } else {
                BLOB blob = BLOB.createTemporary((Connection)pstmt.getConnection(), (boolean)false, (int)10);
                blob.open(1);
                OutputStream os = blob.getBinaryOutputStream();
                os.write(v);
                os.close();
                blob.close();
                pstmt.setBlob(index, (Blob)blob);
            }
            str = str.replaceFirst("\\?", "'" + Hexs.toHexString((byte[])v) + "'");
        } else {
            pstmt.setObject(index, value);
            str = str.replaceFirst("\\?", String.valueOf(value));
        }
        return str;
    }

    public static void setParameter(ORMServer server, PreparedStatement pstmt, int index, Object value) throws SQLException, IOException {
        if (value == null) {
            pstmt.setNull(index, 1);
        } else if (value instanceof Boolean) {
            pstmt.setBoolean(index, (Boolean)value);
        } else if (value instanceof Byte) {
            pstmt.setByte(index, (Byte)value);
        } else if (value instanceof Short) {
            pstmt.setShort(index, (Short)value);
        } else if (value instanceof Integer) {
            pstmt.setInt(index, (Integer)value);
        } else if (value instanceof Long) {
            pstmt.setLong(index, (Long)value);
        } else if (value instanceof Timestamp) {
            pstmt.setTimestamp(index, (Timestamp)value);
        } else if (value instanceof Date) {
            pstmt.setDate(index, (Date)value);
        } else if (value instanceof Time) {
            pstmt.setTime(index, (Time)value);
        } else if (value instanceof String) {
            String v = (String)value;
            if (v.length() <= 2000) {
                pstmt.setString(index, (String)value);
            } else if (server.isOracle()) {
                CLOB clob = CLOB.createTemporary((Connection)pstmt.getConnection(), (boolean)false, (int)10);
                clob.open(1);
                Writer writer = clob.getCharacterOutputStream();
                writer.write(v);
                writer.close();
                clob.close();
                pstmt.setClob(index, (Clob)clob);
            } else {
                StringReader reader = new StringReader(v);
                pstmt.setCharacterStream(index, (Reader)reader, v.length());
            }
        } else if (value instanceof byte[]) {
            byte[] v = (byte[])value;
            if (!server.isOracle()) {
                pstmt.setBytes(index, v);
            } else {
                BLOB blob = BLOB.createTemporary((Connection)pstmt.getConnection(), (boolean)false, (int)10);
                blob.open(1);
                OutputStream os = blob.getBinaryOutputStream();
                os.write(v);
                os.close();
                blob.close();
                pstmt.setBlob(index, (Blob)blob);
            }
        } else {
            pstmt.setObject(index, value);
        }
    }

    public static String paramMapString(String sql, List<String> paramKeyList) {
        int i = 0;
        int start = 0;
        int end = sql.indexOf(35);
        while (end != -1) {
            if (i % 2 != 0) {
                String paramKey = sql.substring(start + 1, end);
                paramKeyList.add(paramKey);
            }
            ++i;
            start = end;
            end = sql.indexOf(35, start + 1);
        }
        i = 0;
        while (i < paramKeyList.size()) {
            String paramKey = paramKeyList.get(i);
            sql = sql.replaceAll("#" + paramKey + "#", "?");
            ++i;
        }
        return sql;
    }

    public static String paramMapString(String sql, MapSO paramMap) {
        ArrayList<String> paramKeyList = new ArrayList<String>();
        int i = 0;
        int start = 0;
        int end = sql.indexOf(35);
        while (end != -1) {
            if (i % 2 != 0) {
                String paramKey = sql.substring(start + 1, end);
                paramKeyList.add(paramKey);
            }
            ++i;
            start = end;
            end = sql.indexOf(35, start + 1);
        }
        i = 0;
        while (i < paramKeyList.size()) {
            String paramKey = (String)paramKeyList.get(i);
            Object paramValue = paramMap.get(paramKey);
            sql = sql.replaceAll("#" + paramKey + "#", "'" + paramValue + "'");
            ++i;
        }
        return sql;
    }
}

