/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.orm.datasource;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.orm.datasource.ZConnection;
import org.zhiqim.orm.datasource.ZDBClose;
import org.zhiqim.orm.datasource.ZDataSource;

public class ZConnectionTester {
    private static final Log log = LogFactory.getLog((String)"database.log");
    public static final int CONNECTION_IS_OKAY = 0;
    public static final int CONNECTION_IS_INVALID = -1;
    public static final int DATABASE_IS_INVALID = -8;
    private static final Set<String> INVALID_DB_STATES;
    private ZDataSource dataSource = null;
    private ZConnection testconnection = null;

    static {
        HashSet<String> temp = new HashSet<String>();
        temp.add("08001");
        temp.add("08007");
        temp.add(null);
        temp.add("08S01");
        INVALID_DB_STATES = Collections.unmodifiableSet(temp);
    }

    public ZConnectionTester(ZDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public boolean isDbBreak() {
        int status;
        if (this.testconnection == null) {
            this.testconnection = this.dataSource.newProxyConnection("\u6d4b\u8bd5");
            if (this.testconnection == null) {
                return true;
            }
        }
        if (this.testconnection.isClosed() || this.testconnection.isKeepOrIdleTimeout()) {
            this.testconnection.shutdown();
            this.testconnection = null;
            this.testconnection = this.dataSource.newProxyConnection("\u6d4b\u8bd5");
            if (this.testconnection == null) {
                return true;
            }
        }
        if ((status = this.isConnectionAvailable(this.testconnection)) == 0) {
            return false;
        }
        this.testconnection.shutdown();
        this.testconnection = null;
        return true;
    }

    public int isConnectionAvailable(Connection connection) {
        if (connection == null) {
            return -1;
        }
        ResultSet rst = null;
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            rst = metaData.getTables(null, null, "PROBABLYNOT", new String[]{"TABLE"});
        }
        catch (SQLException e) {
            block6: {
                try {
                    String state = e.getSQLState();
                    if (!INVALID_DB_STATES.contains(state)) break block6;
                    log.error((Object)"\u68c0\u67e5\u6570\u636e\u5e93\u8fde\u63a5\u662f\u5426\u53ef\u7528\u65f6:\u6570\u636e\u5e93\u4e0d\u53ef\u7528");
                }
                catch (Throwable throwable) {
                    ZDBClose.close(rst);
                    throw throwable;
                }
                ZDBClose.close(rst);
                return -8;
            }
            log.error((Object)"\u68c0\u67e5\u6570\u636e\u5e93\u8fde\u63a5\u662f\u5426\u53ef\u7528\u65f6:\u8fde\u63a5\u4e0d\u53ef\u7528");
            ZDBClose.close(rst);
            return -1;
        }
        ZDBClose.close(rst);
        return 0;
    }

    public void shutdown() {
        if (this.testconnection != null) {
            this.testconnection.shutdown();
            this.testconnection = null;
        }
    }
}

