/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.orm.cache;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.zhiqim.kernel.extend.HashMapCO;
import org.zhiqim.kernel.extend.HashMapCV;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.paging.PageBuilder;
import org.zhiqim.kernel.paging.PageResult;
import org.zhiqim.kernel.schedule.Scheduler;
import org.zhiqim.kernel.schedule.TaskThreader;
import org.zhiqim.kernel.util.Arrays;
import org.zhiqim.kernel.util.Classes;
import org.zhiqim.kernel.util.Lists;
import org.zhiqim.kernel.util.Objects;
import org.zhiqim.orm.ORMException;
import org.zhiqim.orm.ORMServer;
import org.zhiqim.orm.cache.ZTableCacheKey;
import org.zhiqim.orm.dbo.Comparator;
import org.zhiqim.orm.dbo.Condition;
import org.zhiqim.orm.dbo.Selector;
import org.zhiqim.orm.dbo.condition._Equal;
import org.zhiqim.orm.dbo.defined._Table;
import org.zhiqim.orm.impl.ZTableImplement;

public final class ZTableCache {
    private static final Log log = LogFactory.getLog(ZTableCache.class);
    private final ORMServer server;
    private final HashMapCO lockMap;
    private final HashMapCV<List<?>> cache;
    private final HashMapCV<HashMap<ZTableCacheKey, ?>> index;
    private final Scheduler scheduler;

    public ZTableCache(ORMServer server) {
        this.server = server;
        this.lockMap = new HashMapCO();
        this.cache = new HashMapCV();
        this.index = new HashMapCV();
        this.scheduler = new Scheduler();
        this.scheduler.create();
    }

    public void schedule() {
        for (TaskThreader task : this.server.getCacheMap().values()) {
            this.scheduler.addTask(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void cache(Class<?> clazz, List<T> list) throws ORMException, SQLException {
        Object lock;
        Object object = lock = this.lock(clazz);
        synchronized (object) {
            List oList = (List)this.cache.remove(clazz);
            if (oList != null) {
                oList.clear();
                oList = null;
            }
            this.cache.put(clazz, list);
            _Table _table = ((ZTableImplement)this.server.table()).getTable(clazz);
            String[] keyFields = _table.getKeyFieldArr();
            if (keyFields.length == 0) {
                this.index.put(clazz, null);
            } else {
                HashMap<ZTableCacheKey, T> map = new HashMap<ZTableCacheKey, T>();
                for (T item : list) {
                    ZTableCacheKey key = new ZTableCacheKey(keyFields.length);
                    int i = 0;
                    while (i < keyFields.length) {
                        key.set(i, Classes.getFieldValue(item, (String)keyFields[i]));
                        ++i;
                    }
                    map.put(key, item);
                }
                this.index.put(clazz, map);
            }
        }
        log.info((Object)"\u5237\u65b0\u7f13\u5b58[%s]", new Object[]{clazz.getName()});
    }

    public <T> T item(Class<T> clazz) throws ORMException, SQLException {
        List<T> list = this.check(clazz);
        if (list.isEmpty()) {
            return null;
        }
        return (T)Objects.copy(list.get(0), (Object)Classes.newInstance(clazz));
    }

    public <T> T item(Class<T> clazz, Object ... ids) throws ORMException, SQLException {
        List<T> list = this.check(clazz);
        if (list.isEmpty()) {
            return null;
        }
        HashMap map = (HashMap)this.index.get(clazz);
        if (map == null) {
            return null;
        }
        return (T)map.get(new ZTableCacheKey(ids));
    }

    public <T> T item(Class<T> clazz, Selector selector) throws ORMException, SQLException {
        HashMap map;
        if (selector == null) {
            return this.item(clazz);
        }
        List<T> list = this.check(clazz);
        if (list.isEmpty()) {
            return null;
        }
        if (selector.hasCondition() && (map = (HashMap)this.index.get(clazz)) != null) {
            _Table _table = ((ZTableImplement)this.server.table()).getTable(clazz);
            Object[] keyFields = _table.getKeyFieldArr();
            ZTableCacheKey key = new ZTableCacheKey(keyFields.length);
            for (Condition condition : selector.getConditionList()) {
                _Equal equal;
                int idx;
                if (!(condition instanceof _Equal) || (idx = Arrays.indexOf((Object[])keyFields, (Object)(equal = (_Equal)condition).getField())) == -1) continue;
                key.set(idx, equal.getValue());
            }
            if (key.isAllKey()) {
                Object result = map.get(key);
                if (result == null) {
                    return null;
                }
                return (T)(this.match(result, selector) ? result : null);
            }
        }
        if ((list = this.fatch(clazz, list, selector)).isEmpty()) {
            return null;
        }
        return (T)Objects.copy(list.get(0), (Object)Classes.newInstance(clazz));
    }

    public <T> List<T> list(Class<T> clazz) throws ORMException, SQLException {
        return this.list(clazz, null);
    }

    public <T> List<T> list(Class<T> clazz, Selector selector) throws ORMException, SQLException {
        List<T> list = this.check(clazz);
        if (list.isEmpty()) {
            return new ArrayList();
        }
        list = this.fatch(clazz, list, selector);
        return this.copyList(clazz, list);
    }

    public <T> List<T> list(Class<T> clazz, int pageNo, int pageSize) throws ORMException, SQLException {
        return this.list(clazz, pageNo, pageSize, null);
    }

    public <T> List<T> list(Class<T> clazz, int pageNo, int pageSize, Selector selector) throws ORMException, SQLException {
        List list = this.check(clazz);
        if (list.isEmpty()) {
            return new ArrayList();
        }
        list = this.fatch(clazz, list, selector);
        list = PageBuilder.pageList((int)pageNo, (int)pageSize, list);
        return this.copyList(clazz, list);
    }

    public <T> PageResult<T> page(Class<T> clazz, int pageNo, int pageSize) throws ORMException, SQLException {
        return this.page(clazz, pageNo, pageSize, null);
    }

    public <T> PageResult<T> page(Class<T> clazz, int pageNo, int pageSize, Selector selector) throws ORMException, SQLException {
        if (selector == null) {
            return this.page(clazz, pageNo, pageSize);
        }
        List<T> list = this.check(clazz);
        if (list.isEmpty()) {
            return PageBuilder.newResult((int)pageNo, (int)pageSize);
        }
        list = this.fatch(clazz, list, selector);
        int total = list.size();
        list = PageBuilder.pageList((int)pageNo, (int)pageSize, list);
        list = this.copyList(clazz, list);
        return PageBuilder.newResult((int)total, (int)pageNo, (int)pageSize, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> List<T> check(Class<T> clazz) throws ORMException, SQLException {
        List list = (List)this.cache.get(clazz);
        if (list != null) {
            return list;
        }
        HashMapCV<List<?>> hashMapCV = this.cache;
        synchronized (hashMapCV) {
            list = (List)this.cache.get(clazz);
            if (list == null) {
                this.server.table().cache(clazz);
            }
        }
        if (list == null) {
            list = (List)this.cache.get(clazz);
        }
        return list;
    }

    private <T> List<T> fatch(Class<T> clazz, List<T> list, Selector selector) {
        if (selector == null || !selector.hasCondition() && !selector.hasOrderby()) {
            return list;
        }
        ArrayList<T> nList = null;
        if (!selector.hasCondition()) {
            nList = Lists.copy(list, (boolean)false);
        } else {
            nList = new ArrayList<T>();
            for (T item : list) {
                if (!this.match(item, selector)) continue;
                nList.add(item);
            }
        }
        if (nList.size() > 1 && selector.hasOrderby()) {
            Collections.sort(nList, new Comparator(selector));
        }
        return nList;
    }

    private <T> boolean match(T item, Selector selector) {
        for (Condition c : selector.getConditionList()) {
            if (c.match(item)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object lock(Class<?> clazz) {
        ZTableCache zTableCache = this;
        synchronized (zTableCache) {
            Object lock = this.lockMap.get(clazz);
            if (lock == null) {
                lock = new Object();
                this.lockMap.put(clazz, lock);
            }
            return lock;
        }
    }

    private <T> List<T> copyList(Class<T> clazz, List<T> list) {
        if (list.isEmpty()) {
            return new ArrayList();
        }
        ArrayList<Object> cList = new ArrayList<Object>(list.size());
        for (T item : list) {
            cList.add(Objects.copy(item, (Object)Classes.newInstance(clazz)));
        }
        return Lists.trim(cList);
    }
}

