/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.orm;

import java.util.ArrayList;
import java.util.List;
import org.zhiqim.kernel.extend.LinkedMapSV;
import org.zhiqim.kernel.extend.MapSV;
import org.zhiqim.kernel.util.consts.Int;
import org.zhiqim.orm.ORMConstants;
import org.zhiqim.orm.ORMPolicy;
import org.zhiqim.orm.ORMServer;
import org.zhiqim.orm.policy._HSQL;
import org.zhiqim.orm.policy._MSSQL;
import org.zhiqim.orm.policy._MySQL;
import org.zhiqim.orm.policy._Oracle;
import org.zhiqim.orm.policy._PostgetSQL;
import org.zhiqim.orm.policy._SQLite;

public class ORMType
implements ORMConstants {
    private static final MapSV<Int> DB_TYPE_MAP = new LinkedMapSV();
    private static final MapSV<Int> DC_TYPE_MAP = new LinkedMapSV();

    static {
        DB_TYPE_MAP.put(Z_ORM_MYSQL.desc(), (Object)Z_ORM_MYSQL);
        DB_TYPE_MAP.put(Z_ORM_ORACLE.desc(), (Object)Z_ORM_ORACLE);
        DB_TYPE_MAP.put(Z_ORM_MSSQL.desc(), (Object)Z_ORM_MSSQL);
        DB_TYPE_MAP.put(Z_ORM_PSQL.desc(), (Object)Z_ORM_PSQL);
        DB_TYPE_MAP.put(Z_ORM_SQLITE.desc(), (Object)Z_ORM_SQLITE);
        DB_TYPE_MAP.put(Z_ORM_HSQL.desc(), (Object)Z_ORM_HSQL);
        DC_TYPE_MAP.put(Z_ORM_STRING.desc(), (Object)Z_ORM_STRING);
        DC_TYPE_MAP.put(Z_ORM_INT.desc(), (Object)Z_ORM_INT);
        DC_TYPE_MAP.put(Z_ORM_LONG.desc(), (Object)Z_ORM_LONG);
        DC_TYPE_MAP.put(Z_ORM_BOOLEAN.desc(), (Object)Z_ORM_BOOLEAN);
        DC_TYPE_MAP.put(Z_ORM_BYTE.desc(), (Object)Z_ORM_BYTE);
        DC_TYPE_MAP.put(Z_ORM_SHORT.desc(), (Object)Z_ORM_SHORT);
        DC_TYPE_MAP.put(Z_ORM_DATETIME.desc(), (Object)Z_ORM_DATETIME);
        DC_TYPE_MAP.put(Z_ORM_DECIMAL.desc(), (Object)Z_ORM_DECIMAL);
        DC_TYPE_MAP.put(Z_ORM_BINARY.desc(), (Object)Z_ORM_BINARY);
    }

    public static ORMPolicy getDatabasePolicy(ORMServer server, String dbType) {
        Int value = (Int)DB_TYPE_MAP.get(dbType);
        if (value == null) {
            return null;
        }
        switch (value.value()) {
            case 1: {
                return new _MySQL(server);
            }
            case 2: {
                return new _Oracle(server);
            }
            case 3: {
                return new _MSSQL(server);
            }
            case 4: {
                return new _PostgetSQL(server);
            }
            case 5: {
                return new _SQLite(server);
            }
            case 6: {
                return new _HSQL(server);
            }
        }
        return null;
    }

    public static Int getDatabaseType(String dbType) {
        return (Int)DB_TYPE_MAP.get(dbType);
    }

    public static boolean isDatabaseTypeSql(String name, String dbType) {
        boolean isSpecified = false;
        for (String s : DB_TYPE_MAP.keySet()) {
            if (!name.endsWith("." + s + ".sql.xml")) continue;
            isSpecified = true;
            break;
        }
        if (!isSpecified) {
            return true;
        }
        return name.endsWith("." + dbType + ".sql.xml");
    }

    public static List<String> getDatabaseTypeList() {
        ArrayList<String> list = new ArrayList<String>(DB_TYPE_MAP.size());
        for (String key : DB_TYPE_MAP.keySet()) {
            list.add(key);
        }
        return list;
    }

    public static String[] getDatabaseTypes() {
        String[] types = new String[DB_TYPE_MAP.size()];
        int i = 0;
        for (String key : DB_TYPE_MAP.keySet()) {
            types[i++] = key;
        }
        return types;
    }

    public static boolean isSupportColumn(String columnType) {
        return DC_TYPE_MAP.containsKey(columnType);
    }

    public static boolean hasColumnLength(String columnType) {
        Int value = (Int)DC_TYPE_MAP.get(columnType);
        return value == null ? false : ORMType.hasColumnLength(value.value());
    }

    public static boolean hasColumnLength(int columnType) {
        return columnType == 1 || columnType == 8;
    }

    public static int getColumnTypeMaybeLength(String columnTypeMaybeLength) {
        int ind = columnTypeMaybeLength.indexOf(",");
        if (ind == -1) {
            return ORMType.getColumnType(columnTypeMaybeLength).value();
        }
        String ctype = columnTypeMaybeLength.substring(0, ind);
        return ORMType.getColumnType(ctype).value();
    }

    public static Int getColumnType(String columnType) {
        return (Int)DC_TYPE_MAP.get(columnType);
    }

    public static List<String> getColumnTypeList() {
        ArrayList<String> list = new ArrayList<String>(DC_TYPE_MAP.size());
        for (String key : DC_TYPE_MAP.keySet()) {
            list.add(key);
        }
        return list;
    }

    public static String[] getColumnTypes() {
        String[] types = new String[DC_TYPE_MAP.size()];
        int i = 0;
        for (String key : DC_TYPE_MAP.keySet()) {
            types[i++] = key;
        }
        return types;
    }

    public static String toUpperName(String name) {
        return String.valueOf(name.substring(0, 1).toUpperCase()) + ORMType.toTableFieldName(name.substring(1));
    }

    public static String toLowerName(String name) {
        return String.valueOf(name.substring(0, 1).toLowerCase()) + ORMType.toTableFieldName(name.substring(1));
    }

    private static String toTableFieldName(String name) {
        StringBuilder strb = new StringBuilder();
        boolean nextWord = false;
        boolean nextReplace = false;
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (c == '_') {
                nextWord = true;
            } else if (c == '$') {
                nextReplace = !nextReplace;
                strb.append("_");
            } else if (nextWord) {
                strb.append(String.valueOf(c).toUpperCase());
                nextWord = false;
            } else if (nextReplace) {
                strb.append(String.valueOf(c).toUpperCase());
            } else {
                strb.append(String.valueOf(c).toLowerCase());
            }
            ++i;
        }
        return strb.toString();
    }
}

