/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_manager.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.manager.presenter;

import java.util.List;

import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.ZmlContexts;
import org.zhiqim.httpd.context.annotation.AnIntercept;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.extend.HashMapSO;
import org.zhiqim.kernel.extend.MapSO;
import org.zhiqim.kernel.tree.Tree;
import org.zhiqim.kernel.tree.TreeBuilder;
import org.zhiqim.manager.ZmrBootstrap;
import org.zhiqim.manager.ZmrConstants;
import org.zhiqim.manager.ZmrSessionUser;
import org.zhiqim.manager.dao.ZmrOrgDao;
import org.zhiqim.manager.dbo.ZmrMenu;
import org.zhiqim.manager.dbo.ZmrOrg;
import org.zhiqim.manager.dbo.ZmrOrgRule;
import org.zhiqim.orm.dbo.Selector;
/**
 * 组织控制器
 *
 * @version v1.0.0 @author liuhu 2018-8-10 新建与整理
 */
@AnAlias("ZmrOrgPresenter")
@AnIntercept("chkZmrLogin")
public class ZmrOrgPresenter implements ZmrConstants
{
    /**
     * 组织权限列表
     * @param request
     * @throws Exception
     */
    public static void doShowOrgRuleList(HttpRequest request) throws Exception
    {
        long orgId = request.getParameterLong("orgId");
        if (orgId == -1)
        {
            request.setResponseError("您选择的组织不存在，请选择一个有效的组织");
            return;
        }
        
        ZmrOrg org = ZmrBootstrap.tableOpr(request).item(ZmrOrg.class, orgId);
        if (org == null)
        {
            request.setResponseError("您选择的组织不存在，请选择一个有效的组织");
            return;
        }
        
        if(org.getOrgLevel() == 0)
            ZmrOrgDao.setTopOrgRule(request, orgId);
        
        //获取已拥有的权限
        List<ZmrOrgRule> ruleList = ZmrBootstrap.table(request).list(ZmrOrgRule.class, new Selector("orgId", orgId));
        
        // 获取能管理的权限
        ZmrSessionUser sessionUser = request.getSessionUser(ZmrSessionUser.class);
        List<ZmrMenu> list = sessionUser.getMenuList();
        Tree<ZmrMenu> tree = TreeBuilder.newTree(list, "parentCode", "menuCode");
        
        MapSO variable = new HashMapSO();
        variable.put("org", org);
        variable.put("tree", tree);
        variable.put("menuSize", list.size());
        variable.put("ruleList", ruleList);
        
        String responseText = ZmlContexts.parseZmlPath(request, "/zview/zhiqim_manager/presenter/orgRuleInfo.zml", variable);
        request.setResponseResult(responseText);
    }
    
    /**
     * 切换组织
     * @param request
     * @throws Exception
     */
    public static void doSelOrg(HttpRequest request) throws Exception
    {
        long orgId = request.getParameterLong("orgId");
        ZmrSessionUser sessionUser = request.getSessionUser(ZmrSessionUser.class);
        sessionUser.setSelectedOrgId(orgId);
        sessionUser.setValue(ZMR_SESSION_USER_DEPT_ID, "zmr_session_user_dept_id");
        sessionUser.setValue(ZMR_SESSION_USER_ROLE_ID, "zmr_session_user_role_id");
    }
}
