package org.zhiqim.manager.messagebox;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.rocketmq.client.consumer.MQPushConsumer;
import org.apache.rocketmq.client.exception.MQClientException;
import org.zhiqim.httpd.HttpWebsocketConnection;
import org.zhiqim.kernel.Global;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.manager.util.TaoYinTongClientUtil;

public final class ZqmMessageUtil
{

    private static final Log log = LogFactory.getLog(ZqmMessageUtil.class);

    private static final ConcurrentHashMap<String, ZqmLoginUser> userMap = new ConcurrentHashMap<>(50);
    private static final ConcurrentHashMap<HttpWebsocketConnection, ZqmLoginUser> connectionMap = new ConcurrentHashMap<>(50);

    /**
     * 根据userId获取通道
     *
     * @param userId
     * @return
     */
    public static ZqmLoginUser getUserById(String userId)
    {
        return userMap.get(userId);
    }

    /**
     * 根据通道销毁缓存数据
     *
     * @param channel
     * @return
     */
    public static boolean removeConnection(HttpWebsocketConnection connection)
    {
        ZqmLoginUser user = connectionMap.get(connection);
        if (user != null)
        {
            connectionMap.remove(connection);
            user.destroyConnection(connection);
            if (!user.hasConnections())
            {
                userMap.remove(user.getUserId());
            }
        }
        return true;
    }

    /**
     * 添加用户通道映射
     *
     * @param userId
     * @param connection
     * @return
     */
    public static boolean putUserChannel(String userId, HttpWebsocketConnection connection) throws MQClientException
    {

        ZqmLoginUser user = userMap.get(userId);
        List<HttpWebsocketConnection> connectionList = null;
        List<MQPushConsumer> consumerList = null;
        if (user == null)
        {
            connectionList = new ArrayList<>();
            consumerList = new ArrayList<>();
            MQPushConsumer consumer;
            try
            {
                consumer = ZqmMessageBoxMQConsumerFactory.getUserMQConsumer(1, userId);

                connectionList.add(connection);
                consumerList.add(consumer);
                user = new ZqmLoginUser(userId, connectionList, consumerList);
                userMap.put(userId, user);
            }
            catch (Exception e)
            {
                log.error(e);
            }
        }
        else
        {
            connectionList = user.getConnections();
            consumerList = user.getConsumers();
        }
        if (!connectionList.contains(connection))
        {
            connectionList.add(connection);
        }
        connectionMap.put(connection, user);
        return true;
    }

    public static void readMessages(String ids)
    {
        if (ids == null || ids.isEmpty())
        {
            return;
        }
        StringBuffer url = new StringBuffer();
        url.append(Global.getString("message-box", "busiAddress"));
        url.append("readMessages?ids=");
        url.append(ids);
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpPost post = new HttpPost(url.toString());
        post.setHeader("Authorization", "bearer " + TaoYinTongClientUtil.getAccessToken());
        try
        {
            HttpResponse resultRep = httpclient.execute(post);
            int statusCode = resultRep.getStatusLine().getStatusCode();
            if (statusCode == 200)
            {
                log.info("已读信息状态成功");
            }
            else
            {
                log.error("已读信息状态失败(非重要)");
            }
        }
        catch (IOException e)
        {
            log.error("已读信息状态失败(非重要)");
        }
    }

    public static void consumeMessages(String ids)
    {
        if (ids == null || ids.isEmpty())
        {
            return;
        }
        StringBuffer url = new StringBuffer();
        url.append(Global.getString("message-box", "busiAddress"));
        url.append("consumeMessage?ids=");
        url.append(ids);
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpPost post = new HttpPost(url.toString());
        post.setHeader("Authorization", "bearer " + TaoYinTongClientUtil.getAccessToken());
        try
        {
            HttpResponse resultRep = httpclient.execute(post);
            int statusCode = resultRep.getStatusLine().getStatusCode();
            if (statusCode == 200)
            {
                log.info("更新消息消费状态成功");
            }
            else
            {
                log.error("更新消息消费状态失败(非重要)");
            }
        }
        catch (IOException e)
        {
            log.error("更新消息消费状态失败(非重要)");
        }
    }
}
