package org.zhiqim.manager.messagebox;

import static org.apache.rocketmq.client.producer.SendStatus.SEND_OK;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.rocketmq.client.producer.MQProducer;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.zhiqim.kernel.Global;
import org.zhiqim.manager.util.TaoYinTongClientUtil;

import yangcai.messagebox.model.MessageBusi;
import yangcai.messagebox.model.MessageResult;

import com.alibaba.fastjson.JSONObject;

public class ZqmMessageProducerHandler
{

    private static final Log log = LogFactory.getLog(ZqmMessageProducerHandler.class);

    public static MessageResult<Object> sendMessage(MessageBusi messageBusi, HashMap<String, String> propertyMap)
    {
        String sysCode = Global.getString("message-box", "sysCode");
        // 单条消息准备
        messageBusi.setState(1);
        messageBusi.setSendTime(new Date());
        if (StringUtils.isEmpty(messageBusi.getProducerPlatformType()))
        {
            messageBusi.setProducerPlatformType(sysCode);
        }

        StringBuffer groupName = new StringBuffer();
        groupName.append(sysCode);
        groupName.append("-");
        groupName.append(messageBusi.getProducerOperateType());
        groupName.append("-");
        groupName.append(messageBusi.getProducerOperateCode());
        groupName.append("-producerGroup");
        try
        {
            messageBusi.setProducerGroup(URLEncoder.encode(groupName.toString(), "GBK"));
            StringBuffer topicName = new StringBuffer();
            topicName.append(messageBusi.getConsumerPlatformType());
            topicName.append("-");
            topicName.append(messageBusi.getConsumerOperateType());
            topicName.append("-");
            topicName.append(messageBusi.getConsumerOperateCode());
            topicName.append("-topic");

            messageBusi.setTopic(URLEncoder.encode(topicName.toString(), "GBK"));
        }
        catch (UnsupportedEncodingException e)
        {
            log.error(e);
        }
        Message msg = null;
        try
        {
            msg = new Message(messageBusi.getTopic(), messageBusi.getTags(), messageBusi.getId(), messageBusi.getMessageBody().getBytes(
                    RemotingHelper.DEFAULT_CHARSET));
        }
        catch (UnsupportedEncodingException e)
        {
            return MessageResult.failed("messageBusi.getMessageBody() is wrong");
        }
        if (null != propertyMap)
        {
            for (Map.Entry<String, String> entry : propertyMap.entrySet())
            {
                msg.putUserProperty(entry.getKey(), entry.getValue());
            }
            messageBusi.setProperty(JSONObject.toJSONString(propertyMap));
        }
        msg.putUserProperty("messageBusi", JSONObject.toJSONString(messageBusi));

        // 单条消息保存并发送
        HttpPost post = new HttpPost(Global.getString("message-box", "busiAddress") + "save");
        post.setHeader("Authorization", "bearer " + TaoYinTongClientUtil.getAccessToken());
        CloseableHttpClient httpclient = HttpClients.createDefault();
        StringEntity stringEntity = new StringEntity(JSONObject.toJSONString(messageBusi), ContentType.APPLICATION_JSON);
        post.setEntity(stringEntity);
        try
        {
            HttpResponse resultRep = httpclient.execute(post);
            int statusCode = resultRep.getStatusLine().getStatusCode();
            if (statusCode == 200)
            {
                log.info("新增消息成功");
                MQProducer producer = ZqmMessageBoxMQProducerFactory.getMQProducer(messageBusi.getProducerGroup());
                SendResult sendResult = producer.send(msg);
                if (null != sendResult)
                {
                    if (sendResult.getSendStatus().equals(SEND_OK))
                    {
                        log.info("发送消息成功:" + sendResult);
                    }
                    else
                    {
                        return MessageResult.failed("sendResult is not null,but SendStatus is" + sendResult.getSendStatus());
                    }
                }
                else
                {
                    return MessageResult.failed("sendResult is null");
                }
            }
            else
            {
                return MessageResult.failed("调用接口HTTP错误,错误码[" + statusCode + "]");
            }
        }
        catch (Exception e)
        {
            return MessageResult.failed(e.toString());
        }
        return MessageResult.succeed("执行成功");
    }

    public static MessageResult<Object> sendMessage(List<MessageBusi> messageBusis, HashMap<String, String> propertyMap)
    {
        if (null == messageBusis || messageBusis.size() == 0)
        {
            return MessageResult.failed("messageBusis is empty");
        }
        String sysCode = Global.getString("message-box", "sysCode");
        List<Message> messageList = new ArrayList<>(messageBusis.size());
        for (MessageBusi messageBusi : messageBusis)
        {
            // 单条消息准备
            messageBusi.setState(1);
            messageBusi.setSendTime(new Date());
            if (StringUtils.isEmpty(messageBusi.getProducerPlatformType()))
            {
                messageBusi.setProducerPlatformType(sysCode);
            }
            StringBuffer groupName = new StringBuffer();
            groupName.append(sysCode);
            groupName.append("-");
            groupName.append(messageBusi.getProducerOperateType());
            groupName.append("-");
            groupName.append(messageBusi.getProducerOperateCode());
            groupName.append("-producerGroup");
            try
            {
                messageBusi.setProducerGroup(URLEncoder.encode(groupName.toString(), "GBK"));
                StringBuffer topicName = new StringBuffer();
                topicName.append(messageBusi.getConsumerPlatformType());
                topicName.append("-");
                topicName.append(messageBusi.getConsumerOperateType());
                topicName.append("-");
                topicName.append(messageBusi.getConsumerOperateCode());
                topicName.append("-topic");

                messageBusi.setTopic(URLEncoder.encode(topicName.toString(), "GBK"));
            }
            catch (UnsupportedEncodingException e)
            {
                log.error(e);
            }
            Message msg = null;
            try
            {
                msg = new Message(messageBusi.getTopic(), messageBusi.getTags(), messageBusi.getId(), messageBusi.getMessageBody().getBytes(
                        RemotingHelper.DEFAULT_CHARSET));
            }
            catch (UnsupportedEncodingException e)
            {
                return MessageResult.failed("messageBusi.getMessageBody() is wrong");
            }
            messageList.add(msg);
            if (null != propertyMap)
            {
                for (Map.Entry<String, String> entry : propertyMap.entrySet())
                {
                    msg.putUserProperty(entry.getKey(), entry.getValue());
                }
                messageBusi.setProperty(JSONObject.toJSONString(propertyMap));
            }
            msg.putUserProperty("messageBusi", JSONObject.toJSONString(messageBusi));
        }

        // 批量消息保存并发送
        HttpPost post = new HttpPost(Global.getString("message-box", "busiAddress") + "saveList");
        post.setHeader("Authorization", "bearer " + TaoYinTongClientUtil.getAccessToken());
        CloseableHttpClient httpclient = HttpClients.createDefault();
        StringEntity stringEntity = new StringEntity(JSONObject.toJSONString(messageBusis), ContentType.APPLICATION_JSON);
        post.setEntity(stringEntity);
        try
        {
            HttpResponse resultRep = httpclient.execute(post);
            int statusCode = resultRep.getStatusLine().getStatusCode();
            if (statusCode == 200)
            {
                log.info("新增消息成功");
                MessageBusi messageBusi = messageBusis.get(0);
                MQProducer producer = ZqmMessageBoxMQProducerFactory.getMQProducer(messageBusi.getProducerGroup());
                SendResult sendResult = producer.send(messageList);
                if (null != sendResult)
                {
                    if (sendResult.getSendStatus().equals(SEND_OK))
                    {
                        log.info("发送消息成功:" + sendResult);
                    }
                    else
                    {
                        return MessageResult.failed("sendResult is not null,but SendStatus is" + sendResult.getSendStatus());
                    }
                }
                else
                {
                    return MessageResult.failed("sendResult is null");
                }

            }
            else
            {
                return MessageResult.failed("调用接口HTTP错误,错误码[" + statusCode + "]");
            }
        }
        catch (Exception e)
        {
            return MessageResult.failed(e.toString());
        }
        return MessageResult.succeed("执行成功");
    }
}
