package org.zhiqim.manager.messagebox;

import java.net.URLEncoder;
import java.util.List;

import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.MQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.consumer.ConsumeFromWhere;
import org.apache.rocketmq.common.message.MessageExt;
import org.zhiqim.httpd.HttpWebsocketConnection;
import org.zhiqim.kernel.Global;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

public class ZqmMessageBoxMQConsumerFactory
{

    /**
     * 获取用户的MQ消费者
     * 
     * @param userId
     * @return
     * @throws MQClientException
     */
    public static MQPushConsumer getUserMQConsumer(final int userType, final String userId) throws Exception
    {
        StringBuffer groupName = new StringBuffer();
        groupName.append(Global.getString("message-box", "sysCode"));
        groupName.append("-");
        groupName.append(userType);
        groupName.append("-");
        groupName.append(userId);
        groupName.append("-consumerGroup");
        DefaultMQPushConsumer consumer = new DefaultMQPushConsumer(URLEncoder.encode(groupName.toString(), "GBK"));
        consumer.setNamesrvAddr(Global.getString("message-box", "mqAddress"));
        // 偏移量从第一个开始
        consumer.setConsumeFromWhere(ConsumeFromWhere.CONSUME_FROM_FIRST_OFFSET);
        StringBuffer topicName = new StringBuffer();
        topicName.append(Global.getString("message-box", "sysCode"));
        topicName.append("-");
        topicName.append(userType);
        topicName.append("-");
        topicName.append(userId);
        topicName.append("-topic");
        consumer.subscribe(URLEncoder.encode(topicName.toString(), "GBK"), "*");
        consumer.registerMessageListener(new MessageListenerConcurrently()
        {
            @Override
            public ConsumeConcurrentlyStatus consumeMessage(List<MessageExt> msgs, ConsumeConcurrentlyContext context)
            {
                // 标识消费消息
                StringBuffer tempUrl = new StringBuffer();
                for (MessageExt messageExt : msgs)
                {
                    tempUrl.append(messageExt.getKeys());
                    tempUrl.append(",");
                }
                tempUrl.deleteCharAt(tempUrl.length() - 1);
                // 更新消息消费状态
                ZqmMessageUtil.consumeMessages(tempUrl.toString());

                ZqmLoginUser user = ZqmMessageUtil.getUserById(userId);
                JSONArray array = new JSONArray();
                for (MessageExt msg : msgs)
                {
                    JSONObject obj = JSONObject.parseObject(msg.getProperties().get("messageBusi"));
                    array.add(obj);
                }
                String json = array.toJSONString();
                if (user != null && user.hasConnections())
                {
                    for (HttpWebsocketConnection connection : user.getConnections())
                    {
                        connection.send(json);
                    }
                }
                return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
            }
        });
        consumer.start();
        return consumer;
    }
}
