package org.zhiqim.manager.messagebox;

import java.util.List;

import org.apache.rocketmq.client.consumer.MQPushConsumer;
import org.zhiqim.httpd.HttpWebsocketConnection;

public class ZqmLoginUser
{

    private String userId;
    private List<HttpWebsocketConnection> connections;
    private List<MQPushConsumer> consumers;

    public ZqmLoginUser(String userId, List<HttpWebsocketConnection> connections, List<MQPushConsumer> consumers)
    {
        this.userId = userId;
        this.connections = connections;
        this.consumers = consumers;
    }

    public void destroyConnection(HttpWebsocketConnection connection)
    {
        if (connections != null && !connections.isEmpty() && connections.contains(connection))
        {
            connection.close();
            connections.remove(connection);
        }
        if (connections == null || connections.isEmpty())
        {
            if (consumers != null && !consumers.isEmpty())
            {
                for (MQPushConsumer consumer : consumers)
                {
                    consumer.shutdown();
                }
                consumers.clear();
            }
        }
    }

    public String getUserId()
    {
        return userId;
    }

    public List<HttpWebsocketConnection> getConnections()
    {
        return connections;
    }

    public List<MQPushConsumer> getConsumers()
    {
        return consumers;
    }

    public boolean hasConnections()
    {
        return connections != null && !connections.isEmpty();
    }
}
