/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_manager.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.manager.dbo;

import java.io.Serializable;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.annotation.AnNew;
import org.zhiqim.kernel.json.Jsons;
import org.zhiqim.orm.annotation.*;

/**
 * 系统组织表 对应表《ZMR_ORG》
 */
@AnAlias("ZmrOrg")
@AnNew
@AnTable(table="ZMR_ORG", key="ORG_ID", type="InnoDB")
public class ZmrOrg implements Serializable
{
    private static final long serialVersionUID = 1L;

    @AnTableField(column="ORG_ID", type="long", notNull=true)    private long orgId;    //1.组织编号
    @AnTableField(column="ORG_NAME", type="string,32", notNull=true)    private String orgName;    //2.组织名称
    @AnTableField(column="ORG_LEVEL", type="int", notNull=true)    private int orgLevel;    //3.组织级别
    @AnTableField(column="ORG_STATUS", type="byte", notNull=true)    private int orgStatus;    //4.组织状态，0表示正常，1表示停用
    @AnTableField(column="ORG_SEQ", type="int", notNull=true)    private int orgSeq;    //5.组织排序数
    @AnTableField(column="ORG_DESC", type="string,100", notNull=false)    private String orgDesc;    //6.组织描述
    @AnTableField(column="ORG_MANAGER", type="string,32", notNull=false)    private String orgManager;    //7.组织负责人
    @AnTableField(column="NEED_COORDINATER", type="byte", notNull=false)    private int needCoordinate;    //8.是否需要协调（0表示不需要，1表示需要）
    public String toString()
    {
        return Jsons.toString(this);
    }

    public long getOrgId()
    {
        return orgId;
    }

    public void setOrgId(long orgId)
    {
        this.orgId = orgId;
    }

    public String getOrgName()
    {
        return orgName;
    }

    public void setOrgName(String orgName)
    {
        this.orgName = orgName;
    }

    public int getOrgLevel()
    {
        return orgLevel;
    }

    public void setOrgLevel(int orgLevel)
    {
        this.orgLevel = orgLevel;
    }

    public int getOrgStatus()
    {
        return orgStatus;
    }

    public void setOrgStatus(int orgStatus)
    {
        this.orgStatus = orgStatus;
    }

    public int getOrgSeq()
    {
        return orgSeq;
    }

    public void setOrgSeq(int orgSeq)
    {
        this.orgSeq = orgSeq;
    }

    public String getOrgDesc()
    {
        return orgDesc;
    }

    public void setOrgDesc(String orgDesc)
    {
        this.orgDesc = orgDesc;
    }

    public String getOrgManager()
    {
        return orgManager;
    }

    public void setOrgManager(String orgManager)
    {
        this.orgManager = orgManager;
    }

    public int getNeedCoordinate()
    {
        return needCoordinate;
    }

    public void setNeedCoordinate(int needCoordinate)
    {
        this.needCoordinate = needCoordinate;
    }

    
}
