/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_manager.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.manager.dbo;

import java.io.Serializable;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.annotation.AnNew;
import org.zhiqim.kernel.json.Jsons;
import org.zhiqim.orm.annotation.AnTable;
import org.zhiqim.orm.annotation.AnTableField;

/**
 * 操作员表 对应表《ZMR_OPERATOR》
 */
@AnAlias("ZmrOperator")
@AnNew
@AnTable(table = "ZMR_OPERATOR", key = "OPERATOR_CODE", type = "InnoDB")
public class ZmrOperator implements Serializable
{
    private static final long serialVersionUID = 1L;

    @AnTableField(column = "ORG_ID", type = "long", notNull = true)
    private long orgId; // 1.组织编号
    @AnTableField(column = "OPERATOR_CODE", type = "string,32", notNull = true)
    private String operatorCode; // 2.操作员编码
    @AnTableField(column = "OPERATOR_PASS", type = "string,64,char", notNull = true)
    private String operatorPass; // 3.操作员密码
    @AnTableField(column = "OPERATOR_PASS_SALT", type = "string,64,char", notNull = true)
    private String operatorPassSalt; // 4.操作员密码盐值
    @AnTableField(column = "OPERATOR_STATUS", type = "byte", notNull = true)
    private int operatorStatus; // 5.操作员状态：0正常，1停用
    @AnTableField(column = "OPERATOR_TYPE", type = "byte", notNull = true)
    private int operatorType; // 6.操作员类型：0：超级管理员,1：管理员，2:操作员
    @AnTableField(column = "OPERATOR_NAME", type = "string,64", notNull = true)
    private String operatorName; // 7.操作员名称
    @AnTableField(column = "OPERATOR_BALANCE", type = "long", notNull = true)
    private long operatorBalance; // 8.操作员余额，单位：分
    @AnTableField(column = "OPERATOR_AVATAR", type = "long", notNull = false)
    private long operatorAvatar; // 9.操作员头像编号
    @AnTableField(column = "OPERATOR_DEPT", type = "string,850", notNull = false)
    private String operatorDept; // 10.操作员所属部门，多个用逗号隔开，当前支持关联50个部门
    @AnTableField(column = "OPERATOR_DEPT_ALL", type = "string,1700", notNull = false)
    private String operatorDeptAll; // 11.操作员对应的所有部门，多个用逗号隔开，当前支持关联100个部门
    @AnTableField(column = "OPERATOR_ROLE", type = "string,850", notNull = false)
    private String operatorRole; // 12.操作员角色，多个用逗号隔开，当前支持关联50个角色
    @AnTableField(column = "OPERATOR_MOBILE", type = "string,21", notNull = false)
    private String operatorMobile; // 13.操作员手机号
    @AnTableField(column = "OPERATOR_EMAIL", type = "string,64", notNull = false)
    private String operatorEmail; // 14.操作员邮箱
    @AnTableField(column = "OPERATOR_SKIN", type = "string,20", notNull = false)
    private String operatorSkin; // 15.操作员主题肤色
    @AnTableField(column = "OPERATOR_IP", type = "string,18", notNull = false)
    private String operatorIp; // 16.操作员工作IP
    @AnTableField(column = "OPERATOR_URL", type = "string,50", notNull = false)
    private String operatorUrl; // 17.操作员登录后首页
    @AnTableField(column = "OPERATOR_PARAM", type = "string,1024", notNull = false)
    private String operatorParam; // 18.操作员参数，用于项目自定义设置
    @AnTableField(column = "OPERATOR_CREATED", type = "string,19,char", notNull = true)
    private String operatorCreated; // 19.操作员创建时间,格式：yyyy-MM-dd hh:mm:ss
    @AnTableField(column = "OPERATOR_MODIFIED", type = "string,19,char", notNull = true)
    private String operatorModified; // 20.操作员修改时间,格式：yyyy-MM-dd hh:mm:ss
    @AnTableField(column = "OPERATOR_WANGWANG", type = "string,100", notNull = false)
    private String operatorWangwang; // 21.操作员旺旺

    @Override
    public String toString()
    {
        return Jsons.toString(this);
    }

    public long getOrgId()
    {
        return orgId;
    }

    public void setOrgId(long orgId)
    {
        this.orgId = orgId;
    }

    public String getOperatorCode()
    {
        return operatorCode;
    }

    public void setOperatorCode(String operatorCode)
    {
        this.operatorCode = operatorCode;
    }

    public String getOperatorPass()
    {
        return operatorPass;
    }

    public void setOperatorPass(String operatorPass)
    {
        this.operatorPass = operatorPass;
    }

    public String getOperatorPassSalt()
    {
        return operatorPassSalt;
    }

    public void setOperatorPassSalt(String operatorPassSalt)
    {
        this.operatorPassSalt = operatorPassSalt;
    }

    public int getOperatorStatus()
    {
        return operatorStatus;
    }

    public void setOperatorStatus(int operatorStatus)
    {
        this.operatorStatus = operatorStatus;
    }

    public int getOperatorType()
    {
        return operatorType;
    }

    public void setOperatorType(int operatorType)
    {
        this.operatorType = operatorType;
    }

    public String getOperatorName()
    {
        return operatorName;
    }

    public void setOperatorName(String operatorName)
    {
        this.operatorName = operatorName;
    }

    public long getOperatorBalance()
    {
        return operatorBalance;
    }

    public void setOperatorBalance(long operatorBalance)
    {
        this.operatorBalance = operatorBalance;
    }

    public long getOperatorAvatar()
    {
        return operatorAvatar;
    }

    public void setOperatorAvatar(long operatorAvatar)
    {
        this.operatorAvatar = operatorAvatar;
    }

    public String getOperatorDept()
    {
        return operatorDept;
    }

    public void setOperatorDept(String operatorDept)
    {
        this.operatorDept = operatorDept;
    }

    public String getOperatorDeptAll()
    {
        return operatorDeptAll;
    }

    public void setOperatorDeptAll(String operatorDeptAll)
    {
        this.operatorDeptAll = operatorDeptAll;
    }

    public String getOperatorRole()
    {
        return operatorRole;
    }

    public void setOperatorRole(String operatorRole)
    {
        this.operatorRole = operatorRole;
    }

    public String getOperatorMobile()
    {
        return operatorMobile;
    }

    public void setOperatorMobile(String operatorMobile)
    {
        this.operatorMobile = operatorMobile;
    }

    public String getOperatorEmail()
    {
        return operatorEmail;
    }

    public void setOperatorEmail(String operatorEmail)
    {
        this.operatorEmail = operatorEmail;
    }

    public String getOperatorSkin()
    {
        return operatorSkin;
    }

    public void setOperatorSkin(String operatorSkin)
    {
        this.operatorSkin = operatorSkin;
    }

    public String getOperatorIp()
    {
        return operatorIp;
    }

    public void setOperatorIp(String operatorIp)
    {
        this.operatorIp = operatorIp;
    }

    public String getOperatorUrl()
    {
        return operatorUrl;
    }

    public void setOperatorUrl(String operatorUrl)
    {
        this.operatorUrl = operatorUrl;
    }

    public String getOperatorParam()
    {
        return operatorParam;
    }

    public void setOperatorParam(String operatorParam)
    {
        this.operatorParam = operatorParam;
    }

    public String getOperatorCreated()
    {
        return operatorCreated;
    }

    public void setOperatorCreated(String operatorCreated)
    {
        this.operatorCreated = operatorCreated;
    }

    public String getOperatorModified()
    {
        return operatorModified;
    }

    public void setOperatorModified(String operatorModified)
    {
        this.operatorModified = operatorModified;
    }

    public String getOperatorWangwang()
    {
        return operatorWangwang;
    }

    public void setOperatorWangwang(String operatorWangwang)
    {
        this.operatorWangwang = operatorWangwang;
    }

}
