/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_manager.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.manager.dbo;

import java.io.Serializable;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.annotation.AnNew;
import org.zhiqim.kernel.json.Jsons;
import org.zhiqim.orm.annotation.*;

/**
 * 系统菜单表 对应表《ZMR_MENU》
 */
@AnAlias("ZmrMenu")
@AnNew
@AnTable(table="ZMR_MENU", key="MENU_CODE", type="InnoDB")
public class ZmrMenu implements Serializable
{
    private static final long serialVersionUID = 1L;

    @AnTableField(column="PARENT_CODE", type="string,32", notNull=true)    private String parentCode;    //1.父类菜单编码
    @AnTableField(column="MENU_CODE", type="string,32", notNull=true)    private String menuCode;    //2.菜单编码
    @AnTableField(column="MENU_NAME", type="string,64", notNull=true)    private String menuName;    //3.菜单名称
    @AnTableField(column="MENU_NAME_ABBR", type="string,10", notNull=false)    private String menuNameAbbr;    //4.菜单名称简称
    @AnTableField(column="MENU_LEVEL", type="byte", notNull=true)    private int menuLevel;    //5.菜单级别：相对于根节点的级别
    @AnTableField(column="MENU_TYPE", type="byte", notNull=true)    private int menuType;    //6.菜单类型：0表示根节点；1表示枝节点；2表示属性
    @AnTableField(column="MENU_STATUS", type="byte", notNull=true)    private int menuStatus;    //7.菜单状态，0表示正常，1表示停用
    @AnTableField(column="MENU_ICON", type="string,32", notNull=false)    private String menuIcon;    //8.菜单图标
    @AnTableField(column="MENU_URL", type="string,100", notNull=false)    private String menuUrl;    //9.菜单对应的URL：1.当URL为空时不显示链接；2.URL允许多个path，之间用“,”分隔，链接采用第一个path；3.path作为权限的验证原子
    @AnTableField(column="MENU_DESC", type="string,100", notNull=false)    private String menuDesc;    //10.菜单描述

    public String toString()
    {
        return Jsons.toString(this);
    }

    public String getParentCode()
    {
        return parentCode;
    }

    public void setParentCode(String parentCode)
    {
        this.parentCode = parentCode;
    }

    public String getMenuCode()
    {
        return menuCode;
    }

    public void setMenuCode(String menuCode)
    {
        this.menuCode = menuCode;
    }

    public String getMenuName()
    {
        return menuName;
    }

    public void setMenuName(String menuName)
    {
        this.menuName = menuName;
    }

    public String getMenuNameAbbr()
    {
        return menuNameAbbr;
    }

    public void setMenuNameAbbr(String menuNameAbbr)
    {
        this.menuNameAbbr = menuNameAbbr;
    }

    public int getMenuLevel()
    {
        return menuLevel;
    }

    public void setMenuLevel(int menuLevel)
    {
        this.menuLevel = menuLevel;
    }

    public int getMenuType()
    {
        return menuType;
    }

    public void setMenuType(int menuType)
    {
        this.menuType = menuType;
    }

    public int getMenuStatus()
    {
        return menuStatus;
    }

    public void setMenuStatus(int menuStatus)
    {
        this.menuStatus = menuStatus;
    }

    public String getMenuIcon()
    {
        return menuIcon;
    }

    public void setMenuIcon(String menuIcon)
    {
        this.menuIcon = menuIcon;
    }

    public String getMenuUrl()
    {
        return menuUrl;
    }

    public void setMenuUrl(String menuUrl)
    {
        this.menuUrl = menuUrl;
    }

    public String getMenuDesc()
    {
        return menuDesc;
    }

    public void setMenuDesc(String menuDesc)
    {
        this.menuDesc = menuDesc;
    }

}
