/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_manager.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.manager.dbo;

import java.io.Serializable;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.annotation.AnNew;
import org.zhiqim.kernel.json.Jsons;
import org.zhiqim.orm.annotation.*;

/**
 * 系统头像表 对应表《ZMR_AVATAR》
 */
@AnAlias("ZmrAvatar")
@AnNew
@AnTable(table="ZMR_AVATAR", key="AVATAR_ID", type="InnoDB")
public class ZmrAvatar implements Serializable
{
    private static final long serialVersionUID = 1L;

    @AnTableField(column="AVATAR_ID", type="long", notNull=true)    private long avatarId;    //1.头像编号
    @AnTableField(column="AVATAR_TYPE", type="byte", notNull=true)    private int avatarType;    //2.头像类型：0系统，1用户
    @AnTableField(column="AVATAR_TIME", type="long", notNull=true)    private long avatarTime;    //3.头像上传时间，long型，方便转HTTP时间
    @AnTableField(column="AVATAR_50", type="binary", notNull=true)    private byte[] avatar50;    //4.50*50头像
    @AnTableField(column="AVATAR_100", type="binary", notNull=true)    private byte[] avatar100;    //5.100*100头像
    @AnTableField(column="AVATAR_150", type="binary", notNull=true)    private byte[] avatar150;    //6.150*150头像

    public String toString()
    {
        return Jsons.toString(this);
    }

    public long getAvatarId()
    {
        return avatarId;
    }

    public void setAvatarId(long avatarId)
    {
        this.avatarId = avatarId;
    }

    public int getAvatarType()
    {
        return avatarType;
    }

    public void setAvatarType(int avatarType)
    {
        this.avatarType = avatarType;
    }

    public long getAvatarTime()
    {
        return avatarTime;
    }

    public void setAvatarTime(long avatarTime)
    {
        this.avatarTime = avatarTime;
    }

    public byte[] getAvatar50()
    {
        return avatar50;
    }

    public void setAvatar50(byte[] avatar50)
    {
        this.avatar50 = avatar50;
    }

    public byte[] getAvatar100()
    {
        return avatar100;
    }

    public void setAvatar100(byte[] avatar100)
    {
        this.avatar100 = avatar100;
    }

    public byte[] getAvatar150()
    {
        return avatar150;
    }

    public void setAvatar150(byte[] avatar150)
    {
        this.avatar150 = avatar150;
    }

}
