/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_manager.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.manager.action;

import java.util.ArrayList;
import java.util.List;

import org.zhiqim.httpd.HttpContext;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.extend.GetPostAction;
import org.zhiqim.httpd.validate.ones.IsNotEmpty;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.manager.dao.ZmrParamDao;

/**
 * 更换首页主题风格
 *
 * @version v1.0.0 @author zouzhigang 2016-5-28 新建与整理
 */
public class ThemeIndexAction extends GetPostAction
{
    private String templates = "";
    
    @Override
    protected void validate(HttpRequest request)
    {
        request.addValidate(new IsNotEmpty("theme", "请选择一个选项"));
    }

    @Override
    protected void doGet(HttpRequest request) throws Exception
    {
        HttpContext context = request.getContext();
        
        //1.定义模板名称和图片列表
        List<String[]> templateList = new ArrayList<>();
        
        //2.获取模板列表
        templates = "";//把模板名称记下来，方便doPost时检查
        List<String> nameList = request.getContext().getResourceNameList("/ztmpl/zhiqim_manager");
        for (String name : nameList)
        {
            if (!name.endsWith("/"))
                continue;//文件过滤掉
            
            name = Strings.trimRight(name, "/");
            templates += name + ",";
            String[] template = new String[]{name, context.getRootPath("/ztmpl/zhiqim_manager/"+name+"/preview_index.png")};
            templateList.add(template);
        }
        templates = Strings.trimRight(templates, ",");

        //3.模板列表信息放置到属性表中
        request.setAttribute("templateList", templateList);
    }

    @Override
    protected void doPost(HttpRequest request) throws Exception
    {
        String theme = request.getParameter("theme");
        if (!Validates.isStrContainStrArr(theme, templates, ","))
        {
            request.returnHistory("当前仅支持"+templates);
            return;
        }
        
        ZmrParamDao.doUpdateThemeIndex(request.getContext(), theme);
        request.setContextAttribute("themeIndex", theme);
    }
}
