/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_manager.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.manager.action;

import java.util.List;

import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.extend.StdSwitchAction;
import org.zhiqim.httpd.validate.ones.IsLen;
import org.zhiqim.httpd.validate.ones.IsNotEmpty;
import org.zhiqim.kernel.annotation.AnTransaction;
import org.zhiqim.kernel.paging.PageResult;
import org.zhiqim.manager.ZmrBootstrap;
import org.zhiqim.manager.ZmrConstants;
import org.zhiqim.manager.dao.ZmrOperatorDao;
import org.zhiqim.manager.dbo.ZmrOperator;
import org.zhiqim.manager.dbo.ZmrParamOperator;

/**
 * 操作员参数管理
 *
 * @version v1.0.0 @author zhuzhiyuan 2018-12-5 新建与整理
 */
public class ParamOperatorAction extends StdSwitchAction implements ZmrConstants
{
    protected void validateId(HttpRequest request)
    {
        request.addValidate(new IsNotEmpty("paramKey","参数键不能为空"));
    }
    
    protected void validateForm(HttpRequest request)
    {
        request.addValidate(new IsLen("paramKey", "参数键不能为空,且不超过32个字符", 1, 32));
        request.addValidate(new IsLen("paramDesc", "参数描述不能为空,且不超过200个字符", 1, 200));
    }

    protected void list(HttpRequest request) throws Exception
    {
        int page = request.getParameterInt("page");
        int pageSize = request.getContextAttributeInt(ZMR_PAGE_SIZE, 20);
        
        PageResult<ZmrParamOperator> result = ZmrBootstrap.tableOpr(request).page(ZmrParamOperator.class, page, pageSize);
        
        request.setAttribute("result", result);
    }
    
    protected void add(HttpRequest request) throws Exception
    {
    }

    protected void insert(HttpRequest request) throws Exception
    {
        String paramKey = request.getParameter("paramKey");
        String paramDesc = request.getParameter("paramDesc");
        
        if(ZmrBootstrap.tableOpr(request).count(ZmrParamOperator.class, paramKey) > 0)
        {
            request.returnHistory("该操作员参数键已经存在，请重新输入");
            return;
        }
        
        ZmrParamOperator operatorParam = new ZmrParamOperator();
        operatorParam.setParamKey(paramKey);
        operatorParam.setParamDesc(paramDesc);
        
        ZmrBootstrap.table(request).insert(operatorParam);
    }

    protected void modify(HttpRequest request) throws Exception
    {
    }
    
    protected void update(HttpRequest request) throws Exception
    {
    }

    @AnTransaction
    protected void delete(HttpRequest request) throws Exception
    {
        String paramKey = request.getParameter("paramKey");
        ZmrParamOperator operatorParam = ZmrBootstrap.tableOpr(request).item(ZmrParamOperator.class, paramKey);
        if (operatorParam == null)
        {
            request.returnHistory("该操作员参数不存在");
            return;
        }
        
        //删除操作员参数
        List<ZmrOperator> operatorList = ZmrBootstrap.tableOpr(request).list(ZmrOperator.class);
        for (ZmrOperator zmrOperator : operatorList)
        {
            ZmrOperatorDao.deleteOperatorParam(request, zmrOperator.getOperatorCode(), paramKey);
        }
        
        ZmrBootstrap.table(request).delete(ZmrParamOperator.class, paramKey);
    }
    
}
