/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_manager.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.manager.action;

import java.util.ArrayList;
import java.util.List;

import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.extend.GetPostAction;
import org.zhiqim.manager.ZmrBootstrap;
import org.zhiqim.manager.dao.ZmrOrgDao;
import org.zhiqim.manager.dbo.ZmrOrg;
import org.zhiqim.manager.dbo.ZmrOrgRule;
import org.zhiqim.orm.dbo.Selector;

public class OrgRuleAction extends GetPostAction
{
    @Override
    protected void validate(HttpRequest request) throws Exception
    {
        
    }

    @Override
    protected void doGet(HttpRequest request) throws Exception
    {
        List<ZmrOrg> list = ZmrOrgDao.list(request);
        request.setAttribute("list", list);
    }

    @Override
    protected void doPost(HttpRequest request) throws Exception
    {
        long orgId = request.getParameterLong("orgId");
        
        // 判断组织是否存在
        if (ZmrBootstrap.tableOpr(request).count(ZmrOrg.class, orgId) == 0)
        {
            request.returnHistory("您选择的组织不存在");
            return;
        }
        
        String[] menuCodes = request.getParameterValuesOnCNT("rule");
        if (menuCodes == null)
            menuCodes = new String[0];
    
        // 重置组织权限
        ZmrBootstrap.table(request).delete(ZmrOrgRule.class, new Selector("orgId", orgId));
        if (menuCodes.length > 0)
        {
            List<ZmrOrgRule> bathList = new ArrayList<ZmrOrgRule>();
            for (int i = 0; i < menuCodes.length; i++)
            {
                ZmrOrgRule rule = new ZmrOrgRule();
                rule.setOrgId(orgId);
                rule.setMenuCode(menuCodes[i]);
                
                bathList.add(rule);
            }
            ZmrBootstrap.table(request).insertBatch(bathList);
        }
        
        request.setAlertMsg("保存成功");
    }
}
