/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_manager.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.manager.action;

import java.util.ArrayList;
import java.util.List;

import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.extend.GetPostAction;
import org.zhiqim.httpd.validate.ones.IsNotEmpty;
import org.zhiqim.kernel.tree.Tree;
import org.zhiqim.kernel.tree.TreeBuilder;
import org.zhiqim.manager.ZmrBootstrap;
import org.zhiqim.manager.dao.ZmrOrgDao;
import org.zhiqim.manager.dbo.ZmrMenu;
import org.zhiqim.manager.dbo.ZmrOperator;
import org.zhiqim.manager.dbo.ZmrOperatorRule;
import org.zhiqim.orm.dbo.Selector;

/**
 * 修改操作员/管理员权限页面
 *
 * @version v1.0.0 @author zouzhigang 2015-5-28 新建与整理
 */
public class OperatorRuleAction extends GetPostAction
{
    protected void validate(HttpRequest request)
    {
        request.addValidate(new IsNotEmpty("operatorCode", "请选择操作员"));
    }

    @Override
    protected void doGet(HttpRequest request) throws Exception
    {
        request.setResponsePrivateCache();
        
        String operatorCode = request.getParameter("operatorCode");
        ZmrOperator operator = ZmrBootstrap.tableOpr(request).item(ZmrOperator.class, operatorCode);
        if (operator == null)
        {
            request.returnHistory("您选择的操作员不存在");
            return;
        }

        // 获取操作员权限
        List<ZmrOperatorRule> ruleList = ZmrBootstrap.table(request).list(ZmrOperatorRule.class, new Selector("operatorCode", operatorCode));
        
        //获取能管理的权限
        long orgId = operator.getOrgId();
        List<ZmrMenu> list = ZmrOrgDao.getMenuList(request, orgId);
        if (list.isEmpty())
        {
            request.setRedirect("/manager/operator.htm", "请先设置组织权限");
            return;
        }
        
        Tree<ZmrMenu> tree = TreeBuilder.newTree(list, "parentCode", "menuCode");

        request.setAttribute("operator", operator);
        request.setAttribute("menuSize", list.size());
        request.setAttribute("tree", tree);
        request.setAttribute("ruleList", ruleList);
    }
    
    @Override
    protected void doPost(HttpRequest request) throws Exception
    {
        String operatorCode = request.getParameter("operatorCode");
        String[] itemCodes = request.getParameterValues("rule");
        if (itemCodes == null)
            itemCodes = new String[0];
    
        // 判断操作员是否存在
        if (ZmrBootstrap.tableOpr(request).count(ZmrOperator.class, operatorCode) == 0)
        {
            request.returnHistory("您选择的操作员不存在");
            return;
        }
    
        // 重置操作员权限
        ZmrBootstrap.table(request).delete(ZmrOperatorRule.class, new Selector("operatorCode", operatorCode));
        if (itemCodes.length > 0)
        {
            List<ZmrOperatorRule> bathList = new ArrayList<ZmrOperatorRule>();
            for (int i = 0; i < itemCodes.length; i++)
            {
                ZmrOperatorRule rule = new ZmrOperatorRule();
                rule.setOperatorCode(operatorCode);
                rule.setMenuCode(itemCodes[i]);
                
                bathList.add(rule);
            }

            ZmrBootstrap.table(request).insertBatch(bathList);
        }
        
        request.setAlertMsg("保存成功");
        request.addParam("operatorCode", operatorCode);
    }
}
