/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_manager.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.manager.action;

import java.util.Iterator;
import java.util.List;

import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.core.Action;
import org.zhiqim.kernel.util.Arrays;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.manager.ZmrBootstrap;
import org.zhiqim.manager.dbo.ZmrDept;
import org.zhiqim.manager.dbo.ZmrOperator;
import org.zhiqim.orm.dbo.Selector;

/**
 * 操作员部门选择器
 * 
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public class OperatorDeptSelectorAction implements Action
{
    @Override
    public void execute(HttpRequest request) throws Exception
    {
        request.setResponsePrivateCache();
        
        String operatorCode = request.getParameter("operatorCode");
        ZmrOperator operator = ZmrBootstrap.tableOpr(request).item(ZmrOperator.class, operatorCode);
        if (operator == null)
        {
            request.returnHistory("您选择的操作员不存在，请选择一个有效的操作员");
            return;
        }
        
        //查询所有部门
        Selector selector = new Selector();
        selector.addMust("orgId", operator.getOrgId());
        selector.addMaybeLike("deptName", request.getParameter("deptName"));
        List<ZmrDept> list = ZmrBootstrap.table(request).list(ZmrDept.class, selector);
        
        //去除已选的部门
        long[] operatorDept = Arrays.toLongArray(operator.getOperatorDept());
        for (Iterator<ZmrDept> it=list.iterator();it.hasNext();)
        {
            long deptId = it.next().getDeptId();
            if (Validates.isContain(operatorDept, deptId))
                it.remove();
        }
        
        request.setAttribute("operator", operator);
        request.setAttribute("list", list);
    }
}