/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_manager.htm
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.manager.action;

import java.lang.reflect.Constructor;
import java.util.LinkedList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.core.Action;
import org.zhiqim.kernel.Global;
import org.zhiqim.kernel.constants.HttpConstants;
import org.zhiqim.kernel.paging.PageResult;
import org.zhiqim.kernel.util.DateTimes;
import org.zhiqim.manager.ZmrConstants;
import org.zhiqim.manager.ZmrSessionUser;
import org.zhiqim.manager.messagebox.ZqmMessageUtil;
import org.zhiqim.manager.util.TaoYinTongClientUtil;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import yangcai.messagebox.model.MessageBusi;

/**
 * 操作日志查询
 * 
 * @version v1.0.0 @author zhouwenbin 2017-6-2 新建与整理
 */
public class MessageAction implements Action, ZmrConstants
{

    private static final Log log = LogFactory.getLog(MessageAction.class);

    @SuppressWarnings(
    {
            "unchecked", "rawtypes"
    })
    @Override
    public void execute(HttpRequest request) throws Exception
    {
        ZmrSessionUser sessionUser = request.getSessionUser(ZmrSessionUser.class);
        int page = request.getParameterInt("page", 1);
        int pageSize = request.getContextAttributeInt(ZMR_PAGE_SIZE, 20);
        String beginTime = request.getParameter("beginTime", DateTimes.getPreviousDateTimeString());
        String endTime = request.getParameter("endTime", DateTimes.getDateTimeString());
        String orderId = request.getParameter("orderId", "");
        String state = request.getParameter("state", "");
        String consumerPlatformType = Global.getString("message-box", "sysCode");
        String busiAddress = Global.getString("message-box", "busiAddress");
        String consumerOperateCode = sessionUser.getSessionName();

        CloseableHttpClient httpclient = HttpClients.createDefault();
        URIBuilder uriBuilder = new URIBuilder(busiAddress + "list");
        List<NameValuePair> list = new LinkedList<>();
        list.add(new BasicNameValuePair("access_token", TaoYinTongClientUtil.getAccessToken()));
        list.add(new BasicNameValuePair("page", String.valueOf(page)));
        list.add(new BasicNameValuePair("limit", String.valueOf(pageSize)));
        list.add(new BasicNameValuePair("beginTime", beginTime));
        list.add(new BasicNameValuePair("endTime", endTime));
        list.add(new BasicNameValuePair("consumerPlatformType", consumerPlatformType));
        list.add(new BasicNameValuePair("consumerOperateCode", consumerOperateCode));
        list.add(new BasicNameValuePair("consumerOperateType", "1"));
        list.add(new BasicNameValuePair("orderId", orderId));
        list.add(new BasicNameValuePair("state", state));
        uriBuilder.setParameters(list);
        HttpGet get = new HttpGet(uriBuilder.build());
        PageResult<MessageBusi> result = null;
        Class<PageResult> pageResultclass = PageResult.class;
        Constructor constructor = pageResultclass.getDeclaredConstructor(new Class[]
        {
                int.class, int.class, int.class, List.class
        });
        constructor.setAccessible(true);
        try
        {
            HttpResponse resultRep = httpclient.execute(get);
            int statusCode = resultRep.getStatusLine().getStatusCode();
            if (statusCode == HttpConstants._200_OK_)
            {
                String resultString = EntityUtils.toString(resultRep.getEntity());
                JSONObject jsonObject = JSONObject.parseObject(resultString);
                int total = jsonObject.getIntValue("count");
                JSONArray array = jsonObject.getJSONArray("data");
                List<MessageBusi> data = array.toJavaList(MessageBusi.class);
                result = (PageResult<MessageBusi>) constructor.newInstance(new Object[]
                {
                        total, page, pageSize, data
                });
                result.addConditionMap(request.getParameterMap());
                request.setAttribute("result", result);
                request.setAttribute("startTime", beginTime);
                request.setAttribute("endTime", endTime);
                request.setAttribute("orderId", orderId);
                // 已读消息
                StringBuffer ids = new StringBuffer();
                for (MessageBusi message : data)
                {
                    if (message.getState() != 3)
                    {
                        ids.append(message.getId());
                        ids.append(",");
                    }
                }
                if (ids.length() > 0)
                {
                    ids.deleteCharAt(ids.length() - 1);
                    ZqmMessageUtil.readMessages(ids.toString());
                }

            }
            else
            {
                log.error("调用接口HTTP错误,错误码[" + statusCode + "]");
                result = (PageResult<MessageBusi>) constructor.newInstance(new Object[]
                {
                        0, page, pageSize, null
                });
            }
        }
        catch (Exception e)
        {
            log.error(e);
            result = (PageResult<MessageBusi>) constructor.newInstance(new Object[]
            {
                    0, page, pageSize, null
            });
        }

        result.addConditionMap(request.getParameterMap());
        request.setAttribute("result", result);
        request.setAttribute("startTime", beginTime);
        request.setAttribute("endTime", endTime);
        request.setAttribute("orderId", orderId);

    }

}
