/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_manager.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.manager.action;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;

import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.core.Action;
import org.zhiqim.kernel.util.DateTimes;

/**
 * 登录后主页
 *
 * @version v1.0.0 @author zouzhigang 2015-5-29 新建与整理
 */
public class MainAction implements Action
{
    public void execute(HttpRequest request) throws Exception
    {
        Runtime rt = Runtime.getRuntime();
        long use = (rt.totalMemory() - rt.freeMemory())  / 1024 / 1024;
        long max = rt.maxMemory()  / 1024 / 1024;
        
        OperatingSystemMXBean system = ManagementFactory.getOperatingSystemMXBean();
        String systemVersion = system.getName() + " " + system.getVersion();
        
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        String pidName = runtime.getName();
        String jdkVersion = runtime.getVmName() + " " + runtime.getVmVersion();
        String startTime = DateTimes.toDateTimeString(runtime.getStartTime());
        long uptime = runtime.getUptime();
        long day = uptime / (24 * 3600 * 1000);
        long hour = (uptime % (24 * 3600 * 1000)) / (3600 * 1000);
        long min = (uptime % (3600 * 1000)) / (60 * 1000);
        long sec = (uptime % (60 * 1000)) / 1000;

        request.setAttribute("use", use);
        request.setAttribute("max", max);
        request.setAttribute("pidName", pidName);
        request.setAttribute("systemVersion", systemVersion);
        request.setAttribute("jdkVersion", jdkVersion);
        request.setAttribute("startTime", startTime);
        request.setAttribute("day", day);
        request.setAttribute("hour", hour);
        request.setAttribute("min", min);
        request.setAttribute("sec", sec);
    }
}
