/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_manager.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.manager.action;

import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.extend.GetPostAction;
import org.zhiqim.kernel.extend.SS;
import org.zhiqim.kernel.util.codes.RSA;
import org.zhiqim.manager.ZmrConstants;
import org.zhiqim.manager.dao.ZmrParamDao;

/**
 * 修改密钥对
 *
 * @version v1.0.0 @author liuhu 2018-8-29 新建与整理
 */
public class KeysAction extends GetPostAction implements ZmrConstants
{
    protected void validate(HttpRequest request) throws Exception
    {
    }
    
    protected void doGet(HttpRequest request) throws Exception
    {
        String publicKey = ZmrParamDao.getPublicKey(request.getContext());
        String privateKey = ZmrParamDao.getPrivateKey(request.getContext());
        
        request.setAttribute("publicKey", publicKey);
        request.setAttribute("privateKey", privateKey);
    }

    protected void doPost(HttpRequest request) throws Exception
    {
        SS keys = RSA.buildKeyPair();
        
        ZmrParamDao.doUpdate(request.getContext(), ZMR_NAME, ZMR_PUBLIC_KEY, keys.key());
        ZmrParamDao.doUpdate(request.getContext(), ZMR_NAME, ZMR_PRIVATE_KEY, keys.value());
    }
}
