/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_manager.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.manager.action;

import org.zhiqim.httpd.HttpContext;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.ZmlContexts;
import org.zhiqim.httpd.context.core.Action;
import org.zhiqim.httpd.validate.ones.IsLen;
import org.zhiqim.httpd.validate.ones.IsNumericLen;
import org.zhiqim.kernel.constants.ZhiqimConstants;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.manager.ZmrBootstrap;
import org.zhiqim.manager.ZmrConstants;
import org.zhiqim.manager.ZmrPassworder;
import org.zhiqim.manager.ZmrSessionUser;
import org.zhiqim.manager.dao.ZmrParamDao;

/**
 * 首页
 *
 * @version v1.0.0 @author zouzhigang 2015-5-28 新建与整理
 */
public class IndexAction implements Action, ZhiqimConstants, ZmrConstants
{
    public void execute(HttpRequest request) throws Exception
    {
        HttpContext context = request.getContext();
        ZmrSessionUser sessionUser = request.getSessionUser(ZmrSessionUser.class);
        if (sessionUser != null)
        {//用户已登录的，直接进入系统
            String mainUrl = ZmlContexts.parseZmlContent(request, ZmrParamDao.getMainUrl(context));
            if (!ZmrParamDao.isThemeFrame(context))
            {
                request.setRedirect(mainUrl);
            }
            else
            {
                String defaultUrl = ZmlContexts.parseZmlContent(request, ZMR_MAIN_URL_DEFAULT);
                String welcomeUrl = ZmlContexts.parseZmlContent(request, ZMR_MAIN_URL_WELCOME);
                sessionUser.setMainUrl(defaultUrl.equals(mainUrl)?welcomeUrl:mainUrl);
                request.setRedirect(defaultUrl);
            }
            
            return;
        }
        
        request.setResponsePrivateCache();
        
        request.addValidate(new IsLen("operatorCode", "请输入正确的帐号", 2, 32));
        request.addValidate(new IsLen("operatorPass", "请输入正确的密码", 6, 90));
        
        boolean hasVerificationCode = ZmrParamDao.hasVerificationCode(context);
        boolean hasRememberCode = ZmrParamDao.hasRememberCode(context);
        boolean hasRememberPass = ZmrParamDao.hasRememberPass(context);
        if(hasVerificationCode)
        {
            request.addValidate(new IsNumericLen("verificationCode", "验证码必须是4位数字", 4, 4));
        }
        
        request.setAttribute("hasRememberCode", hasRememberCode);
        request.setAttribute("hasRememberPass", hasRememberPass);
        request.setAttribute("hasVerificationCode", hasVerificationCode);
        
        if(hasRememberCode)
        {//记住用户名
            String operatorCode = request.getCookie("operatorCode");
            request.setAttribute("operatorCode", operatorCode);
            
            if (hasRememberPass)
            {//记住密码
                String operatorPass = request.getCookie("operatorPass");
                if (!Validates.isEmptyBlank(operatorPass))
                {
                    ZmrPassworder passworder = request.getContextAttribute(ZmrBootstrap.class).getPassworder();
                    int len = passworder.secretLen(operatorPass);
                    request.setAttribute("operatorPass", Strings.prefixLen("", len, '●'));
                }
            }
        }
    }
}
