/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_manager.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.manager.action;

import java.util.ArrayList;
import java.util.List;

import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.extend.StdSwitchAction;
import org.zhiqim.httpd.validate.ones.IsIntegerValue;
import org.zhiqim.httpd.validate.ones.IsLen;
import org.zhiqim.httpd.validate.onex.IsInteger;
import org.zhiqim.kernel.tree.Tree;
import org.zhiqim.kernel.util.Lists;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.manager.ZmrBootstrap;
import org.zhiqim.manager.ZmrConstants;
import org.zhiqim.manager.ZmrSessionUser;
import org.zhiqim.manager.dao.ZmrDeptDao;
import org.zhiqim.manager.dbo.ZmrDept;
import org.zhiqim.manager.dbo.ZmrOperator;
import org.zhiqim.orm.dbo.Selector;

/**
 * 部门管理
 *
 * @version v1.0.0 @author zouzhigang 2015-5-29 新建与整理
 */
public class DeptAction extends StdSwitchAction implements ZmrConstants
{

    @Override
    protected void validateId(HttpRequest request)
    {
        request.addValidate(new IsInteger("deptId", "请选择一个选项"));
    }

    @Override
    protected void validateForm(HttpRequest request)
    {
        request.addValidate(new IsInteger("deptId", "请选择一个选项"));
        request.addValidate(new IsLen("deptName", "部门名称不能为空且不能超过32个汉字", 1, 32));
        request.addValidate(new IsIntegerValue("deptSeq", "部门排序必须是[0, 999999]范围的非负整数", 0, 999999));
        request.addValidate(new IsLen("deptDesc", "部门描述可为空或不能超过100个汉字", 0, 100));
    }

    @Override
    protected void list(HttpRequest request) throws Exception
    {
        ZmrSessionUser sessionUser = request.getSessionUser(ZmrSessionUser.class);
        long orgId = sessionUser.getSelectedOrgId();
        
        Tree<ZmrDept> tree = ZmrDeptDao.getOrgDeptTree(request, orgId);
        request.setAttribute("tree", tree);
        request.setAttribute("size", tree.size());
    }
    
    @Override
    protected void add(HttpRequest request) throws Exception
    {
        long deptId = request.getParameterLong("deptId");
        if (deptId == -1)
        {
            request.returnHistory("上级部门不存在，请选择正确的部门");
            return;
        }
        
        ZmrDept parent = ZmrBootstrap.table(request).item(ZmrDept.class, deptId);
        if (parent == null)
        {
            request.returnHistory("上级部门不存在，请选择正确的部门");
            return;
        }
        
        request.setAttribute("parent", parent);
    }

    @Override
    protected void modify(HttpRequest request) throws Exception
    {
        long deptId = request.getParameterLong("deptId");
        ZmrDept item = ZmrBootstrap.table(request).item(ZmrDept.class, deptId);
        if (item == null)
        {
            request.returnHistory("部门不存在，请选择正确的部门");
            return;
        }
        
        request.setAttribute("item", item);
    }

    @Override
    protected void insert(HttpRequest request) throws Exception
    {
        ZmrDept item = request.getParameter(ZmrDept.class);
        ZmrDept parent = ZmrBootstrap.table(request).item(ZmrDept.class, item.getParentId());
        if (parent == null || parent.getDeptStatus() != 0)
        {
            request.returnHistory("上级部门不存在或停用，请选择正确的部门");
            return;
        }
        
        item.setDeptLevel(parent.getDeptLevel()+1);
        if (parent.getDeptLevel() == 0)
            item.setDeptParentAll(""+parent.getDeptId());
        else
            item.setDeptParentAll(parent.getDeptParentAll() + "," + parent.getDeptId());
        
        ZmrBootstrap.table(request).insert(item);
        
        //修改负责人所属部门
        List<String> operatorCodeList = new ArrayList<String>();
        if (Validates.isNotEmptyBlank(item.getDeptManager()))
            operatorCodeList.add(item.getDeptManager());
        if (Validates.isNotEmptyBlank(item.getDeptSubManager()))
            operatorCodeList.addAll(Lists.toStringList(item.getDeptSubManager()));
        
        ZmrDeptDao.doUpdateDeptManeger(request, operatorCodeList, item.getDeptId()+"", item.getDeptParentAll());
    }

    @Override
    protected void update(HttpRequest request) throws Exception
    {
        ZmrDept item = request.getParameter(ZmrDept.class);
        ZmrBootstrap.table(request).update(item);
        
        //修改负责人所属部门
        List<String> operatorCodeList = new ArrayList<String>();
        if(Validates.isNotEmptyBlank(item.getDeptManager()))
            operatorCodeList.add(item.getDeptManager());
        if(Validates.isNotEmptyBlank(item.getDeptSubManager()))
            operatorCodeList.addAll(Lists.toStringList(item.getDeptSubManager()));
        
        ZmrDeptDao.doUpdateDeptManeger(request, operatorCodeList, item.getDeptId()+"", item.getDeptParentAll());
    }

    @Override
    protected void delete(HttpRequest request) throws Exception
    {
        long deptId = request.getParameterLong("deptId");
        ZmrDept item = ZmrBootstrap.table(request).item(ZmrDept.class, deptId);
        if (item == null)
        {
            request.returnHistory("部门不存在，请选择正确的部门");
            return;
        }
        
        if (item.getDeptLevel() == 0)
        {
            request.returnHistory("顶级部门不能删除，只允许修改");
            return;
        }
        
        if (ZmrBootstrap.table(request).count(ZmrDept.class, new Selector("parentId", deptId)) > 0)
        {
            request.returnHistory("该部门有下级部门，要先删除下级部门才能删除本部门");
            return;
        }
        
        if (ZmrBootstrap.tableOpr(request).count(ZmrOperator.class, new Selector().addMustLike("operatorDept", deptId)) > 0)
        {
            request.returnHistory("该部门已有操作员，请删除部门成员后再删除本部门");
            return;
        }
        
        ZmrBootstrap.table(request).delete(ZmrDept.class, deptId);
    }
}