/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_manager.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.manager.action;

import java.util.Collection;
import java.util.List;

import org.zhiqim.httpd.HttpContext;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.HttpServer;
import org.zhiqim.httpd.context.extend.GetPostAction;
import org.zhiqim.httpd.validate.ones.IsByteLen;
import org.zhiqim.httpd.validate.ones.IsNotEmpty;
import org.zhiqim.kernel.Global;

/**
 * 配置管理类
 *
 * @version v1.0.0 @author zouzhigang 2015-5-28 新建与整理
 */
public class ConfigAction extends GetPostAction
{
    protected void validate(HttpRequest request)
    {
        request.addValidate(new IsNotEmpty("groupId", "参数类别未获取到,请重试"));
        request.addValidate(new IsNotEmpty("key", "参数编码未获取到,请重试"));
        request.addValidate(new IsByteLen("value", "参数值不能为空且不能超过800个字符", 0, 800));
    }

    protected void doGet(HttpRequest request) throws Exception
    {
        request.setValidateConfirm("修改配置参数后会对系统产生影响，确定要修改参数吗？");
        request.setAttribute("groupList", Global.getGroupList());
    }

    protected void doPost(HttpRequest request) throws Exception
    {
        String groupId = request.getParameter("groupId");
        String key = request.getParameter("key");
        String value = request.getParameterNoFilter("value");

        //相等
        String oldValue = Global.getString(groupId, key);
        if (!oldValue.equals(value))
        {//更新配置文件
            Global.setValue(groupId, key, value);
            Global.saveConfigByGroup(groupId);
            
            //查看是不是HttpServer，还需要去更新到HttpContext中
            List<HttpServer> list = Global.getServiceList(HttpServer.class);
            list: for (HttpServer server : list)
            {
                Collection<HttpContext> contextList = server.getContextList();
                for (HttpContext context : contextList)
                {
                    if (!context.getId().equals(groupId))
                        continue;
                    
                    context.setAttribute(key, value);
                    break list;
                }
            }
        }
        
        request.setAlertMsg("修改成功");
    }
}
