/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_manager.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.manager.action;

import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.extend.GetPostAction;
import org.zhiqim.httpd.validate.ones.IsNotEmpty;
import org.zhiqim.kernel.Global;
import org.zhiqim.kernel.Service;
import org.zhiqim.kernel.util.Classes;
import org.zhiqim.orm.ORMServer;

/**
 * 系统缓存管理
 *
 * @version v1.4.1 @author zouzhigang 2018-5-4 新建与整理
 */
public class CacheAction extends GetPostAction
{
    protected void validate(HttpRequest request)
    {
        request.addValidate(new IsNotEmpty("id", "请选择需要刷新的数据库对象"));
        request.addValidate(new IsNotEmpty("className", "请选择需要刷新的缓存对象"));
    }

    protected void doGet(HttpRequest request) throws Exception
    {
        request.setAttribute("list", Global.getServiceList(ORMServer.class));
    }

    protected void doPost(HttpRequest request) throws Exception
    {
        String id = request.getParameter("id");
        String className = request.getParameter("className");

        Service service = Global.getService(id);
        if (service == null || !(service instanceof ORMServer))
        {
            request.returnHistory("请选择有效的数据库对象");
            return;
        }
        
        ORMServer server = (ORMServer)service;
        Class<?> clazz = Classes.forName(Global.getClassName(className));
        if (clazz == null)
        {
            request.returnHistory("请选择需要刷新的缓存对象");
            return;
        }
        
        if (!server.isCache(clazz))
        {
            request.returnHistory("该对象未设置为缓存对象");
            return;
        }
        
        server.table().cache(clazz);
        request.setAlertMsg("刷新成功");
    }
}
