/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_manager.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.manager;

import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.core.Interceptor;
import org.zhiqim.kernel.annotation.AnAlias;

/**
 * 检查是否登录拦截器
 *
 * @version v1.0.0 @author zouzhigang 2015-5-28 新建与整理
 */
@AnAlias("chkZmrLogin")
public class ZmrInterceptor implements Interceptor, ZmrConstants
{
    public void intercept(HttpRequest request) throws Exception
    {
        if (request.hasSessionUser(ZmrSessionUser.class))
        {//已登录不拦截
            return;
        }
        
        if (request.isXMLHttpRequest())
        {//AJAX访问
            request.setResponseError("您闲置太久或未登录，请重新登录后再操作...");
        }
        else
        {//URL访问
            request.setRedirectTop("/"+request.getContextAttributeString(ZMR_PATH)+"/logout.htm", "您闲置太久或未登录，正在返回初始界面，请确定.....");
        }
    }
}
