/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_manager.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.manager;

import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.HttpdConstants;
import org.zhiqim.httpd.context.ZmlBootstrap;
import org.zhiqim.kernel.util.Sqls;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.manager.dbo.ZmrOperatorLog;

/**
 * 管理台引导类缺省类，各系统可继承该类进行引导，以保证有以下功能：
 * 1、登录之后处理
 * 2、退出之前处理
 * 3、POST日志打印到操作日志表中
 *
 * @version v1.0.0 @author zouzhigang 2017-9-22 新建与整理
 */
public class ZmrBootstrapApi extends ZmlBootstrap implements ZmrConstants, HttpdConstants
{
    /**
     * 登录之后处理接口
     * 
     * @param request   请求
     */
    public void logined(HttpRequest request)
    {
    }
    
    /**
     * 退出之前处理接口
     * 
     * @param request   请求
     */
    public void logouting(HttpRequest request)
    {
    }
    
    /**
     * 日志输出接口
     * 
     * @param request   请求
     * @param message   消息
     */
    public void log(HttpRequest request, String message)
    {
        log(request, message, null);
    }
    
    /**
     * 日志输出接口
     * 
     * @param request   请求
     * @param message   消息
     * @param e         访问时产生的异常
     */
    public void log(HttpRequest request, String message, Throwable e)
    {
        super.log(request, message, e);
        
        if (!request.isMethodPost())
        {//HEAD、GET不写日志
            return;
        }
        
        ZmrSessionUser sessionUser = request.getSessionUser(ZmrSessionUser.class);
        if (sessionUser == null)
        {//未登录不写日志
            return;
        }
        
        String operateDesc = Strings.formatMessage(message, e);
        
        try
        {
            ZmrOperatorLog log = new ZmrOperatorLog();
            log.setOrgId(sessionUser.getOperator().getOrgId());
            log.setOperatorCode(sessionUser.getOperatorCode());
            log.setOperateTime(Sqls.nowTimestamp());
            log.setOperateUrl(request.getRequestURL());
            log.setOperateDesc(operateDesc);
            
            request.getContextAttribute(ZmrBootstrap.class).table().insert(log);
        }
        catch (Exception ex)
        {
            log.error("写入操作日志到数据库时异常", ex);
        }
    }
}
