/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.zhiqim.httpd.HttpdConstants;
import org.zhiqim.httpd.nio.HttpNioSslConnection;
import org.zhiqim.kernel.config.Group;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Validates;

public class HttpSslConfig
implements HttpdConstants {
    private String keystorePath;
    private String keystorePass;
    private String truststorePath;
    private String truststorePass;
    private boolean clientAuth;

    public void initParam(Group group) {
        this.keystorePath = group.getString("keystorePath");
        this.keystorePass = group.getString("keystorePass");
        Asserts.as((String)(Validates.isNotEmpty((String)this.keystorePath) ? null : "\u914d\u7f6eHTTPS\u65f6\u8981\u6c42\u5fc5\u987b\u914d\u7f6e[keystorePath]\u4e0d\u80fd\u4e3a\u7a7a"));
        Asserts.as((String)(Validates.isNotEmpty((String)this.keystorePass) ? null : "\u914d\u7f6eHTTPS\u65f6\u8981\u6c42\u5fc5\u987b\u914d\u7f6e[keystorePass]\u4e0d\u80fd\u4e3a\u7a7a"));
        this.truststorePath = group.getString("truststorePath");
        this.truststorePass = group.getString("truststorePass");
        Asserts.as(!Validates.isNotEmpty((String)this.truststorePath) || Validates.isNotEmpty((String)this.truststorePass) ? null : "\u914d\u7f6eHTTPS\u65f6\u5982\u8981\u914d\u7f6e\u4e86[truststorePath]\u5219[truststorePass]\u4e0d\u80fd\u4e3a\u7a7a");
        this.clientAuth = group.isTrue("clientAuth");
    }

    public SSLServerSocketFactory createFactory() throws Exception {
        return this.createSSLContext().getServerSocketFactory();
    }

    public SSLContext createSSLContext() throws Exception {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        KeyStore keyStore = KeyStore.getInstance("JKS");
        FileInputStream kfis = new FileInputStream(this.keystorePath);
        keyStore.load(kfis, this.keystorePass.toCharArray());
        keyManagerFactory.init(keyStore, this.keystorePass.toCharArray());
        TrustManager[] trustManager = null;
        if (Validates.isNotEmptyBlank((String)this.truststorePath)) {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
            KeyStore trustStore = KeyStore.getInstance("JKS");
            FileInputStream tfis = new FileInputStream(this.truststorePath);
            trustStore.load(tfis, this.truststorePass.toCharArray());
            trustManagerFactory.init(trustStore);
            trustManager = trustManagerFactory.getTrustManagers();
        }
        sslContext.init(keyManagerFactory.getKeyManagers(), trustManager, new SecureRandom());
        return sslContext;
    }

    public boolean doHandshake(HttpNioSslConnection conn) {
        SSLEngine sslEngine = conn.getSSLEngine();
        SSLSession session = sslEngine.getSession();
        int appBufMax = session.getApplicationBufferSize();
        int netBufMax = session.getPacketBufferSize();
        ByteBuffer appBuf = ByteBuffer.allocate(appBufMax + 10);
        ByteBuffer netBuf = ByteBuffer.allocate(netBufMax);
        try {
            sslEngine.beginHandshake();
            return this.doHandshake(conn, sslEngine, appBuf, netBuf);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean doHandshake(HttpNioSslConnection conn, SSLEngine sslEngine, ByteBuffer appBuf, ByteBuffer netBuf) throws IOException {
        SSLEngineResult.HandshakeStatus hsStatus = sslEngine.getHandshakeStatus();
        boolean handshakeDone = false;
        while (!handshakeDone) {
            switch (hsStatus) {
                case NEED_UNWRAP: {
                    netBuf.clear();
                    conn.read(netBuf);
                    netBuf.flip();
                    do {
                        sslEngine.unwrap(netBuf, appBuf);
                        hsStatus = this.doTask(sslEngine);
                    } while (netBuf.hasRemaining() && hsStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP);
                    break;
                }
                case NEED_WRAP: {
                    netBuf.clear();
                    sslEngine.wrap(_HELLO_N_, netBuf);
                    netBuf.flip();
                    conn.write(netBuf);
                    hsStatus = this.doTask(sslEngine);
                    break;
                }
                case NEED_TASK: {
                    hsStatus = this.doTask(sslEngine);
                    break;
                }
                case NOT_HANDSHAKING: {
                    handshakeDone = true;
                    break;
                }
            }
        }
        return handshakeDone;
    }

    private SSLEngineResult.HandshakeStatus doTask(SSLEngine sslEngine) {
        Runnable task;
        while ((task = sslEngine.getDelegatedTask()) != null) {
            task.run();
        }
        return sslEngine.getHandshakeStatus();
    }

    public String getKeystorePath() {
        return this.keystorePath;
    }

    public String getKeystorePass() {
        return this.keystorePass;
    }

    public String getTruststorePath() {
        return this.truststorePath;
    }

    public String getTruststorePass() {
        return this.truststorePass;
    }

    public boolean isClientAuth() {
        return this.clientAuth;
    }
}

