/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.zhiqim.httpd.HttpHeader;
import org.zhiqim.httpd.HttpHeaderInner;
import org.zhiqim.httpd.HttpSender;
import org.zhiqim.httpd.HttpdConstants;
import org.zhiqim.httpd.entities.ClassResourceEntity;
import org.zhiqim.httpd.entities.FileResourceEntity;
import org.zhiqim.kernel.util.Files;
import org.zhiqim.kernel.util.Resources;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Validates;

public class HttpResource
implements HttpdConstants {
    public static final HttpResourceCompor _resourceCompor = new HttpResourceCompor();
    public static final FileResourceEntity _fileResource = new FileResourceEntity();
    public static final ClassResourceEntity _classResource = new ClassResourceEntity();
    private int resourceIndex;
    private String resourceType;
    private String resourcePath;

    public HttpResource(String resourceType, String resourcePath) {
        this.resourceType = resourceType;
        this.resourcePath = Strings.removeEndsWith((String)resourcePath, (String)"/");
    }

    public HttpResource(int resourceIndex, String resourceType, String resourcePath) {
        this.resourceIndex = resourceIndex;
        this.resourceType = resourceType;
        this.resourcePath = Strings.removeEndsWith((String)resourcePath, (String)"/");
    }

    public boolean isValid() {
        return Validates.isNotEmpty((String)this.resourcePath) && ("classpath".equals(this.resourceType) || "directory".equals(this.resourceType));
    }

    public boolean handleResource(HttpHeader header, HttpSender sender) throws IOException {
        if (this.resourceType == null || this.resourcePath == null) {
            return false;
        }
        String path = String.valueOf(this.resourcePath) + header.getPathInContext();
        path = URLDecoder.decode(path, header.getCharacterEncoding());
        if (this.isClasspath()) {
            if (!Resources.exists(HttpResource.class, (String)path)) {
                return false;
            }
            if (header.isMethodHead()) {
                sender.sendHeader(200);
                return true;
            }
            ((HttpHeaderInner)((Object)header)).setPathOnResource(path);
            _classResource.handle(header, sender);
            return true;
        }
        if (!Files.isFile((String)path)) {
            return false;
        }
        if (header.isMethodHead()) {
            sender.sendHeader(200);
            return true;
        }
        ((HttpHeaderInner)((Object)header)).setPathOnResource(path);
        _fileResource.handle(header, sender);
        return true;
    }

    public String getResourceString(String path) throws IOException {
        return this.getResourceString(path, "UTF-8");
    }

    public String getResourceString(String path, String encoding) throws IOException {
        if (this.resourcePath == null) {
            return null;
        }
        path = String.valueOf(this.resourcePath) + "/" + Strings.removeStartsWith((String)path, (String)"/");
        if (this.isClasspath()) {
            if (!Resources.exists(HttpResource.class, (String)path)) {
                return null;
            }
            return Resources.getResourceString(HttpResource.class, (String)path, (String)encoding);
        }
        if (!Files.isFile((String)path)) {
            return null;
        }
        return Files.read((String)path, (String)encoding);
    }

    public List<String> getResourceNameList(String folderPath) throws IOException {
        if (this.resourcePath == null) {
            return new ArrayList<String>(0);
        }
        folderPath = String.valueOf(this.resourcePath) + "/" + Strings.removeStartsWith((String)folderPath, (String)"/");
        if (this.isClasspath()) {
            if (!Resources.exists(HttpResource.class, (String)folderPath)) {
                return new ArrayList<String>(0);
            }
            return Resources.getResourceNameList(HttpResource.class, (String)folderPath);
        }
        if (!Files.isDirectory((String)folderPath)) {
            return new ArrayList<String>(0);
        }
        File folder = new File(folderPath);
        File[] files = folder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !file.isHidden();
            }
        });
        if (files == null) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> nameList = new ArrayList<String>();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                nameList.add(String.valueOf(file.getName()) + "/");
            } else {
                nameList.add(file.getName());
            }
            ++n2;
        }
        return nameList;
    }

    public boolean isClasspath() {
        return "classpath".equals(this.resourceType);
    }

    public int getResourceIndex() {
        return this.resourceIndex;
    }

    public void setResourceIndex(int resourceIndex) {
        this.resourceIndex = resourceIndex;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.resourcePath == null ? 0 : this.resourcePath.hashCode());
        result = 31 * result + (this.resourceType == null ? 0 : this.resourceType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HttpResource other = (HttpResource)obj;
        if (this.resourcePath == null ? other.resourcePath != null : !this.resourcePath.equals(other.resourcePath)) {
            return false;
        }
        return !(this.resourceType == null ? other.resourceType != null : !this.resourceType.equals(other.resourceType));
    }

    private static class HttpResourceCompor
    implements Comparator<HttpResource> {
        private HttpResourceCompor() {
        }

        @Override
        public int compare(HttpResource o1, HttpResource o2) {
            return o1.getResourceIndex() - o2.getResourceIndex();
        }
    }
}

