/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLHandshakeException;
import org.zhiqim.httpd.HttpConnection;
import org.zhiqim.httpd.HttpContext;
import org.zhiqim.httpd.HttpEntity;
import org.zhiqim.httpd.HttpException;
import org.zhiqim.httpd.HttpExecutor;
import org.zhiqim.httpd.HttpHandler;
import org.zhiqim.httpd.HttpHeader;
import org.zhiqim.httpd.HttpHeaderInner;
import org.zhiqim.httpd.HttpInputStream;
import org.zhiqim.httpd.HttpListener;
import org.zhiqim.httpd.HttpOutputStream;
import org.zhiqim.httpd.HttpRequestAbs;
import org.zhiqim.httpd.HttpResponse;
import org.zhiqim.httpd.HttpResponseImpl;
import org.zhiqim.httpd.HttpSender;
import org.zhiqim.httpd.HttpSenderImpl;
import org.zhiqim.httpd.HttpServer;
import org.zhiqim.httpd.constants.HttpStep;
import org.zhiqim.kernel.extend.HashMapSS;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.util.Bytes;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.kernel.util.codes.URI;
import org.zhiqim.kernel.util.seqs.Sequence;

public abstract class HttpHeaderAbs
extends HttpHeaderInner
implements HttpHeader {
    private static final Log log = LogFactory.getLog((String)"http.request");
    private static final Sequence sequence = new Sequence(6);
    private HttpConnection conn;
    private HttpListener listener;
    private HttpServer server;
    private HttpInputStream input;
    private HttpOutputStream output;
    private HttpSenderImpl sender;
    private String requestId;
    private int requestStep;
    private long requestTimeMillis;
    private String statusLine;
    private String method;
    private URI uri;
    private String version;
    private HashMapSS headerMap;
    private String x_Forwarded_For;
    private String mimeType;
    private String characterEncoding;
    private X509Certificate[] certs;
    private HttpContext context;
    private HttpRequestAbs request;
    private HttpResponseImpl response;
    private HttpHandler handler;
    private transient String pathInContext;
    private transient String pathOnResource;
    private List<String> headerList;
    private byte[] headerBuf = new byte[16384];
    private boolean isCR = false;
    private boolean isLF = false;
    private boolean isCR2 = false;
    private int pos = 0;
    private int totalPos = 0;

    public HttpHeaderAbs(HttpConnection conn, HttpInputStream input, SSLEngine sslEngine) {
        this.conn = conn;
        this.listener = conn.getListener();
        this.server = this.listener.getServer();
        this.input = input;
        this.output = new HttpOutputStream(conn);
        this.sender = this.newSender();
        this.requestId = String.valueOf(conn.getId()) + sequence.nextString();
        this.requestStep = 1;
        this.requestTimeMillis = System.currentTimeMillis();
        this.headerList = new ArrayList<String>();
        this.headerMap = new HashMapSS();
    }

    public abstract HttpSenderImpl newSender();

    public abstract HttpRequestAbs newRequest();

    public abstract boolean isBio();

    public HttpServer getServer() {
        return this.server;
    }

    @Override
    public HttpContext getContext() {
        return this.context;
    }

    public HttpInputStream getInputStream() {
        return this.input;
    }

    public HttpOutputStream getOutputStream() {
        return this.output;
    }

    public String getId() {
        return this.requestId;
    }

    public long getReceiveTimeMillis() {
        return this.requestTimeMillis;
    }

    public HttpListener getListener() {
        return this.listener;
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    @Override
    public Log getLog() {
        return log;
    }

    @Override
    public HttpSender getSender() {
        return this.sender;
    }

    public String getConfiguration() {
        return this.context.getConfiguration();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute() throws HttpException, IOException {
        try {
            if (this.requestStep < 2) {
                if (!this.parseHeaderStream()) {
                    return true;
                }
                this.setStep(2);
            }
            if (this.requestStep < 3) {
                this.parseHeader();
                this.sender.setVersion(this.getVersion());
                if (!this.isBio()) {
                    this.sender.setHeader("Connection", this.getHeader("Connection"));
                }
                this.setStep(3);
            }
            if (this.requestStep < 4) {
                String host = this.getHostOnly();
                if (Validates.isEmpty((String)host)) {
                    throw new HttpException(412);
                }
                String path = this.getPath();
                this.context = this.server.getContext(host, path);
                if (this.context != null && !"/".equals(path)) {
                    this.sender.sendRedirect(String.valueOf(path) + "/");
                    return true;
                }
                if (this.context == null) {
                    String maybe = this.getVirtualDirectory();
                    this.context = this.server.getContext(host, maybe);
                    if (this.context == null) {
                        this.context = this.server.getContext(host, "/");
                    }
                }
                if (this.context == null) {
                    this.sender.sendError(404);
                    return true;
                }
                this.setStep(4);
            }
            if (this.requestStep < 5) {
                this.parsePathInContext(this.context);
                String pathInContext = this.getPathInContext();
                if ("/".equals(pathInContext)) {
                    this.sender.sendError(404);
                    return true;
                }
                if (this.context.isFilterPath(pathInContext)) {
                    this.sender.sendError(403);
                    return true;
                }
                this.output.setChunkSize(this.context.getChunkSize());
                this.handler = this.context.getMatchHandler(pathInContext);
                if (this.handler == null) {
                    this.context.handleResource(this, this.sender);
                    return true;
                }
                if (this.isMethodHead()) {
                    this.sender.sendHeader(200);
                    return true;
                }
                if (this.handler instanceof HttpEntity) {
                    ((HttpEntity)this.handler).handle(this, this.sender);
                    return true;
                }
                this.setStep(5);
            }
            if (this.requestStep < 6) {
                if (this.request == null) {
                    this.request = this.newRequest();
                }
                if (this.response == null) {
                    this.response = new HttpResponseImpl(this.request);
                }
                this.request.parseHeaderByContextOK();
                this.request.parseGetPostCookieSession();
                if (!this.request.parseContent()) {
                    return true;
                }
                this.setStep(6);
            }
            if (this.requestStep < 7) {
                this.setStep(7);
                HttpExecutor executor = (HttpExecutor)this.handler;
                executor.handle(this.request, this.response);
                if (this.requestStep < 10) {
                    this.setStep(10);
                }
            }
            if (!this.isCommitted()) {
                if (this.response != null) {
                    this.response.commit();
                } else {
                    this.sender.commit();
                }
            }
            boolean bl = !this.isWebSocket();
            return bl;
        }
        catch (SSLHandshakeException sSLHandshakeException) {
            this.close();
            return false;
        }
        catch (EOFException eOFException) {
            try {
                this.sender.sendError(400);
                return false;
            }
            catch (Exception exception) {
                this.close();
                return false;
            }
        }
        catch (SocketException | SocketTimeoutException iOException) {
            try {
                this.sender.sendError(408);
                return false;
            }
            catch (Exception exception) {
                this.close();
                return false;
            }
        }
        catch (HttpException e) {
            if (e.getCode() == 444) {
                this.close();
                return false;
            }
            try {
                this.sender.sendError(e.getCode());
                return false;
            }
            catch (Exception exception) {
                this.close();
                return false;
            }
        }
        catch (IOException iOException) {
            this.close();
            return false;
        }
        catch (Throwable e) {
            log.error(e);
            try {
                this.sender.sendError(500);
                return false;
            }
            catch (Exception exception) {
                this.close();
                return false;
            }
        }
        finally {
            if (this.isCommitted()) {
                this.setStep(12);
                this.listener.finished(this);
                this.destroy();
                if (this.sender != null) {
                    this.sender.destroy();
                }
                if (this.request != null) {
                    this.request.destroy();
                }
                if (this.response != null) {
                    this.response.destroy();
                }
            }
        }
    }

    public void parsePathInContext(HttpContext context) {
        this.context = context;
        String contextPath = context.getContextPath();
        this.pathInContext = "/".equals(contextPath) ? this.uri.getPath() : this.uri.getPath().substring(contextPath.length());
        this.pathInContext = Strings.addStartsWith((String)this.pathInContext, (String)"/");
        if ("/".equals(this.pathInContext) && Validates.isNotEmptyBlank((String)context.getWelcomeUrl())) {
            this.pathInContext = context.getWelcomeUrl();
        }
        if (Validates.isEmptyBlank((String)this.characterEncoding)) {
            this.characterEncoding = context.getDefaultEncoding();
        }
        if (Validates.isEmptyBlank((String)this.characterEncoding)) {
            this.characterEncoding = "UTF-8";
        }
    }

    public void parseHeader() throws EOFException, HttpException {
        String hostPort;
        if (this.headerList.isEmpty()) {
            throw new EOFException();
        }
        this.statusLine = this.headerList.get(0).trim();
        String line = this.statusLine;
        if (line.length() > 8192) {
            throw new HttpException(414);
        }
        int ind = line.indexOf(32);
        if (ind == -1) {
            throw new HttpException(400);
        }
        this.method = line.substring(0, ind);
        if (!("GET".equalsIgnoreCase(this.method) || "POST".equalsIgnoreCase(this.method) || "HEAD".equalsIgnoreCase(this.method))) {
            throw new HttpException(405);
        }
        this.method = this.method.toUpperCase();
        if ((ind = (line = line.substring(ind + 1).trim()).indexOf(32)) == -1) {
            throw new HttpException(400);
        }
        String url = line.substring(0, ind);
        if (url == null || url.trim().length() < 1) {
            throw new HttpException(400);
        }
        if (!url.startsWith("/") || url.indexOf("/..") != -1 || url.indexOf("../") != -1) {
            throw new HttpException(400);
        }
        this.uri = new URI();
        if (!this.uri.parseUri(url.trim())) {
            throw new HttpException(400);
        }
        this.version = line.substring(ind + 1).trim();
        if (!"HTTP/1.1".equals(this.version) && !"HTTP/1.0".equals(this.version)) {
            throw new HttpException(505);
        }
        int i = 1;
        while (i < this.headerList.size()) {
            line = this.headerList.get(i);
            ind = line.indexOf(58);
            if (ind != -1) {
                String key = Strings.trim((String)line.substring(0, ind));
                String value = Strings.trim((String)line.substring(ind + 1));
                this.setHeader(key, value);
            }
            ++i;
        }
        this.x_Forwarded_For = this.getHeader("X-Forwarded-For");
        String x_Forwarded_Host = this.getHeader("X-Forwarded-Host");
        if (Validates.isNotEmptyBlank((String)x_Forwarded_Host)) {
            this.setHeader("Host", x_Forwarded_Host);
        }
        if ((hostPort = this.getHostPort()) == null) {
            throw new HttpException(412);
        }
        String contentType = this.getHeader("Content-Type");
        if (contentType != null) {
            int i0 = contentType.indexOf(59);
            if (i0 == -1) {
                this.mimeType = contentType.toLowerCase();
            } else {
                this.mimeType = contentType.substring(0, i0).trim().toLowerCase();
                int i1 = contentType.indexOf("charset=", i0);
                if (i1 >= 0) {
                    int i2 = contentType.indexOf(";", i1);
                    this.characterEncoding = i2 == -1 ? contentType.substring(i1 + 8) : contentType.substring(i1 + 8, i2).trim();
                }
            }
        }
    }

    private boolean parseHeaderStream() throws HttpException, IOException {
        int b = this.input.read();
        while (b != -1) {
            if (this.totalPos > 0x100000) {
                throw new HttpException(414);
            }
            if (this.pos > 8192) {
                throw new HttpException(414);
            }
            if (b == 13) {
                this.pos = 0;
                String line = Bytes.BI.getString(this.headerBuf, 0, (byte)0);
                if (line != null && line.trim().length() > 0) {
                    this.headerList.add(line);
                }
                Bytes.fillBytes((byte[])this.headerBuf, (int)0, (byte)0, (int)16384);
                if (this.isCR) {
                    this.isCR2 = true;
                } else {
                    this.isCR = true;
                }
            } else if (b == 10) {
                if (this.isCR && this.isLF && this.isCR2) break;
                this.isLF = true;
            } else {
                this.isCR2 = false;
                this.isLF = false;
                this.isCR = false;
                this.headerBuf[this.pos++] = (byte)b;
                ++this.totalPos;
            }
            b = this.input.read();
        }
        return this.isCR && this.isLF && this.isCR2;
    }

    public void setStep(int step) {
        if (this.requestStep >= step) {
            return;
        }
        this.requestStep = step;
    }

    public int getStep() {
        return this.requestStep;
    }

    public String getStepDesc() {
        return HttpStep.getStatusMsg(this.requestStep);
    }

    public boolean isRead() {
        return this.requestStep > 3;
    }

    public boolean isParsed() {
        return this.requestStep > 6;
    }

    public boolean isHandled() {
        return this.requestStep >= 10;
    }

    public boolean isCommitted() {
        return this.requestStep >= 11;
    }

    public boolean isEditable() {
        return !this.isCommitted();
    }

    public void close() {
        if (!this.isCommitted()) {
            this.setStep(11);
        }
        this.conn.close();
    }

    @Override
    public String getRemoteAddr() {
        if (this.x_Forwarded_For != null) {
            return this.x_Forwarded_For.split(",")[0];
        }
        return this.conn.getRemoteAddr();
    }

    @Override
    public int getListenerPort() {
        return this.conn.getListener().getPort();
    }

    @Override
    public String getHeaderLine() {
        return this.statusLine;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public boolean isMethodHead() {
        return "HEAD".equals(this.method);
    }

    @Override
    public boolean isMethodGet() {
        return "GET".equals(this.method);
    }

    @Override
    public boolean isMethodPost() {
        return "POST".equals(this.method);
    }

    @Override
    public boolean isMethodResponseContent() {
        return "GET".equals(this.method) || "POST".equals(this.method);
    }

    public URI getUri() {
        return this.uri;
    }

    @Override
    public String getPath() {
        return this.uri == null ? "" : this.uri.getPath();
    }

    @Override
    public String getQueryString() {
        return this.uri.getQuery();
    }

    @Override
    public String getVirtualDirectory() {
        return this.uri.getVirtualDirectory();
    }

    @Override
    public HashMapSS getHeaders() {
        return this.headerMap;
    }

    public void setHeader(String key, String value) {
        this.headerMap.put(key.toLowerCase(), value);
    }

    @Override
    public String getHeader(String key) {
        return this.headerMap.get(key.toLowerCase());
    }

    @Override
    public String getCharacterEncodingHeader() {
        String contentType = this.getHeader("Content-Type");
        if (Validates.isEmptyBlank((String)contentType)) {
            return null;
        }
        int i1 = (contentType = contentType.toLowerCase()).indexOf("charset=");
        if (i1 == -1) {
            return null;
        }
        int i2 = contentType.indexOf(";", i1);
        if (i2 == -1) {
            return contentType.substring(i1 + 8);
        }
        return contentType.substring(i1 + 8, i2).trim();
    }

    @Override
    public int getContentLength() {
        String sLen = this.getHeader("Content-Length");
        if (!Validates.isInteger((String)sLen)) {
            return 0;
        }
        return Integer.parseInt(sLen);
    }

    @Override
    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public boolean isMimeForm() {
        return "application/x-www-form-urlencoded".equals(this.mimeType);
    }

    @Override
    public boolean isMimeTextPlain() {
        return "text/plain".equals(this.mimeType);
    }

    @Override
    public void setCharacterEncoding(String characterEncoding) {
        if (Validates.isEmptyBlank((String)characterEncoding)) {
            return;
        }
        this.characterEncoding = characterEncoding;
    }

    @Override
    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    @Override
    public String getHostPort() {
        return this.getHeader("Host");
    }

    @Override
    public String getHostOnly() {
        String hostPort = this.getHostPort();
        if (Validates.isEmpty((String)hostPort)) {
            return null;
        }
        int ind = hostPort.indexOf(":");
        if (ind == -1) {
            return hostPort;
        }
        return Strings.trim((String)hostPort.substring(0, ind));
    }

    @Override
    public String getUserAgent() {
        return this.getHeader("User-Agent");
    }

    @Override
    public boolean isRequestGZip() {
        String contentEncoding = this.getHeader("Content-Encoding");
        return "gzip".equalsIgnoreCase(contentEncoding);
    }

    @Override
    public boolean isResponseGZip() {
        String acceptEncoding = this.getHeader("Accept-Encoding");
        if (Validates.isEmpty((String)acceptEncoding) || acceptEncoding.indexOf("gzip") == -1) {
            return false;
        }
        String userAgent = this.getUserAgent();
        return !Validates.isEmpty((String)userAgent) && userAgent.toLowerCase().indexOf("msie 6.0") <= -1;
    }

    public String getXForwardedFor() {
        return this.x_Forwarded_For;
    }

    public void setCertificates(X509Certificate[] certs) {
        this.certs = certs;
    }

    public X509Certificate[] getCertificates() {
        return this.certs;
    }

    @Override
    public boolean isWebSocket() {
        return "WebSocket".equalsIgnoreCase(this.getHeader("Upgrade")) && Strings.contains((String)this.getHeader("Connection").toLowerCase(), (CharSequence)"Upgrade".toLowerCase());
    }

    public void setPathInContext(String pathInContext) {
        if ("/".equals(pathInContext = Strings.addStartsWith((String)pathInContext, (String)"/")) && Validates.isNotEmptyBlank((String)this.context.getWelcomeUrl())) {
            pathInContext = this.context.getWelcomeUrl();
        }
        this.pathInContext = pathInContext;
    }

    public HttpConnection getConnection() {
        return this.conn;
    }

    @Override
    public String getPathInContext() {
        return this.pathInContext;
    }

    @Override
    public String getPathOnResource() {
        return this.pathOnResource;
    }

    @Override
    public void setPathOnResource(String pathOnResource) {
        this.pathOnResource = pathOnResource;
    }

    public String toString() {
        StringBuilder strb = new StringBuilder();
        strb.append(this.statusLine).append("\r\n");
        if (this.headerMap != null) {
            for (Map.Entry entry : this.headerMap.entrySet()) {
                strb.append((String)entry.getKey()).append(':').append((String)entry.getValue()).append("\r\n");
            }
            strb.append("\r\n");
        }
        return strb.toString();
    }

    private void destroy() {
        if (this.headerMap != null) {
            this.headerMap.clear();
            this.headerMap = null;
        }
        if (this.headerList != null) {
            this.headerList.clear();
            this.headerList = null;
        }
        this.statusLine = null;
        this.method = null;
        this.uri = null;
        this.version = null;
        this.x_Forwarded_For = null;
        this.mimeType = null;
        this.characterEncoding = null;
        this.conn = null;
        this.context = null;
        this.pathInContext = null;
        this.pathOnResource = null;
    }
}

