/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_calendar.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.calendar.model;

import org.zhiqim.kernel.util.Strings;

/**
 * 日历星期模型，根据休息日划分出的星期模型
 *
 * @version v1.0.0 @author zouzhigang 2017-11-8 新建与整理
 */
public class CalendarWeekModel
{
    private int beginDate;
    private int beginYear;
    private int beginMonth;
    private int beginDay;
    
    private int endDate;
    private int endYear;
    private int endMonth;
    private int endDay;

    public CalendarWeekModel(int beginDate)
    {
        this.beginDate = beginDate;

        this.beginYear = beginDate / 10000;
        this.beginMonth = beginDate / 100 % 100;
        this.beginDay = beginDate % 10000;
    }
    
    public void setEndDate(int endDate)
    {
        this.endDate = endDate;
        
        this.endYear = endDate / 10000;
        this.endMonth = endDate / 100 % 100;
        this.endDay = endDate % 10000;
    }
    
    public int getBeginDate()
    {
        return beginDate;
    }

    public int getEndDate()
    {
        return endDate;
    }
    
    public int getBeginYear()
    {
        return beginYear;
    }

    public int getBeginMonth()
    {
        return beginMonth;
    }

    public int getBeginDay()
    {
        return beginDay;
    }

    public int getEndYear()
    {
        return endYear;
    }

    public int getEndMonth()
    {
        return endMonth;
    }

    public int getEndDay()
    {
        return endDay;
    }

    public String getWeekBegin()
    {
        return beginYear + "-" + Strings.prefixZero(beginMonth, 2) + "-" + Strings.prefixZero(beginDay, 2);
    }
    
    public String getWeekEnd()
    {
        return endYear + "-" + Strings.prefixZero(endMonth, 2) + "-" + Strings.prefixZero(endDay, 2);
    }
}
