/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_calendar.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.calendar.model;

/**
 * 日历模型，包括日期所在上月/当前/下月,日期和是否休息日
 *
 * @version v1.0.0 @author zouzhigang 2017-11-8 新建与整理
 */
public class CalendarModel
{
    private String calendarMonth;
    private int calendarDate;
    private boolean calendarRest;
    
    private int year;
    private int month;
    private int day;
    
    /****************************************************************/
    //设置属性
    /****************************************************************/

    public void setCalendarMonth(String calendarMonth)
    {
        this.calendarMonth = calendarMonth;
    }

    public void setCalendarRest(boolean calendarRest)
    {
        this.calendarRest = calendarRest;
    }
    
    public void setCalendarDate(int year, int month, int day)
    {
        this.calendarDate = year * 10000 + month * 100 + day;
        
        this.year = year;
        this.month = month;
        this.day = day;
    }
    
    public void setCalendarDate(int calendarDate)
    {
        this.calendarDate = calendarDate;
        
        this.year = calendarDate / 10000;
        this.month = calendarDate / 100 % 100;
        this.day = calendarDate % 100;
    }
    
    /****************************************************************/
    //获取属性
    /****************************************************************/
    
    public String getCalendarMonth()
    {
        return calendarMonth;
    }
    
    public boolean isCalendarRest()
    {
        return calendarRest;
    }
    
    public int getCalendarDate()
    {
        return calendarDate;
    }
    
    public int getYear()
    {
        return year;
    }

    public int getMonth()
    {
        return month;
    }

    public int getDay()
    {
        return day;
    }
}
