/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_calendar.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.calendar.dbo;

import java.io.Serializable;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.json.Jsons;
import org.zhiqim.orm.annotation.*;

/**
 * 工作日历表 对应表《ZMR_CALENDAR》
 */
@AnAlias("ZmrCalendar")
@AnTable(table="ZMR_CALENDAR", key="CALENDAR_DATE", type="InnoDB")
public class ZmrCalendar implements Serializable
{
    private static final long serialVersionUID = 1L;

    @AnTableField(column="CALENDAR_DATE", type="int", notNull=true)    private int calendarDate;    //1.日历日期，8位数字，格式：20170101
    @AnTableField(column="CALENDAR_REST", type="boolean", notNull=true)    private boolean calendarRest;    //2.是否休息日，1：表示休息日，0：表示工作日
    @AnTableField(column="CALENDAR_DESC", type="string,100", notNull=false)    private String calendarDesc;    //3.日期说明，如休息日说明什么节假日，工作日说明调整原因

    public String toString()
    {
        return Jsons.toString(this);
    }

    public int getCalendarDate()
    {
        return calendarDate;
    }

    public void setCalendarDate(int calendarDate)
    {
        this.calendarDate = calendarDate;
    }

    public boolean isCalendarRest()
    {
        return calendarRest;
    }

    public void setCalendarRest(boolean calendarRest)
    {
        this.calendarRest = calendarRest;
    }

    public String getCalendarDesc()
    {
        return calendarDesc;
    }

    public void setCalendarDesc(String calendarDesc)
    {
        this.calendarDesc = calendarDesc;
    }

}
