/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_calendar.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.calendar.action;

import org.zhiqim.calendar.dbo.ZmrCalendar;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.extend.ValidateAction;
import org.zhiqim.httpd.validate.ones.IsNotEmpty;
import org.zhiqim.orm.ORM;
import org.zhiqim.orm.ZTable;

/**
 * 日历休息日/工作日数据删除
 *
 * @version v1.0.0 @author zhichenggang 2014-3-21 新建与整理
 */
public class CalendarDeleteAction extends ValidateAction
{
    @Override
    protected void validate(HttpRequest request)
    {
        request.addValidate(new IsNotEmpty("calendarDate", "请选择一个选项"));
    }

    @Override
    protected void perform(HttpRequest request) throws Exception
    {
        int calendarDate = request.getParameterInt("calendarDate");
        ZmrCalendar item = ORM.get(ZTable.class, request).item(ZmrCalendar.class, calendarDate);
        if(item == null)
        {
            request.returnHistory("日历不存在，请重新选择");
            return;
        }
        
        ORM.get(ZTable.class, request).delete(ZmrCalendar.class, calendarDate);
    }
}
