/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_calendar.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.calendar;

import org.zhiqim.calendar.dbo.ZmrCalendar;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.annotation.AnIntercept;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.util.DateTimes;
import org.zhiqim.orm.ORM;
import org.zhiqim.orm.ZTable;

/**
 * 日历页面调用器
 *
 * @version v1.0.0 @author zouzhigang 2017-11-8 新建与整理
 */
@AnAlias("ZmrCalendarPresenter")
@AnIntercept("chkZmrLogin")
public class ZmrCalendarPresenter 
{
    /**
     * 切换工作日和休息日
     * 
     * @param request       请求对象
     * @param calendarDate  日历日期
     * @throws Exception    异常
     */
    public static void doToggle(HttpRequest request, int calendarDate) throws Exception
    {   
       if((ORM.get(ZTable.class, request).count(ZmrCalendar.class, calendarDate)) > 0)
       {//判断该日期在项目日历表中是否存在，存在就删除
           ORM.get(ZTable.class, request).delete(ZmrCalendar.class, calendarDate);
           return;
       }

       //不存在则增加，周末就设置为工作日，否则设置为休息日
       ZmrCalendar calendar = new ZmrCalendar();
       calendar.setCalendarDate(calendarDate);
       int week = DateTimes.getDateWeek7(calendarDate);
       if (week == 6 || week == 7)
           calendar.setCalendarRest(false);
       else
           calendar.setCalendarRest(true);
       
       ORM.get(ZTable.class, request).insert(calendar);
    }
}
