/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.xml;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.zhiqim.kernel.constants.CodeConstants;
import org.zhiqim.kernel.constants.SignConstants;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Types;
import org.zhiqim.kernel.xml.XmlFactory;
import org.zhiqim.kernel.xml.XmlTag;
import org.zhiqim.kernel.xml.Xmls;

public class Xml
implements SignConstants,
CodeConstants {
    public static final Xml xml = new Xml();
    private boolean versionFlag = true;
    private String version = "1.0";
    private String encoding = "UTF-8";
    private boolean format = true;
    private XmlFactory factory = new XmlFactory(this);

    public String getXmlVersionTag() {
        return "<?xml version=\"" + this.version + "\" encoding=\"" + this.encoding + "\"?>";
    }

    public String toString(Object obj) {
        if (obj == null) {
            return "";
        }
        if (Types.isSingle(obj)) {
            return String.valueOf(obj);
        }
        StringBuilder strb = new StringBuilder();
        if (this.versionFlag) {
            strb.append(this.getXmlVersionTag());
        }
        String tagName = null;
        if (obj instanceof XmlTag) {
            tagName = ((XmlTag)obj).getXmlTag();
        }
        strb.append(this.toStringInner(obj, tagName, 0));
        return strb.toString();
    }

    public String toStringInner(Object obj, String tagName, int tagLevel) {
        return this.factory.getParser(obj.getClass()).toStringInner(obj, tagName, tagLevel);
    }

    public <T> T toObject(String xml, Class<T> clazz) {
        Asserts.as(xml != null ? null : "XML\u8f6c\u5bf9\u8c61\u65f6\uff0cXML\u4e0d\u5141\u8bb8\u4e3anull");
        try {
            Document doc = Xmls.buildDocument(xml, "UTF-8");
            Node node = doc.getFirstChild();
            return this.toObjectInner(node, clazz, null);
        }
        catch (Exception e) {
            throw Asserts.exception("XML\u8f6c\u5bf9\u8c61\u65f6\uff0cXML\u683c\u5f0f\u4e0d\u6b63\u786e:" + e.getMessage());
        }
    }

    public <T> T toObjectInner(Node node, Class<T> clazz, Class<?> generics) {
        return (T)this.factory.getParser(clazz).toObjectInner(node, clazz, generics);
    }

    public boolean isFormat() {
        return this.format;
    }
}

