/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.util.codes;

import java.nio.charset.Charset;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.constants.CodeConstants;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.kernel.util.codes.Base64Decoder;
import org.zhiqim.kernel.util.codes.Base64Encoder;

@AnAlias(value={"Base64"})
public class Base64
implements CodeConstants {
    public static String encode(byte[] src) {
        Asserts.notNull(src);
        return new String(Base64Encoder.encode(src), _UTF_8_C_);
    }

    public static byte[] decode(String src) {
        Asserts.notNull(src, "src");
        Asserts.as(Validates.isScope(src, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=\r\n") ? null : "\u53c2\u6570\u542b\u6709\u4e0d\u662fBase64\u5b57\u7b26\u4e32\u5141\u8bb8\u7684\u5b57\u7b26");
        return Base64Decoder.decode(src.getBytes(_UTF_8_C_));
    }

    public static String encodeUTF8(String src) {
        return Base64.encode(src, _UTF_8_C_);
    }

    public static String decodeUTF8(String src) {
        return Base64.decode(src, _UTF_8_C_);
    }

    public static String encode(String src, String encoding) {
        return Base64.encode(src, Charset.forName(encoding));
    }

    public static String encode(String src, Charset charset) {
        return Base64.encode(src.getBytes(charset));
    }

    public static String decode(String src, String encoding) {
        return Base64.decode(src, Charset.forName(encoding));
    }

    public static String decode(String src, Charset charset) {
        return new String(Base64.decode(src), charset);
    }

    public static String encodeFileUrlUTF8(String src) {
        return Base64.encode(src, _UTF_8_C_).replaceAll("\\+", "~").replaceAll("/", "_");
    }

    public static String decodeFileUrlUTF8(String src) {
        return Base64.decode(src.replaceAll("~", "\\+").replaceAll("_", "/"), _UTF_8_C_);
    }

    public static String encodeFileNameUTF8(String src) {
        return Base64.encode(src, _UTF_8_C_).replaceAll("/", "_");
    }

    public static String decodeFileNameUTF8(String src) {
        return Base64.decode(src.replaceAll("_", "/"), _UTF_8_C_);
    }
}

