/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.util;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import org.zhiqim.kernel.annotation.AnNullable;
import org.zhiqim.kernel.util.Arrays;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Runtimes;
import org.zhiqim.kernel.util.Systems;
import org.zhiqim.kernel.util.Validates;

public class Windows {
    public static void cmd(String cmd) throws IOException {
        Asserts.as(Systems.isWindows() ? null : "\u4e0d\u662fWindows\u7cfb\u7edf\uff0c\u4e0d\u652f\u6301\u8c03\u7528CMD\u547d\u4ee4");
        Runtime.getRuntime().exec(new String[]{"cmd", "/c", cmd});
    }

    public static String cmd(String cmd, String encoding) throws IOException {
        Asserts.as(Systems.isWindows() ? null : "\u4e0d\u662fWindows\u7cfb\u7edf\uff0c\u4e0d\u652f\u6301\u8c03\u7528CMD\u547d\u4ee4");
        return Runtimes.exec(new String[]{"cmd", "/c", cmd}, Charset.forName(encoding));
    }

    public static List<String> cmd(String cmd, String encoding, int maxLineNum) throws IOException {
        Asserts.as(Systems.isWindows() ? null : "\u4e0d\u662fWindows\u7cfb\u7edf\uff0c\u4e0d\u652f\u6301\u8c03\u7528CMD\u547d\u4ee4");
        return Runtimes.exec(new String[]{"cmd", "/c", cmd}, encoding, maxLineNum);
    }

    public static String copy(String arguments, String src, String dest, String encoding) throws IOException {
        StringBuilder strb = new StringBuilder("copy ");
        if (Validates.isNotEmpty(arguments)) {
            strb.append(arguments).append(" ");
        }
        strb.append(src).append(" ").append(dest);
        return Windows.cmd(strb.toString(), encoding);
    }

    public static String ipconfig(String arguments, String encoding) throws IOException {
        return Windows.cmd(Validates.isEmpty(arguments) ? "ipconfig" : "ipconfig " + arguments, encoding);
    }

    @AnNullable
    public static String getFirstMacAddress(String encoding) throws IOException {
        String[] lines;
        String result = Windows.ipconfig("/all", encoding);
        if (Validates.isEmptyBlank(result)) {
            return null;
        }
        String[] stringArray = lines = Arrays.toStringArray(result, "\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if ((line = line.trim()).indexOf("Physical Address") >= 0 || line.indexOf("\u7269\u7406\u5730\u5740") >= 0) {
                String mac = line.substring(line.length() - 17);
                return mac.replaceAll("-", ":");
            }
            ++n2;
        }
        return null;
    }
}

