/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.util;

import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.constants.CodeConstants;
import org.zhiqim.kernel.constants.EnumConstants;
import org.zhiqim.kernel.constants.RegexpConstants;
import org.zhiqim.kernel.constants.SignConstants;
import org.zhiqim.kernel.util.Arrays;
import org.zhiqim.kernel.util.Bytes;
import org.zhiqim.kernel.util.DateTimes;
import org.zhiqim.kernel.util.IPs;
import org.zhiqim.kernel.util.Lists;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Systems;
import org.zhiqim.kernel.util.Types;
import org.zhiqim.kernel.util.Validatex;

@AnAlias(value={"Validates"})
public class Validates
extends Validatex
implements SignConstants,
EnumConstants,
CodeConstants,
RegexpConstants {
    public static boolean isWhitespace(char c) {
        return c <= ' ' || c == '\u3000' || c == '\ufeff';
    }

    public static boolean isCharInString(char c, String s) {
        return s.indexOf(c) != -1;
    }

    public static boolean isLetterUppercase(char c) {
        return "ABCDEFGHIJKLMNOPQRSTUVWXYZ".indexOf(c) != -1;
    }

    public static boolean isLetterUppercaseDigits(char c) {
        return "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".indexOf(c) != -1;
    }

    public static boolean isLetterLowercase(char c) {
        return "abcdefghijklmnopqrstuvwxyz".indexOf(c) != -1;
    }

    public static boolean isLetterLowercaseDigits(char c) {
        return "0123456789abcdefghijklmnopqrstuvwxyz".indexOf(c) != -1;
    }

    public static boolean isLetter(char c) {
        return "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".indexOf(c) != -1;
    }

    public static boolean isDigit(char c) {
        return "0123456789".indexOf(c) != -1;
    }

    public static boolean isDigitOrDot(char c) {
        return Validates.isDigit(c) || c == '.';
    }

    public static boolean isLetterOrDigit(char c) {
        return "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789".indexOf(c) != -1;
    }

    public static boolean isWindows() {
        return Systems.isWindows();
    }

    public static boolean isMacOS() {
        return Systems.isMacOS();
    }

    public static boolean isLinux() {
        return Systems.isLinux();
    }

    public static boolean isEqual(Object obj, Object obj2) {
        if (obj == null) {
            return obj2 == null;
        }
        if (obj2 == null) {
            return false;
        }
        if (obj.getClass() != obj2.getClass()) {
            return false;
        }
        return obj.equals(obj2);
    }

    public static boolean isNotEqual(Object obj, Object obj2) {
        return !Validates.isEqual(obj, obj2);
    }

    public static boolean isEqualIgnoreCase(String str, String str2) {
        return str == null ? str2 == null : str.equalsIgnoreCase(str2);
    }

    public static boolean isIndexOf(String src, String str) {
        return src == null ? str == null : src.indexOf(str) != -1;
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof String) {
            return Validates.isEmpty((String)obj);
        }
        if (obj instanceof Collection) {
            return Validates.isEmpty((Collection)obj);
        }
        if (obj instanceof Map) {
            return ((Map)obj).isEmpty();
        }
        if (Types.isArray(obj)) {
            return Arrays.isEmpty(obj);
        }
        return false;
    }

    public static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static boolean isEmptyBlank(String s) {
        return s == null || Strings.trim(s).length() == 0;
    }

    public static boolean isEmpty(Collection<?> c) {
        return c == null || c.size() == 0;
    }

    public static boolean isEmpty(Object[] s) {
        return s == null || s.length == 0;
    }

    public static boolean isNotEmpty(String s) {
        return !Validates.isEmpty(s);
    }

    public static boolean isNotEmptyBlank(String s) {
        return !Validates.isEmptyBlank(s);
    }

    public static boolean isNotEmpty(Collection<?> c) {
        return !Validates.isEmpty(c);
    }

    public static boolean isNotEmpty(Object obj) {
        return !Validates.isEmpty(obj);
    }

    public static boolean isLen(String s, int min, int max) {
        if (Validates.isEmpty(s)) {
            return min == 0;
        }
        return s.length() >= min && s.length() <= max;
    }

    public static boolean isByteLen(String s, int min, int max) {
        return Validates.isByteLen(s, min, max, "GBK");
    }

    public static boolean isByteLen(String s, int min, int max, String encoding) {
        if (Validates.isEmpty(s)) {
            return min == 0;
        }
        int len = Bytes.getByteLen(s, encoding);
        return len >= min && len <= max;
    }

    public static boolean isScope(String s, String scope) {
        if (Validates.isEmpty(s)) {
            return false;
        }
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (!Validates.isCharInString(c, scope)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isPhone(String s) {
        return Validates.isScope(s, "+()- 0123456789");
    }

    public static boolean isColor(String s) {
        if (!Validates.isLen(s, 7, 7) || !s.startsWith("#")) {
            return false;
        }
        s = s.substring(1);
        return Validates.isScope(s, "0123456789abcdefABCDEF");
    }

    public static boolean isContainMultByteChar(String s) {
        if (Validates.isEmpty(s)) {
            return false;
        }
        int len = s.length();
        int i = 0;
        while (i < len) {
            if (s.charAt(i) > '\u007f') {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isRegexp(String regexp, String s) {
        return Validates.isRegexp(regexp, s, false);
    }

    public static boolean isBoolean(String s) {
        return Validates.isBoolean(s, false);
    }

    public static boolean isNumeric(String s) {
        return Validates.isNumeric(s, false);
    }

    public static boolean isNumericLen(String s, int min, int max) {
        if (!Validates.isNumeric(s, min == 0)) {
            return false;
        }
        return s.length() >= min && s.length() <= max;
    }

    public static boolean isInteger(String s) {
        return Validates.isInteger(s, false);
    }

    public static boolean isIntegerPositive(String s) {
        return Validates.isIntegerPositive(s, false);
    }

    public static boolean isIntegerNonnegative(String s) {
        return Validates.isIntegerNonnegative(s, false);
    }

    public static boolean isIntegerNegative(String s) {
        return Validates.isIntegerNegative(s, false);
    }

    public static boolean isIntegerNonpositive(String s) {
        return Validates.isIntegerNonpositive(s, false);
    }

    public static boolean isIntegerValue(String s, int min, int max) {
        if (!Validates.isInteger(s, false)) {
            return false;
        }
        int num = Integer.parseInt(s);
        return num >= min && num <= max;
    }

    public static boolean isIntegerNonnegativeLen(String s, int min, int max) {
        if (Validates.isEmpty(s)) {
            return min == 0;
        }
        if (!Validates.isIntegerNonnegative(s, false)) {
            return false;
        }
        return s.length() >= min && s.length() <= max;
    }

    public static boolean isAlphabetic(String s) {
        return Validates.isAlphabetic(s, false);
    }

    public static boolean isAlphabeticLowercase(String s) {
        return Validates.isAlphabeticLowercase(s, false);
    }

    public static boolean isAlphabeticUppercase(String s) {
        return Validates.isAlphabeticUppercase(s, false);
    }

    public static boolean isAlphabeticLen(String s, int min, int max) {
        if (Validates.isEmpty(s)) {
            return min == 0;
        }
        if (!Validates.isAlphabetic(s, false)) {
            return false;
        }
        return s.length() >= min && s.length() <= max;
    }

    public static boolean isAlphabeticLowercaseLen(String s, int min, int max) {
        if (Validates.isEmpty(s)) {
            return min == 0;
        }
        if (!Validates.isAlphabeticLowercase(s, false)) {
            return false;
        }
        return s.length() >= min && s.length() <= max;
    }

    public static boolean isAlphabeticUpperLen(String s, int min, int max) {
        if (Validates.isEmpty(s)) {
            return min == 0;
        }
        if (!Validates.isAlphabeticUppercase(s, false)) {
            return false;
        }
        return s.length() >= min && s.length() <= max;
    }

    public static boolean isAlphaNumeric(String s) {
        return Validates.isAlphaNumeric(s, false);
    }

    public static boolean isAlphaNumericLen(String s, int min, int max) {
        if (Validates.isEmpty(s)) {
            return min == 0;
        }
        if (!Validates.isAlphaNumeric(s, false)) {
            return false;
        }
        return s.length() >= min && s.length() <= max;
    }

    public static boolean isAlphaNumericPA(String s) {
        return Validates.isAlphaNumericPA(s, false);
    }

    public static boolean isAlphaNumericPALen(String s, int min, int max) {
        if (Validates.isEmpty(s)) {
            return min == 0;
        }
        if (!Validates.isAlphaNumericPA(s, false)) {
            return false;
        }
        return s.length() >= min && s.length() <= max;
    }

    public static boolean isAlphaNumericUl(String s) {
        return Validates.isAlphaNumericUl(s, false);
    }

    public static boolean isAlphaNumericUlLen(String s, int min, int max) {
        if (Validates.isEmpty(s)) {
            return min == 0;
        }
        if (!Validates.isAlphaNumericUl(s, false)) {
            return false;
        }
        return s.length() >= min && s.length() <= max;
    }

    public static boolean isAlphaNumericDotLen(String s, int min, int max) {
        if (Validates.isEmpty(s)) {
            return min == 0;
        }
        if (!Validates.isAlphaNumericDot(s, false)) {
            return false;
        }
        return s.length() >= min && s.length() <= max;
    }

    public static boolean isAlphaNumericUrlLen(String s, int min, int max) {
        if (Validates.isEmpty(s)) {
            return min == 0;
        }
        if (!Validates.isAlphaNumericUrl(s, false)) {
            return false;
        }
        return s.length() >= min && s.length() <= max;
    }

    public static boolean isAlphaNumericUlPA(String s) {
        return Validates.isAlphaNumericUlPA(s, false);
    }

    public static boolean isAlphaNumericUlPALen(String s, int min, int max) {
        if (Validates.isEmpty(s)) {
            return min == 0;
        }
        if (!Validates.isAlphaNumericUlPA(s, false)) {
            return false;
        }
        return s.length() >= min && s.length() <= max;
    }

    public static boolean isAlphaNumericUlDlPA(String s) {
        return Validates.isAlphaNumericUlDlPA(s, false);
    }

    public static boolean isAlphaNumericUlDlPALen(String s, int min, int max) {
        if (Validates.isEmpty(s)) {
            return min == 0;
        }
        if (!Validates.isAlphaNumericUlDlPA(s, false)) {
            return false;
        }
        return s.length() >= min && s.length() <= max;
    }

    public static boolean isAlphaUpperNumeric(String s) {
        return Validates.isAlphaUpperNumeric(s, false);
    }

    public static boolean isAlphaLowerNumeric(String s) {
        return Validates.isAlphaLowerNumeric(s, false);
    }

    public static boolean isAlphaUpperNumericLen(String s, int min, int max) {
        if (Validates.isEmpty(s)) {
            return min == 0;
        }
        if (!Validates.isAlphaUpperNumeric(s, false)) {
            return false;
        }
        return s.length() >= min && s.length() <= max;
    }

    public static boolean isAlphaLowerNumericLen(String s, int min, int max) {
        if (Validates.isEmpty(s)) {
            return min == 0;
        }
        if (!Validates.isAlphaLowerNumeric(s, false)) {
            return false;
        }
        return s.length() >= min && s.length() <= max;
    }

    public static boolean isHexString(String s) {
        return Validates.isRegexp("^[A-Fa-f0-9]+$", s, false);
    }

    public static boolean isMD5String(String s) {
        return Validates.isRegexp("^[A-Fa-f0-9]{32}$", s, false);
    }

    public static boolean isFloat(String s) {
        return Validates.isFloat(s, false);
    }

    public static boolean isAmount2R(String s) {
        return Validates.isAmount2R(s, false);
    }

    public static boolean isMobile(String s) {
        return Validates.isMobile(s, false);
    }

    public static boolean isMobile11(String s) {
        return Validates.isMobile11(s, false);
    }

    public static boolean isCurrentDate(String date) {
        return DateTimes.getDateString().equals(date);
    }

    public static boolean isDate(String date) {
        return Validates.isDate(date, false);
    }

    public static boolean isTime(String time) {
        return Validates.isTime(time, false);
    }

    public static boolean isDateTime(String datetime) {
        return Validates.isDateTime(datetime, false);
    }

    public static boolean isIdcard(String idcard) {
        return Validates.isIdcard(idcard, false);
    }

    public static boolean isUserName(String name) {
        return Validates.isRegexp("^[a-zA-Z0-9\\u4e00-\\u9fa5][._\\-`~!@#$%a-zA-Z0-9\\u4e00-\\u9fa5]{1,15}$", name);
    }

    public static boolean isUserPass(String password) {
        return Validates.isRegexp("^(?:(?=.*[A-Z])(?=.*[a-z])(?=.*[0-9])|(?=.*[A-Z])(?=.*[a-z])(?=.*[._\\-`~!@#$%])|(?=.*[A-Z])(?=.*[0-9])(?=.*[._\\-`~!@#$%])|(?=.*[a-z])(?=.*[0-9])(?=.*[._\\-`~!@#$%])).{6,16}$", password);
    }

    public static boolean isEmail(String s) {
        return Validates.isEmail(s, false);
    }

    public static boolean isIP(String s) {
        return Validates.isIP(s, false);
    }

    public static boolean isIPMask(String s) {
        if (Validates.isEmptyBlank(s)) {
            return false;
        }
        int ind = (s = s.trim()).indexOf("/");
        if (ind == -1) {
            String[] ipMaskValues = Arrays.toStringArray(s, "\\.");
            if (ipMaskValues.length != 4) {
                return false;
            }
            String[] stringArray = ipMaskValues;
            int n = ipMaskValues.length;
            int n2 = 0;
            while (n2 < n) {
                String ipMaskValue = stringArray[n2];
                if (!"*".equals(ipMaskValue)) {
                    if (!Validates.isNumericLen(ipMaskValue, 1, 3)) {
                        return false;
                    }
                    int value = Integer.parseInt(ipMaskValue);
                    if (value > 255) {
                        return false;
                    }
                }
                ++n2;
            }
            return true;
        }
        String ipMaskIp = s.substring(0, ind).trim();
        String ipMaskMask = s.substring(ind + 1).trim();
        if (!Validates.isIP(ipMaskIp)) {
            return false;
        }
        if (Validates.isIntegerNonnegative(ipMaskMask)) {
            return Integer.parseInt(ipMaskMask) <= 32;
        }
        if (!Validates.isIP(ipMaskMask)) {
            return false;
        }
        return IPs.ipMaskToInt(ipMaskMask) != -1;
    }

    public static boolean isIPAllowByWhiteBlackList(String ip, String ipWhiteList, String ipBlackList, boolean defaultValue) {
        List<String> ipList;
        if (defaultValue) {
            List<String> ipList2;
            if (Validates.isNotEmptyBlank(ipBlackList) && Validates.isContainIp(ipList2 = Lists.toStringList(ipWhiteList), ip)) {
                return false;
            }
        } else if (Validates.isNotEmptyBlank(ipWhiteList) && Validates.isContainIp(ipList = Lists.toStringList(ipWhiteList), ip)) {
            return true;
        }
        return defaultValue;
    }

    public static boolean isMacAddress(String s) {
        return Validates.isMacAddress(s, false);
    }

    public static boolean isPostalCode(String s) {
        return Validates.isPostalCode(s, false);
    }

    public static boolean isYear(String s) {
        if (!Validates.isNumeric(s)) {
            return false;
        }
        return s.length() == 2 || s.length() == 4;
    }

    public static boolean isWeekend(String date) {
        Calendar calendar = DateTimes.toCalendar(String.valueOf(date) + " 00:00:00");
        return calendar.get(7) == 1;
    }

    public static boolean isMonthQuarter(String date) {
        String day;
        String month;
        if (!Validates.isDate(date)) {
            return false;
        }
        String year = date.substring(0, 4);
        if (!Validates.isMonthLastDay(year, month = date.substring(5, 7), day = date.substring(8))) {
            return false;
        }
        return month.equals("03") || month.equals("06") || month.equals("09") || month.equals("12");
    }

    public static boolean isYearLastDay(String date) {
        String day;
        String month;
        if (!Validates.isDate(date)) {
            return false;
        }
        String year = date.substring(0, 4);
        if (!Validates.isMonthLastDay(year, month = date.substring(5, 7), day = date.substring(8))) {
            return false;
        }
        return month.equals("12");
    }

    public static boolean isMonth(String s) {
        if (Validates.isEmpty(s)) {
            return false;
        }
        return Validates.isIntegerValue(s, 1, 12);
    }

    public static boolean isDay(String s) {
        if (Validates.isEmpty(s)) {
            return false;
        }
        return Validates.isIntegerValue(s, 1, 31);
    }

    public static boolean isLeapYear(int year) {
        return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
    }

    public static boolean isMonthLastDay(String date) {
        if (!Validates.isDate(date)) {
            return false;
        }
        String year = date.substring(0, 4);
        String month = date.substring(5, 7);
        String day = date.substring(8);
        return Validates.isMonthLastDay(year, month, day);
    }

    public static boolean isMonthLastDay(String year, String month, String day) {
        if (!Validates.isDate(year, month, day)) {
            return false;
        }
        int yearInt = Integer.parseInt(year);
        int monthInt = Integer.parseInt(month);
        int dayInt = Integer.parseInt(day);
        return Validates.isMonthLastDay(yearInt, monthInt, dayInt);
    }

    public static boolean isMonthLastDay(int year, int month, int day) {
        if (year < 1000 || year > 9999 || month > 12 || month < 1 || day > 31 || day < 1) {
            return false;
        }
        switch (month) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                return day == 31;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return day == 30;
            }
        }
        boolean isLeapYear = Validates.isLeapYear(year);
        return isLeapYear ? day == 29 : day == 28;
    }

    public static boolean isHour(String s) {
        if (Validates.isEmpty(s)) {
            return false;
        }
        return Validates.isIntegerValue(s, 0, 23);
    }

    public static boolean isMinute(String s) {
        if (Validates.isEmpty(s)) {
            return false;
        }
        return Validates.isIntegerValue(s, 0, 59);
    }

    public static boolean isSecond(String s) {
        if (Validates.isEmpty(s)) {
            return false;
        }
        return Validates.isIntegerValue(s, 0, 59);
    }

    public static boolean isDate(String year, String month, String day) {
        if (!(Validates.isYear(year) && Validates.isMonth(month) && Validates.isDay(day))) {
            return false;
        }
        int intYear = Integer.parseInt(year);
        int intMonth = Integer.parseInt(month);
        int intDay = Integer.parseInt(day);
        if (intDay > _DAYS_IN_MONTH_[intMonth - 1]) {
            return false;
        }
        return intMonth != 2 || intDay <= (Validates.isLeapYear(intYear) ? 29 : 28);
    }

    public static boolean isDateTime(String datetime, String spe) {
        if (Validates.isEmpty(datetime)) {
            return false;
        }
        datetime = datetime.replaceAll(spe, "-");
        return Validates.isDateTime(datetime);
    }

    public static boolean isEnglishDate(String date) {
        if (Validates.isEmpty(date)) {
            return false;
        }
        date = date.replaceAll("/", "-");
        return Validates.isDate(date);
    }

    public static boolean isDateAfterToday(String date) {
        if (!Validates.isDate(date)) {
            return false;
        }
        String currentDate = DateTimes.getDateString();
        return date.compareTo(currentDate) > 0;
    }

    public static boolean isDateAfterEqualToday(String date) {
        if (!Validates.isDate(date)) {
            return false;
        }
        String currentDate = DateTimes.getDateString();
        return date.compareTo(currentDate) >= 0;
    }

    public static boolean isTime(String hour, String minute, String second) {
        return Validates.isHour(hour) && Validates.isMinute(minute) && Validates.isSecond(second);
    }

    public static boolean isInTime(String datetime, int differenceSeconds) {
        long diffTime = System.currentTimeMillis() - DateTimes.toLong(datetime);
        return !(diffTime > 0L && diffTime > (long)(differenceSeconds * 1000) || diffTime < 0L && diffTime < (long)(-differenceSeconds * 1000));
    }

    public static boolean isUrl(String s) {
        return (Strings.startsWithIgnoreCase(s, "http://") || Strings.startsWithIgnoreCase(s, "https://")) && s.length() <= 2083;
    }

    public static boolean isUrlHttp(String s) {
        return Strings.startsWithIgnoreCase(s, "http://") && s.length() <= 2083;
    }

    public static boolean isUrlHttps(String s) {
        return Strings.startsWithIgnoreCase(s, "https://") && s.length() <= 2083;
    }

    public static boolean isFileName(String fileName) {
        return Validates.isRegexp("(?!((^(?i)con$)|(^(?i)con\\..*)|(^(?i)prn$)|(^(?i)prn\\..*)|(^(?i)aux$)|(^(?i)aux\\..)|(^(?i)nul$)|(^(?i)nul\\..*)|(^(?i)com[0-9]$)|(^(?i)com[0-9]\\..*)|(^(?i)lpt[0-9]$)|(^(?i)lpt[0-9]\\..*)|(^\\s+)|(.*\\s$)|(^\\.$)))(^[^\\\\/\\:\\*\\?\\\"\\<\\>\\|]{1,255}$)", fileName);
    }

    public static boolean isContain(String strs, String separator, String str) {
        String[] s = Arrays.toStringArray(strs, separator);
        return Validates.isContain(s, str);
    }

    public static boolean isContain(String strs, String separator, int i) {
        int[] s = Arrays.toIntArray(strs, separator);
        return Validates.isContain(s, i);
    }

    public static boolean isContain(String strs, String separator, long lo) {
        long[] s = Arrays.toLongArray(strs, separator);
        return Validates.isContain(s, lo);
    }

    public static boolean isContain(String[] strs, String str) {
        if (str == null) {
            String[] stringArray = strs;
            int n = strs.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s == null) {
                    return true;
                }
                ++n2;
            }
        } else {
            String[] stringArray = strs;
            int n = strs.length;
            int n3 = 0;
            while (n3 < n) {
                String s = stringArray[n3];
                if (str.equals(s)) {
                    return true;
                }
                ++n3;
            }
        }
        return false;
    }

    public static boolean isContain(long[] longs, long lo) {
        long[] lArray = longs;
        int n = longs.length;
        int n2 = 0;
        while (n2 < n) {
            long l = lArray[n2];
            if (l == lo) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isContain(int[] ints, int io) {
        int[] nArray = ints;
        int n = ints.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            if (i == io) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isContain(Collection<?> collection, Object o) {
        return Lists.contains(collection, o);
    }

    public static boolean isContain(Collection<?> collection, String field, Object o) {
        return Lists.contains(collection, field, o);
    }

    public static boolean isContainIp(List<String> ipMaskList, String ip) {
        if (!Validates.isIP(ip)) {
            return false;
        }
        for (String ipMask : ipMaskList) {
            if (!Validates.isContainIp(ipMask, ip)) continue;
            return true;
        }
        return false;
    }

    public static boolean isContainIp(String ipMask, String ip) {
        if (!Validates.isIP(ip) || !Validates.isIPMask(ipMask)) {
            return false;
        }
        if (ipMask.equals(ip)) {
            return true;
        }
        ip = IPs.trim(ip);
        int[] ipValues = Arrays.toIntArray(ip, "\\.");
        int ind = ipMask.indexOf("/");
        if (ind == -1) {
            String[] ipMaskValues = Arrays.toStringArray(ipMask, "\\.");
            int i = 0;
            while (i < ipMaskValues.length) {
                if (!"*".equals(ipMaskValues[i]) && Integer.parseInt(ipMaskValues[i]) != ipValues[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        String ipMaskIp = ipMask.substring(0, ind);
        String ipMaskMask = ipMask.substring(ind + 1);
        int ipMaskI = -1;
        ipMaskI = Validates.isIntegerNonnegative(ipMaskMask) ? Integer.parseInt(ipMaskMask) : IPs.ipMaskToInt(ipMaskMask);
        long[] minMaxIp = IPs.calcIpMaskMinMax(ipMaskIp, ipMaskI);
        long ipLong = IPs.ipToLong(ip);
        return ipLong >= minMaxIp[0] && ipLong <= minMaxIp[1];
    }

    public static boolean isStrContainStrArr(String src, String[] strs) {
        if (Validates.isEmpty(src) || strs == null || strs.length == 0) {
            return false;
        }
        String[] stringArray = strs;
        int n = strs.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (src.contains(str)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isStrContainStrArr(String src, String strs, String split) {
        return Validates.isStrContainStrArr(src, strs.split(split));
    }

    public static boolean isMatch(String s, String pattern) {
        List<String> matchList = Lists.getMatchList(s, pattern);
        return matchList != null;
    }

    public static boolean isMatch(String s, String ... patterns) {
        String[] stringArray = patterns;
        int n = patterns.length;
        int n2 = 0;
        while (n2 < n) {
            String pattern = stringArray[n2];
            List<String> matchList = Lists.getMatchList(s, pattern);
            if (matchList != null) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

