/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.constants.CodeConstants;
import org.zhiqim.kernel.extend.MapSO;
import org.zhiqim.kernel.extend.MapSS;
import org.zhiqim.kernel.extend.TreeMapSS;
import org.zhiqim.kernel.httpclient.HttpGetStream;
import org.zhiqim.kernel.httpclient.HttpResult;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Stringx;
import org.zhiqim.kernel.util.Validates;

@AnAlias(value={"Urls"})
public class Urls
implements CodeConstants {
    public static String encodeUTF8(String src) {
        return Urls.encode(src, "UTF-8");
    }

    public static String encode(String src, String encoding) {
        if (Validates.isEmpty(src)) {
            return src;
        }
        try {
            return URLEncoder.encode(src, encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw Asserts.exception("\u975e\u6cd5\u7684\u5b57\u7b26\u7f16\u7801[" + encoding + "]");
        }
    }

    public static String decodeUTF8(String src) {
        return Urls.decode(src, "UTF-8");
    }

    public static String decode(String src, String encoding) {
        if (Validates.isEmpty(src)) {
            return src;
        }
        try {
            return URLDecoder.decode(src, encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw Asserts.exception("\u975e\u6cd5\u7684\u5b57\u7b26\u7f16\u7801[" + encoding + "]");
        }
    }

    public static void toMapUTF8(String url, Map<String, String> map) {
        Urls.toMap(url, map, "UTF-8");
    }

    public static void toMap(String url, Map<String, String> map, String encoding) {
        if (map == null) {
            return;
        }
        map.putAll(Urls.toMap(url, encoding));
    }

    public static Map<String, String> toMapUTF8(String url) {
        return Urls.toMap(url, "UTF-8");
    }

    public static Map<String, String> toMap(String url, String encoding) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (Validates.isEmpty(url)) {
            return map;
        }
        int i0 = url.indexOf(63);
        if (i0 != -1) {
            url = url.substring(i0 + 1);
        }
        int i = url.indexOf(38);
        while (i != -1) {
            String keyValue = url.substring(0, i);
            int i1 = keyValue.indexOf(61);
            if (i1 == -1) {
                map.put(keyValue, null);
            } else {
                String key = keyValue.substring(0, i1);
                String value = keyValue.substring(i1 + 1);
                value = Urls.decode(value, encoding);
                String mapValue = (String)map.get(key);
                if (mapValue != null) {
                    value = String.valueOf(mapValue) + "," + value;
                }
                map.put(key, value);
            }
            url = url.substring(i + 1);
            i = url.indexOf(38);
        }
        int i1 = url.indexOf(61);
        if (i1 != -1) {
            String key = url.substring(0, i1);
            String value = url.substring(i1 + 1);
            value = Urls.decode(value, encoding);
            String mapValue = (String)map.get(key);
            if (mapValue != null) {
                value = String.valueOf(mapValue) + "," + value;
            }
            map.put(key, value);
        }
        return map;
    }

    public static Map<String, String> toMapNoEncoded(String url) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (Validates.isEmpty(url)) {
            return map;
        }
        int i0 = url.indexOf(63);
        if (i0 != -1) {
            url = url.substring(i0 + 1);
        }
        int i = url.indexOf(38);
        while (i != -1) {
            String keyValue = url.substring(0, i);
            int i1 = keyValue.indexOf(61);
            if (i1 == -1) {
                map.put(keyValue, null);
            } else {
                String key = keyValue.substring(0, i1);
                String value = keyValue.substring(i1 + 1);
                String mapValue = (String)map.get(key);
                if (mapValue != null) {
                    value = String.valueOf(mapValue) + "," + value;
                }
                map.put(key, value);
            }
            url = url.substring(i + 1);
            i = url.indexOf(38);
        }
        int i1 = url.indexOf(61);
        if (i1 != -1) {
            String key = url.substring(0, i1);
            String value = url.substring(i1 + 1);
            String mapValue = (String)map.get(key);
            if (mapValue != null) {
                value = String.valueOf(mapValue) + "," + value;
            }
            map.put(key, value);
        }
        return map;
    }

    public static String toSignString(String key1, Object value1, String key2, Object value2) {
        TreeMap<String, Object> treeParamMap = new TreeMap<String, Object>();
        treeParamMap.put(key1, value1);
        treeParamMap.put(key2, value2);
        return Urls.toSignString(treeParamMap);
    }

    public static String toSignString(String key1, Object value1, String key2, Object value2, String key3, Object value3) {
        TreeMap<String, Object> treeParamMap = new TreeMap<String, Object>();
        treeParamMap.put(key1, value1);
        treeParamMap.put(key2, value2);
        treeParamMap.put(key3, value3);
        return Urls.toSignString(treeParamMap);
    }

    public static String toSignString(String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4) {
        TreeMap<String, Object> treeParamMap = new TreeMap<String, Object>();
        treeParamMap.put(key1, value1);
        treeParamMap.put(key2, value2);
        treeParamMap.put(key3, value3);
        treeParamMap.put(key4, value4);
        return Urls.toSignString(treeParamMap);
    }

    public static String toSignString(Map<String, Object> paramMap) {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        treeMap.putAll(paramMap);
        return Urls.toSignString(treeMap);
    }

    public static String toSignString(TreeMap<String, Object> paramMap) {
        if (paramMap.isEmpty()) {
            return "";
        }
        StringBuilder strb = new StringBuilder();
        for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
            strb.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
        }
        strb.setLength(strb.length() - 1);
        return strb.toString();
    }

    public static String toSignString(TreeMapSS paramMap) {
        if (paramMap.isEmpty()) {
            return "";
        }
        StringBuilder strb = new StringBuilder();
        for (Map.Entry<String, String> entry : paramMap.entrySet()) {
            strb.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
        }
        strb.setLength(strb.length() - 1);
        return strb.toString();
    }

    public static String toQueryString(String key1, Object value1, String key2, Object value2) {
        TreeMap<String, Object> treeParamMap = new TreeMap<String, Object>();
        treeParamMap.put(key1, value1);
        treeParamMap.put(key2, value2);
        return Urls.toQueryString(treeParamMap);
    }

    public static String toQueryString(String key1, Object value1, String key2, Object value2, String key3, Object value3) {
        TreeMap<String, Object> treeParamMap = new TreeMap<String, Object>();
        treeParamMap.put(key1, value1);
        treeParamMap.put(key2, value2);
        treeParamMap.put(key3, value3);
        return Urls.toQueryString(treeParamMap);
    }

    public static String toQueryString(String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4) {
        TreeMap<String, Object> treeParamMap = new TreeMap<String, Object>();
        treeParamMap.put(key1, value1);
        treeParamMap.put(key2, value2);
        treeParamMap.put(key3, value3);
        treeParamMap.put(key4, value4);
        return Urls.toQueryString(treeParamMap);
    }

    public static String toQueryString(MapSO paramMap) {
        return Urls.toQueryString(paramMap.instance());
    }

    public static String toQueryString(Map<String, Object> paramMap) {
        StringBuilder strb = new StringBuilder();
        boolean isFirst = true;
        for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
            String key = entry.getKey();
            String value = Urls.encodeUTF8(String.valueOf(entry.getValue()));
            if (!isFirst) {
                strb.append("&").append(key).append("=").append(value);
                continue;
            }
            isFirst = false;
            strb.append(key).append("=").append(value);
        }
        return strb.toString();
    }

    public static String toQueryStringString(MapSS paramMap) {
        return Urls.toQueryStringString(paramMap.instance());
    }

    public static String toQueryStringString(Map<String, String> paramMap) {
        StringBuilder strb = new StringBuilder();
        boolean isFirst = true;
        for (Map.Entry<String, String> entry : paramMap.entrySet()) {
            String key = entry.getKey();
            String value = Urls.encodeUTF8(entry.getValue());
            if (!isFirst) {
                strb.append("&").append(key).append("=").append(value);
                continue;
            }
            isFirst = false;
            strb.append(key).append("=").append(value);
        }
        return strb.toString();
    }

    public static String get(String url, String key) {
        int ind;
        if (Validates.isEmpty(url) || Validates.isEmpty(key)) {
            return "";
        }
        key = "&" + key + "=";
        int p = url.indexOf("?");
        if (p != -1) {
            url = url.substring(p + 1);
        }
        if ((ind = (url = Strings.addStartsWith(url, "&")).indexOf(key)) == -1) {
            return "";
        }
        int start = ind + key.length();
        int ind2 = url.indexOf(38, start);
        if (ind2 == -1) {
            return url.substring(start);
        }
        return url.substring(start, ind2);
    }

    public static String get(String url, String key, String encoding) {
        String value = Urls.get(url, key);
        return Urls.decode(value, encoding);
    }

    public static String add(String url, String key, String value) {
        if (Validates.isEmptyBlank(url) || Validates.isEmptyBlank(key)) {
            return Stringx.trim(url);
        }
        if (Validates.isEmptyBlank(value)) {
            value = "";
        }
        url = (url = url.trim()).indexOf("?") == -1 ? String.valueOf(url) + "?" + key.trim() + "=" + value.trim() : String.valueOf(url) + "&" + key.trim() + "=" + value.trim();
        return url;
    }

    public static String add(String url, String key, String value, String encoding) {
        value = Urls.encode(value, encoding);
        return Urls.add(url, key, value);
    }

    public static String modify(String url, String key, String value) {
        int index;
        if (Validates.isEmpty(url) || Validates.isEmpty(key)) {
            return url;
        }
        if (Validates.isEmpty(value)) {
            value = "";
        }
        if ((index = url.indexOf(String.valueOf(key) + "=")) == -1) {
            return Urls.add(url, key, value);
        }
        if (index + key.length() == url.length()) {
            url = String.valueOf(url) + value;
            return url;
        }
        int valueIndex = url.indexOf(38, index + key.length());
        if (valueIndex == -1) {
            return String.valueOf(url.substring(0, index + key.length() + 1)) + value;
        }
        return String.valueOf(url.substring(0, index + key.length() + 1)) + value + url.substring(valueIndex);
    }

    public static String modify(String url, String key, String value, String encoding) {
        value = Urls.encode(value, encoding);
        return Urls.modify(url, key, value);
    }

    public static String delete(String url, String key) {
        if (Validates.isEmptyBlank(url) || Validates.isEmptyBlank(key)) {
            return Stringx.trim(url);
        }
        int index = (url = url.trim()).indexOf(String.valueOf(key = key.trim()) + "=");
        if (index == -1) {
            return url;
        }
        if (index + key.length() == url.length()) {
            return url.substring(0, index);
        }
        int valueIndex = url.indexOf(38, index + key.length());
        if (valueIndex == -1) {
            return url.substring(0, index - 1);
        }
        return String.valueOf(url.substring(0, index)) + url.substring(valueIndex + 1);
    }

    public static HttpResult read(String url, int timeout) {
        HttpGetStream conn = new HttpGetStream(url);
        conn.setConnectTimeout(timeout);
        conn.setReadTimeout(timeout);
        conn.execute();
        if (conn.getResponseStatus() != 200) {
            return new HttpResult(conn.getResponseStatus(), conn.getResponseText());
        }
        return new HttpResult(conn.getResponseStatus(), conn.getResponseText(), conn.getBytes());
    }

    public static HttpResult read(String url, int connTimeout, int readTimeout) {
        HttpGetStream conn = new HttpGetStream(url);
        conn.setConnectTimeout(connTimeout);
        conn.setReadTimeout(readTimeout);
        conn.execute();
        if (conn.getResponseStatus() != 200) {
            return new HttpResult(conn.getResponseStatus(), conn.getResponseText());
        }
        return new HttpResult(conn.getResponseStatus(), conn.getResponseText(), conn.getBytes());
    }
}

