/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.util;

import java.net.Socket;
import java.net.SocketException;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.util.Asserts;

@AnAlias(value={"Sockets"})
public class Sockets {
    public static void setOption(Socket socket, boolean tcpNoDelay, int soTimeoutMs, int soLingerS) {
        try {
            socket.setTcpNoDelay(tcpNoDelay);
            if (soTimeoutMs >= 0) {
                socket.setSoTimeout(soTimeoutMs);
            }
            if (soLingerS > 0) {
                socket.setSoLinger(true, soLingerS);
            } else {
                socket.setSoLinger(false, 0);
            }
        }
        catch (SocketException socketException) {
            throw Asserts.exception("Sockets.setOption{soTimeoutMs:" + soTimeoutMs + ",soLingerS:" + soLingerS + "},SocketException");
        }
    }

    public static void setOption(Socket socket, boolean tcpNoDelay, int soTimeoutMs, int soLingerS, boolean keepAlive) {
        try {
            socket.setTcpNoDelay(tcpNoDelay);
            if (soTimeoutMs >= 0) {
                socket.setSoTimeout(soTimeoutMs);
            }
            if (soLingerS > 0) {
                socket.setSoLinger(true, soLingerS);
            } else {
                socket.setSoLinger(false, 0);
            }
            socket.setKeepAlive(keepAlive);
        }
        catch (SocketException socketException) {
            throw Asserts.exception("Sockets.setOption{soTimeoutMs:" + soTimeoutMs + ",soLingerS:" + soLingerS + "},SocketException");
        }
    }
}

