/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.util;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.constants.RegexpConstants;
import org.zhiqim.kernel.constants.SignConstants;
import org.zhiqim.kernel.util.Validates;

@AnAlias(value={"Replaces"})
public class Replaces
implements RegexpConstants,
SignConstants {
    public static String replaceQuotation(String str) {
        if (Validates.isEmpty(str)) {
            return str;
        }
        return str.replaceAll("'", "\\\\'");
    }

    public static String replaceDoubleQuotation(String str) {
        if (Validates.isEmpty(str)) {
            return str;
        }
        return str.replaceAll("\"", "\\\\\"");
    }

    public static String replaceBackslash(String str, String replacement) {
        return Replaces.replaceAllEscape(str, "\\", replacement);
    }

    public static String replaceAllSymbols(String str) {
        if (Validates.isEmptyBlank(str)) {
            return str;
        }
        return str.replaceAll("[\u2300-\u23ff]|[\u2600-\u27ff]|[\u2b00-\u2bff]|[\ufe00-\ufe0f]|[\ud83c\udc00-\ud83c\udfff]|[\ud83d\udc00-\ud83d\udfff]|[\ud83e\udc00-\ud83e\udfff]|[\ud800\udc00-\udbff\udfff]", "");
    }

    public static String replaceSymbols(String str) {
        if (Validates.isEmptyBlank(str)) {
            return str;
        }
        return str.replaceAll("[\u2300-\u23ff]|[\u2600-\u27ff]|[\u2b00-\u2bff]|[\ufe00-\ufe0f]", "");
    }

    public static String replaceEmojiIOS(String str) {
        if (Validates.isEmptyBlank(str)) {
            return str;
        }
        return str.replaceAll("[\ud83c\udc00-\ud83c\udfff]|[\ud83d\udc00-\ud83d\udfff]|[\ud83e\udc00-\ud83e\udfff]|[\ud800\udc00-\udbff\udfff]", "");
    }

    public static String replaceAllEscape(String str, String regex, String replacement) {
        char c;
        if (Validates.isEmpty(str)) {
            return str;
        }
        StringBuilder strb = new StringBuilder();
        int i = 0;
        while (i < regex.length()) {
            c = regex.charAt(i);
            if (Validates.isCharInString(c, "*.?+$^[](){}|\\/")) {
                strb.append("\\");
            }
            strb.append(c);
            ++i;
        }
        regex = strb.toString();
        strb = new StringBuilder();
        i = 0;
        while (i < replacement.length()) {
            c = replacement.charAt(i);
            if (Validates.isCharInString(c, "*.?+$^[](){}|\\/")) {
                strb.append("\\");
            }
            strb.append(c);
            ++i;
        }
        replacement = strb.toString();
        return str.replaceAll(regex, replacement);
    }

    public static String toReplaceEscape(String replace) {
        StringBuilder strb = new StringBuilder();
        int i = 0;
        while (i < replace.length()) {
            char c = replace.charAt(i);
            if (Validates.isCharInString(c, "*.?+$^[](){}|\\/")) {
                strb.append("\\");
            }
            strb.append(c);
            ++i;
        }
        return strb.toString();
    }
}

