/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.util;

import org.zhiqim.kernel.annotation.AnAlias;

@AnAlias(value={"Longs"})
public class Longs {
    public static long toLong(String s) {
        return Long.parseLong(s);
    }

    public static long toLong(String s, long defaultValue) {
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public static long toLong(Object o, long defaultValue) {
        if (o == null) {
            return defaultValue;
        }
        if (o instanceof Integer) {
            return ((Integer)o).intValue();
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof String) {
            return Longs.toLong((String)o, defaultValue);
        }
        return defaultValue;
    }

    public static int length(long val) {
        if (val == 0L) {
            return 1;
        }
        boolean isNegative = false;
        if (val < 0L) {
            val = -val;
            isNegative = true;
        }
        int len = 0;
        long i = val;
        while (i != 0L) {
            ++len;
            i /= 10L;
        }
        return isNegative ? len + 1 : len;
    }

    public static long getMaxLong(int length) {
        if (length >= 19) {
            return Long.MAX_VALUE;
        }
        if (length <= 0) {
            return 9L;
        }
        String maxString = "999999999999999999".substring(0, length);
        return Longs.toLong(maxString);
    }

    public static int compareUnsigned(long a, long b) {
        long cmp = (a >>> 1) - (b >>> 1);
        if (cmp != 0L) {
            return cmp > 0L ? 1 : -1;
        }
        cmp = (a & 1L) - (b & 1L);
        return cmp > 0L ? 1 : (cmp < 0L ? -1 : 0);
    }
}

