/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.util;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.constants.CodeConstants;
import org.zhiqim.kernel.constants.EnumConstants;
import org.zhiqim.kernel.enumerated.LetterCase;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Hexs;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.kernel.util.mutables.MInt;

@AnAlias(value={"Bytes"})
public class Bytes
implements CodeConstants,
EnumConstants {
    public static final Bytes BU = new Bytes(true, "UTF-8");
    public static final Bytes BG = new Bytes(true, "GBK");
    public static final Bytes BI = new Bytes(true, "ISO-8859-1");
    public static final Bytes LU = new Bytes(false, "UTF-8");
    public static final Bytes LG = new Bytes(false, "GBK");
    public static final Bytes LI = new Bytes(false, "ISO-8859-1");
    private Charset encoding = _UTF_8_C_;
    private boolean isBigEndian = true;

    public Bytes() {
    }

    public Bytes(boolean isBigEndian) {
        this.isBigEndian = isBigEndian;
    }

    public Bytes(String encoding) {
        this.encoding = Charset.forName(encoding);
    }

    public Bytes(boolean isBigEndian, String encoding) {
        this.isBigEndian = isBigEndian;
        this.encoding = Charset.forName(encoding);
    }

    public char getChar2(byte[] b, MInt off) {
        int offset = off.value;
        off.value += 2;
        return this.getChar2(b, offset);
    }

    public short getShort(byte[] b, MInt off) {
        int offset = off.value;
        off.value += 2;
        return this.getShort(b, offset);
    }

    public int getShortUnsigned(byte[] b, MInt off) {
        int offset = off.value;
        off.value += 2;
        return this.getShortUnsigned(b, offset);
    }

    public int getInt(byte[] b, MInt off) {
        int offset = off.value;
        off.value += 4;
        return this.getInt(b, offset);
    }

    public long getIntUnsigned(byte[] b, MInt off) {
        int offset = off.value;
        off.value += 4;
        return this.getIntUnsigned(b, offset);
    }

    public float getFloat(byte[] b, MInt off) {
        int offset = off.value;
        off.value += 4;
        return this.getFloat(b, offset);
    }

    public long getLong(byte[] b, MInt off) {
        int offset = off.value;
        off.value += 8;
        return this.getLong(b, offset);
    }

    public double getDouble(byte[] b, MInt off) {
        int offset = off.value;
        off.value += 8;
        return this.getDouble(b, offset);
    }

    public String getString(byte[] b, MInt off) {
        off.value = b.length;
        return new String(b, off.value, b.length - off.value, this.encoding);
    }

    public String getString(byte[] b, MInt off, char val) {
        return this.getString(b, off, (byte)val);
    }

    public String getString(byte[] b, MInt off, byte val) {
        int offset;
        int i = offset = off.value;
        int len = b.length;
        while (i < len) {
            if (b[i] == val) break;
            ++i;
        }
        byte[] tmp = new byte[i - offset];
        System.arraycopy(b, offset, tmp, 0, i - offset);
        String str = new String(tmp, this.encoding);
        off.value = i + 1;
        return str;
    }

    public String getString(byte[] b, MInt off, int len) {
        int offset = off.value;
        int i = 0;
        while (i < len) {
            if (offset + i >= b.length || b[offset + i] == 0) break;
            ++i;
        }
        byte[] tmp = new byte[i];
        System.arraycopy(b, offset, tmp, 0, i);
        String str = new String(tmp, this.encoding);
        off.value += len;
        return str;
    }

    public String getString(byte[] b, MInt off, int len, boolean hasEnd) {
        int offset = off.value;
        int i = 0;
        while (i < len) {
            if (offset + i >= b.length || b[offset + i] == 0) break;
            ++i;
        }
        byte[] tmp = new byte[i];
        System.arraycopy(b, offset, tmp, 0, i);
        String str = new String(tmp, this.encoding);
        off.value = hasEnd ? (off.value += len + 1) : (off.value += len);
        return str;
    }

    public void putChar2(byte[] b, MInt off, char val) {
        off.value = this.putChar2(b, off.value, val);
    }

    public void putShort(byte[] b, MInt off, short val) {
        off.value = this.putShort(b, off.value, val);
    }

    public void putShort(byte[] b, MInt off, int val) {
        this.putShort(b, off, (short)val);
    }

    public void putInt(byte[] b, MInt off, int val) {
        off.value = this.putInt(b, off.value, val);
    }

    public void putFloat(byte[] b, MInt off, float val) {
        off.value = this.putFloat(b, off.value, val);
    }

    public void putLong(byte[] b, MInt off, long val) {
        off.value = this.putLong(b, off.value, val);
    }

    public void putDouble(byte[] b, MInt off, double val) {
        off.value = this.putDouble(b, off.value, val);
    }

    public void putString(byte[] b, MInt off, String str) {
        if (Validates.isEmpty(str)) {
            return;
        }
        byte[] ret = str.getBytes(this.encoding);
        System.arraycopy(ret, 0, b, off.value, ret.length);
        off.value += ret.length;
    }

    public void putString(byte[] b, MInt off, String str, byte endValue) {
        if (Validates.isEmpty(str)) {
            b[off.value] = endValue;
            ++off.value;
            return;
        }
        byte[] ret = str.getBytes(this.encoding);
        System.arraycopy(ret, 0, b, off.value, ret.length);
        b[off.value + ret.length] = endValue;
        off.value += ret.length + 1;
    }

    public void putString(byte[] b, MInt off, String str, int len) {
        if (Validates.isEmpty(str)) {
            off.value += len;
            return;
        }
        byte[] ret = str.getBytes(this.encoding);
        if (ret.length > len) {
            System.arraycopy(ret, 0, b, off.value, len);
        } else {
            System.arraycopy(ret, 0, b, off.value, ret.length);
        }
        off.value += len;
    }

    public void putString(byte[] b, MInt off, String str, int len, byte endValue) {
        if (Validates.isEmpty(str)) {
            b[off.value + len] = endValue;
            off.value += len + 1;
            return;
        }
        byte[] ret = str.getBytes(this.encoding);
        if (ret.length > len) {
            System.arraycopy(ret, 0, b, off.value, len);
        } else {
            System.arraycopy(ret, 0, b, off.value, ret.length);
        }
        b[off.value + len] = endValue;
        off.value += len + 1;
    }

    public char getChar2(byte[] b, int off) {
        return this.isBigEndian ? (char)(((b[off + 1] & 0xFF) << 0) + ((b[off + 0] & 0xFF) << 8)) : (char)(((b[off + 0] & 0xFF) << 0) + ((b[off + 1] & 0xFF) << 8));
    }

    public short getShort(byte[] b, int off) {
        return (short)this.getShortUnsigned(b, off);
    }

    public int getShortUnsigned(byte[] b, int off) {
        return this.isBigEndian ? ((b[off + 1] & 0xFF) << 0) + ((b[off + 0] & 0xFF) << 8) : ((b[off + 0] & 0xFF) << 0) + ((b[off + 1] & 0xFF) << 8);
    }

    public int getInt(byte[] b, int off) {
        return this.isBigEndian ? ((b[off + 3] & 0xFF) << 0) + ((b[off + 2] & 0xFF) << 8) + ((b[off + 1] & 0xFF) << 16) + ((b[off + 0] & 0xFF) << 24) : ((b[off + 0] & 0xFF) << 0) + ((b[off + 1] & 0xFF) << 8) + ((b[off + 2] & 0xFF) << 16) + ((b[off + 3] & 0xFF) << 24);
    }

    public long getIntUnsigned(byte[] b, int off) {
        return (long)this.getInt(b, off) & 0xFFFFFFFFL;
    }

    public float getFloat(byte[] b, int off) {
        int i = this.isBigEndian ? ((b[off + 3] & 0xFF) << 0) + ((b[off + 2] & 0xFF) << 8) + ((b[off + 1] & 0xFF) << 16) + ((b[off + 0] & 0xFF) << 24) : ((b[off + 0] & 0xFF) << 0) + ((b[off + 1] & 0xFF) << 8) + ((b[off + 2] & 0xFF) << 16) + ((b[off + 3] & 0xFF) << 24);
        return Float.intBitsToFloat(i);
    }

    public long getLong(byte[] b, int off) {
        return this.isBigEndian ? (((long)b[off + 7] & 0xFFL) << 0) + (((long)b[off + 6] & 0xFFL) << 8) + (((long)b[off + 5] & 0xFFL) << 16) + (((long)b[off + 4] & 0xFFL) << 24) + (((long)b[off + 3] & 0xFFL) << 32) + (((long)b[off + 2] & 0xFFL) << 40) + (((long)b[off + 1] & 0xFFL) << 48) + (((long)b[off + 0] & 0xFFL) << 56) : (((long)b[off + 0] & 0xFFL) << 0) + (((long)b[off + 1] & 0xFFL) << 8) + (((long)b[off + 2] & 0xFFL) << 16) + (((long)b[off + 3] & 0xFFL) << 24) + (((long)b[off + 4] & 0xFFL) << 32) + (((long)b[off + 5] & 0xFFL) << 40) + (((long)b[off + 6] & 0xFFL) << 48) + (((long)b[off + 7] & 0xFFL) << 56);
    }

    public double getDouble(byte[] b, int off) {
        long j = this.isBigEndian ? (((long)b[off + 7] & 0xFFL) << 0) + (((long)b[off + 6] & 0xFFL) << 8) + (((long)b[off + 5] & 0xFFL) << 16) + (((long)b[off + 4] & 0xFFL) << 24) + (((long)b[off + 3] & 0xFFL) << 32) + (((long)b[off + 2] & 0xFFL) << 40) + (((long)b[off + 1] & 0xFFL) << 48) + (((long)b[off + 0] & 0xFFL) << 56) : (((long)b[off + 0] & 0xFFL) << 0) + (((long)b[off + 1] & 0xFFL) << 8) + (((long)b[off + 2] & 0xFFL) << 16) + (((long)b[off + 3] & 0xFFL) << 24) + (((long)b[off + 4] & 0xFFL) << 32) + (((long)b[off + 5] & 0xFFL) << 40) + (((long)b[off + 6] & 0xFFL) << 48) + (((long)b[off + 7] & 0xFFL) << 56);
        return Double.longBitsToDouble(j);
    }

    public String getString(byte[] b, int off, char val) {
        return this.getString(b, off, (byte)val);
    }

    public String getString(byte[] b, int off, byte val) {
        int i = off;
        int allLen = b.length;
        while (i < allLen) {
            if (b[i] == val) break;
            ++i;
        }
        byte[] tmp = new byte[i - off];
        System.arraycopy(b, off, tmp, 0, i - off);
        return new String(tmp, this.encoding);
    }

    public String getString(byte[] b, int off, int len) {
        int i = 0;
        while (i < len) {
            if (off + i >= b.length || b[off + i] == 0) break;
            ++i;
        }
        byte[] tmp = new byte[i];
        System.arraycopy(b, off, tmp, 0, i);
        return new String(tmp, this.encoding);
    }

    public int putChar2(byte[] b, int off, char val) {
        if (this.isBigEndian) {
            b[off + 1] = (byte)(val >>> 0);
            b[off + 0] = (byte)(val >>> 8);
        } else {
            b[off + 0] = (byte)(val >>> 0);
            b[off + 1] = (byte)(val >>> 8);
        }
        return off + 2;
    }

    public int putShort(byte[] b, int off, short val) {
        if (this.isBigEndian) {
            b[off + 1] = (byte)(val >>> 0);
            b[off + 0] = (byte)(val >>> 8);
        } else {
            b[off + 0] = (byte)(val >>> 0);
            b[off + 1] = (byte)(val >>> 8);
        }
        return off + 2;
    }

    public int putShort(byte[] b, int off, int val) {
        return this.putShort(b, off, (short)val);
    }

    public int putInt(byte[] b, int off, int val) {
        if (this.isBigEndian) {
            b[off + 3] = (byte)(val >>> 0);
            b[off + 2] = (byte)(val >>> 8);
            b[off + 1] = (byte)(val >>> 16);
            b[off + 0] = (byte)(val >>> 24);
        } else {
            b[off + 0] = (byte)(val >>> 0);
            b[off + 1] = (byte)(val >>> 8);
            b[off + 2] = (byte)(val >>> 16);
            b[off + 3] = (byte)(val >>> 24);
        }
        return off + 4;
    }

    public int putFloat(byte[] b, int off, float val) {
        int i = Float.floatToIntBits(val);
        if (this.isBigEndian) {
            b[off + 3] = (byte)(i >>> 0);
            b[off + 2] = (byte)(i >>> 8);
            b[off + 1] = (byte)(i >>> 16);
            b[off + 0] = (byte)(i >>> 24);
        } else {
            b[off + 0] = (byte)(i >>> 0);
            b[off + 1] = (byte)(i >>> 8);
            b[off + 2] = (byte)(i >>> 16);
            b[off + 3] = (byte)(i >>> 24);
        }
        return off + 4;
    }

    public int putLong(byte[] b, int off, long val) {
        if (this.isBigEndian) {
            b[off + 7] = (byte)(val >>> 0);
            b[off + 6] = (byte)(val >>> 8);
            b[off + 5] = (byte)(val >>> 16);
            b[off + 4] = (byte)(val >>> 24);
            b[off + 3] = (byte)(val >>> 32);
            b[off + 2] = (byte)(val >>> 40);
            b[off + 1] = (byte)(val >>> 48);
            b[off + 0] = (byte)(val >>> 56);
        } else {
            b[off + 0] = (byte)(val >>> 0);
            b[off + 1] = (byte)(val >>> 8);
            b[off + 2] = (byte)(val >>> 16);
            b[off + 3] = (byte)(val >>> 24);
            b[off + 4] = (byte)(val >>> 32);
            b[off + 5] = (byte)(val >>> 40);
            b[off + 6] = (byte)(val >>> 48);
            b[off + 7] = (byte)(val >>> 56);
        }
        return off + 8;
    }

    public int putDouble(byte[] b, int off, double val) {
        long j = Double.doubleToLongBits(val);
        if (this.isBigEndian) {
            b[off + 7] = (byte)(j >>> 0);
            b[off + 6] = (byte)(j >>> 8);
            b[off + 5] = (byte)(j >>> 16);
            b[off + 4] = (byte)(j >>> 24);
            b[off + 3] = (byte)(j >>> 32);
            b[off + 2] = (byte)(j >>> 40);
            b[off + 1] = (byte)(j >>> 48);
            b[off + 0] = (byte)(j >>> 56);
        } else {
            b[off + 0] = (byte)(j >>> 0);
            b[off + 1] = (byte)(j >>> 8);
            b[off + 2] = (byte)(j >>> 16);
            b[off + 3] = (byte)(j >>> 24);
            b[off + 4] = (byte)(j >>> 32);
            b[off + 5] = (byte)(j >>> 40);
            b[off + 6] = (byte)(j >>> 48);
            b[off + 7] = (byte)(j >>> 56);
        }
        return off + 8;
    }

    public int putString(byte[] b, int off, String str) {
        if (Validates.isEmpty(str)) {
            return off;
        }
        byte[] ret = str.getBytes(this.encoding);
        System.arraycopy(ret, 0, b, off, ret.length);
        return off + ret.length;
    }

    public int putString(byte[] b, int off, String str, int len) {
        if (Validates.isEmpty(str)) {
            return off + len;
        }
        byte[] ret = str.getBytes(this.encoding);
        if (ret.length > len) {
            System.arraycopy(ret, 0, b, off, len);
        } else {
            System.arraycopy(ret, 0, b, off, ret.length);
        }
        return off + len;
    }

    public int getByteLen(String str) {
        if (str == null) {
            return 0;
        }
        try {
            return str.getBytes(this.encoding).length;
        }
        catch (Exception exception) {
            return str.getBytes().length;
        }
    }

    public String toString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        int len = 0;
        int i = 0;
        while (i < bytes.length) {
            if (bytes[i] == 0) break;
            ++len;
            ++i;
        }
        return len == 0 ? "" : new String(bytes, this.encoding);
    }

    public byte[] toBytes(short val) {
        byte[] b = new byte[2];
        this.putShort(b, 0, val);
        return b;
    }

    public byte[] toBytes(int val) {
        byte[] b = new byte[4];
        this.putInt(b, 0, val);
        return b;
    }

    public byte[] toBytes(long val) {
        byte[] b = new byte[8];
        this.putLong(b, 0, val);
        return b;
    }

    public byte[] toBytes(float val) {
        byte[] b = new byte[4];
        this.putFloat(b, 0, val);
        return b;
    }

    public byte[] toBytes(double val) {
        byte[] b = new byte[8];
        this.putDouble(b, 0, val);
        return b;
    }

    public byte[] toBytes(String str) {
        return str == null ? new byte[]{} : str.getBytes(this.encoding);
    }

    public byte[] toBytes(String str, int len) {
        if (str == null) {
            return new byte[len];
        }
        byte[] buf = str.getBytes(this.encoding);
        byte[] bytes = new byte[len];
        if (buf.length > len) {
            System.arraycopy(buf, 0, bytes, 0, len);
        } else {
            System.arraycopy(buf, 0, bytes, 0, buf.length);
        }
        return bytes;
    }

    public byte[] toBytesByIp(String ip) {
        byte[] b = new byte[4];
        Bytes.putIp4(b, 0, ip);
        return b;
    }

    public static byte[] toHexBytes(byte[] b, LetterCase letter) {
        return Bytes.toBytesASCII(Hexs.toHexString(b, letter));
    }

    public byte[] toHexBytes(short val, LetterCase letter) {
        return Bytes.toHexBytes(this.toBytes(val), letter);
    }

    public byte[] toHexBytes(int val, LetterCase letter) {
        return Bytes.toHexBytes(this.toBytes(val), letter);
    }

    public byte[] toHexBytesByShort(int val, LetterCase letter) {
        return Bytes.toHexBytes(this.toBytes((short)val), letter);
    }

    public void putHexBytes(byte[] b, int off, short val, LetterCase letter) {
        Bytes.putBytes(b, off, Bytes.toHexBytes(this.toBytes(val), letter));
    }

    public void putHexBytes(byte[] b, int off, int val, LetterCase letter) {
        Bytes.putBytes(b, off, Bytes.toHexBytes(this.toBytes(val), letter));
    }

    public void putHexBytesByShort(byte[] b, int off, int val, LetterCase letter) {
        Bytes.putBytes(b, off, Bytes.toHexBytes(this.toBytes((short)val), letter));
    }

    public static char[] toCharArray(byte[] bytes) {
        char[] result = new char[bytes.length];
        int i = 0;
        while (i < bytes.length) {
            result[i] = (char)(bytes[i] & 0xFF);
            ++i;
        }
        return result;
    }

    public static char[] toCharArray(byte[] bytes, int off, int len) {
        Asserts.as((String)(bytes != null && bytes.length >= off + len ? null : "\u5b57\u8282\u6570\u7ec4\u8f6c\u4e3a\u5b57\u7b26\u6570\u7ec4\u65f6\uff0c\u957f\u5ea6\u4e0d\u6ee1\u8db3\u8981\u6c42"));
        char[] result = new char[len];
        int i = 0;
        while (i < len) {
            result[i] = (char)(bytes[off] & 0xFF);
            ++i;
            ++off;
        }
        return result;
    }

    public static String toStringASCII(byte[] bytes) {
        return new String(Bytes.toCharArray(bytes));
    }

    public static String toStringASCII(byte[] bytes, int off, int len) {
        return new String(Bytes.toCharArray(bytes, off, len));
    }

    public static String toString(ByteBuffer buf, Charset charset) throws CharacterCodingException {
        CharsetDecoder decoder = charset.newDecoder();
        decoder.onMalformedInput(CodingErrorAction.REPORT);
        decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        return decoder.decode(buf).toString();
    }

    public static byte[] toBytes(String str, String encoding) {
        if (str == null) {
            return new byte[0];
        }
        try {
            return str.getBytes(encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw Asserts.exception("\u4e0d\u652f\u6301\u7684\u7f16\u7801\u683c\u5f0f[" + encoding + "]");
        }
    }

    public static byte[] toBytesGBK(String str) {
        return str == null ? new byte[]{} : str.getBytes(_GBK_C_);
    }

    public static byte[] toBytesUTF8(String str) {
        return str == null ? new byte[]{} : str.getBytes(_UTF_8_C_);
    }

    public static byte[] toBytesASCII(String str) {
        byte[] b = new byte[str.length()];
        int i = 0;
        while (i < b.length) {
            char c = str.charAt(i);
            Asserts.as(c <= '\u007f' ? null : "\u5b58\u5728\u975eASCII\u5b57\u7b26\uff0c\u4e0d\u652f\u6301");
            b[i] = (byte)c;
            ++i;
        }
        return b;
    }

    public static byte[] toBytesASCII(long val) {
        return Bytes.toBytesASCII(String.valueOf(val));
    }

    public static byte[] toBytesASCII(int val) {
        return Bytes.toBytesASCII(String.valueOf(val));
    }

    public static void fillBytes(byte[] bytes, int off, byte b, int len) {
        int i = 0;
        while (i < bytes.length) {
            if (i >= off) {
                if (i == off + len) break;
                bytes[i] = b;
            }
            ++i;
        }
    }

    public static int getByteLen(String str, String encoding) {
        return Bytes.toBytes(str, encoding).length;
    }

    public static byte[] getBytes(byte[] b, int off) {
        byte[] bytes = new byte[b.length - off];
        System.arraycopy(b, off, bytes, 0, b.length - off);
        return bytes;
    }

    public static byte[] getBytes(byte[] b, int off, int len) {
        byte[] bytes = new byte[len];
        if (len + off <= b.length) {
            System.arraycopy(b, off, bytes, 0, len);
        } else {
            System.arraycopy(b, off, bytes, 0, b.length - off);
        }
        return bytes;
    }

    public static byte[] getBytes(byte[] b, int off, char val) {
        return Bytes.getBytes(b, off, (byte)val);
    }

    public static byte[] getBytes(byte[] b, int off, byte val) {
        int len = Bytes.next(b, off, val) - off - 1;
        return Bytes.getBytes(b, off, len);
    }

    public static byte[] getBytes(byte[] b, MInt off, char val) {
        return Bytes.getBytes(b, off, (byte)val);
    }

    public static byte[] getBytes(byte[] b, MInt off, byte val) {
        int offset = off.value;
        off.value = Bytes.next(b, offset, val);
        return Bytes.getBytes(b, offset, off.value - offset - 1);
    }

    public static byte[] getBytesAvailable(byte[] b, int off, int len) {
        if (len + off <= b.length) {
            byte[] bytes = new byte[len];
            System.arraycopy(b, off, bytes, 0, len);
            return bytes;
        }
        byte[] bytes = new byte[b.length - off];
        System.arraycopy(b, off, bytes, 0, b.length - off);
        return bytes;
    }

    public static boolean isPrefix(byte[] b, byte[] prefix) {
        return Bytes.match(b, 0, prefix) != -1;
    }

    public static int match(byte[] b, int off, byte[] match) {
        Asserts.notNull(match, "match");
        if (b == null || b.length < match.length + off) {
            return -1;
        }
        int i = 0;
        while (i < match.length) {
            if (b[off] != match[i]) {
                return -1;
            }
            ++i;
            ++off;
        }
        return off;
    }

    public static boolean isPNG(byte[] b) {
        return b == null || b.length < 8 ? false : Bytes.isPrefix(b, _PNG_HDR_);
    }

    public static boolean isJPG(byte[] b) {
        return b == null || b.length < 4 ? false : Bytes.isPrefix(b, _JPG_HDR_);
    }

    public static boolean isGIF(byte[] b) {
        return b == null || b.length < 6 ? false : Bytes.isPrefix(b, _GIF_HDR_);
    }

    public static boolean isUTF8BOM(byte[] b) {
        return Bytes.isPrefix(b, _BOM_UTF8_);
    }

    public static boolean isUTF16BEBOM(byte[] b) {
        return Bytes.isPrefix(b, _BOM_UTF16BE_);
    }

    public static boolean isUTF16LEBOM(byte[] b) {
        return Bytes.isPrefix(b, _BOM_UTF16LE_);
    }

    public static boolean isUTF32LEBOM(byte[] b) {
        return Bytes.isPrefix(b, _BOM_UTF32LE_);
    }

    public static boolean isUTF32BEBOM(byte[] b) {
        return Bytes.isPrefix(b, _BOM_UTF32BE_);
    }

    public static final int next(byte[] b, int off, char val) {
        return Bytes.next(b, off, (byte)val);
    }

    public static final int next(byte[] b, int off, byte val) {
        int len = b.length;
        while (off < len) {
            if (b[off++] != val) continue;
            return off;
        }
        return off;
    }

    public static final int nextLF(byte[] b, int off) {
        return Bytes.next(b, off, '\n');
    }

    public static final int nextLF(byte[] b, int off, char val) {
        int len = b.length;
        while (off < len) {
            byte c;
            if ((c = b[off++]) != val && c != 10) continue;
            return off;
        }
        return off;
    }

    public static final int prev(byte[] b, int off, char val) {
        if (off >= b.length) {
            off = b.length - 1;
        }
        while (off >= 0) {
            if (b[off--] != val) continue;
            return off;
        }
        return off;
    }

    public static final int prevLF(byte[] b, int off) {
        return Bytes.prev(b, off, '\n');
    }

    public static final int prevLF(byte[] b, int off, char val) {
        if (off >= b.length) {
            off = b.length - 1;
        }
        while (off >= 0) {
            byte c;
            if ((c = b[off--]) != val && c != 10) continue;
            return off;
        }
        return off;
    }

    public static int putBOMUTF8(byte[] b, int off) {
        b[off + 0] = -17;
        b[off + 1] = -69;
        b[off + 2] = -65;
        return off + 3;
    }

    public static int putBOMUTF16LE(byte[] b, int off) {
        b[off + 0] = -1;
        b[off + 1] = -2;
        return off + 2;
    }

    public static int putBOMUTF16BE(byte[] b, int off) {
        b[off + 0] = -2;
        b[off + 1] = -1;
        return off + 2;
    }

    public static int putBOMUTF32LE(byte[] b, int off) {
        b[off + 0] = -1;
        b[off + 1] = -2;
        b[off + 2] = 0;
        b[off + 3] = 0;
        return off + 4;
    }

    public static int putBOMUTF32BE(byte[] b, int off) {
        b[off + 0] = 0;
        b[off + 1] = 0;
        b[off + 2] = -2;
        b[off + 3] = -1;
        return off + 4;
    }

    public static int putByte(byte[] b, int off, byte val) {
        b[off] = val;
        return off + 1;
    }

    public static int putByte(byte[] b, int off, int val) {
        b[off] = (byte)val;
        return off + 1;
    }

    public static int putBytes(byte[] b, int off, byte[] src) {
        if (src == null || src.length == 0) {
            return off;
        }
        System.arraycopy(src, 0, b, off, src.length);
        return off + src.length;
    }

    public static int putBytes(byte[] b, int off, byte[] src, int len) {
        if (src == null || src.length == 0) {
            return off + len;
        }
        System.arraycopy(src, 0, b, off, len);
        return off + len;
    }

    public static int putBoolean(byte[] b, int off, boolean val) {
        b[off] = (byte)(val ? 1 : 0);
        return off + 1;
    }

    public static int putChar1(byte[] b, int off, char val) {
        b[off + 0] = (byte)(val & 0xFF);
        return off + 1;
    }

    public static void putBOMUTF8(byte[] b, MInt off) {
        off.value = Bytes.putBOMUTF8(b, off.value);
    }

    public static void putBOMUTF16LE(byte[] b, MInt off) {
        off.value = Bytes.putBOMUTF16LE(b, off.value);
    }

    public static void putBOMUTF16BE(byte[] b, MInt off) {
        off.value = Bytes.putBOMUTF16BE(b, off.value);
    }

    public static void putBOMUTF32LE(byte[] b, MInt off) {
        off.value = Bytes.putBOMUTF32LE(b, off.value);
    }

    public static void putBOMUTF32BE(byte[] b, MInt off) {
        off.value = Bytes.putBOMUTF32BE(b, off.value);
    }

    public static void putBytes(byte[] b, MInt off, byte[] src) {
        if (src == null || src.length == 0) {
            return;
        }
        System.arraycopy(src, 0, b, off.value, src.length);
        off.value += src.length;
    }

    public static void putBytes(byte[] b, MInt off, byte[] src, int len) {
        if (len <= 0) {
            return;
        }
        if (src == null || src.length == 0) {
            off.value += len;
            return;
        }
        System.arraycopy(src, 0, b, off.value, len);
        off.value += len;
    }

    public static void putByte(byte[] b, MInt off, byte val) {
        b[off.value++] = val;
    }

    public static void putByte(byte[] b, MInt off, int val) {
        b[off.value++] = (byte)val;
    }

    public static void putBoolean(byte[] b, MInt off, boolean val) {
        b[off.value++] = (byte)(val ? 1 : 0);
    }

    public static void putChar1(byte[] b, MInt off, char val) {
        b[off.value++] = (byte)val;
    }

    public static int putIp4(byte[] b, int off, String value) {
        String[] strs;
        if (value == null) {
            value = "0.0.0.0";
        }
        if ((strs = value.split("\\.")) == null || strs.length != 4) {
            return off;
        }
        int i = 0;
        while (i < strs.length) {
            b[off + i] = (byte)Integer.parseInt(strs[i]);
            ++i;
        }
        return off + 4;
    }

    public static int putMac(byte[] b, int off, String value) {
        if (value == null) {
            value = "00:00:00:00:00:00:00";
        }
        byte[] val = Hexs.toBytes(value, ":");
        int i = 0;
        while (i < val.length) {
            b[off + i] = val[i];
            ++i;
        }
        return off + 6;
    }

    public static void putIp4(byte[] b, MInt off, String val) {
        off.value = Bytes.putIp4(b, off.value, val);
    }

    public static void putMac(byte[] b, MInt off, String val) {
        off.value = Bytes.putMac(b, off.value, val);
    }

    public static byte getByte(byte[] b, int off) {
        return b[off];
    }

    public static int getByteUnsigned(byte[] b, int off) {
        return b[off] & 0xFF;
    }

    public static boolean getBoolean(byte[] b, int off) {
        return b[off] != 0;
    }

    public static char getChar1(byte[] b, int off) {
        return (char)(b[off + 0] & 0xFF);
    }

    public static byte getByte(byte[] b, MInt off) {
        return b[off.value++];
    }

    public static int getByteUnsigned(byte[] b, MInt off) {
        return b[off.value++] & 0xFF;
    }

    public static boolean getBoolean(byte[] b, MInt off) {
        return b[off.value++] != 0;
    }

    public static char getChar1(byte[] b, MInt off) {
        return Bytes.getChar1(b, off.value++);
    }

    public static byte[] getBytes(byte[] b, MInt off, int len) {
        int offset = off.value;
        byte[] bytes = new byte[len];
        if (len + offset <= b.length) {
            System.arraycopy(b, offset, bytes, 0, len);
        } else {
            System.arraycopy(b, offset, bytes, 0, b.length - offset);
        }
        off.value += len;
        return bytes;
    }

    public static byte[] getBytes(byte[] b, MInt off) {
        int offset = off.value;
        byte[] bytes = new byte[b.length - offset];
        System.arraycopy(b, offset, bytes, 0, b.length - offset);
        off.value += bytes.length;
        return bytes;
    }

    public static String getIp4(byte[] b, int off) {
        StringBuilder strb = new StringBuilder();
        strb.append(b[off + 0] & 0xFF).append(".");
        strb.append(b[off + 1] & 0xFF).append(".");
        strb.append(b[off + 2] & 0xFF).append(".");
        strb.append(b[off + 3] & 0xFF);
        return strb.toString();
    }

    public static String getMac(byte[] b, int off) {
        StringBuilder strb = new StringBuilder();
        int i = 0;
        while (i < 6) {
            if (i != 0) {
                strb.append(":");
            }
            String str = Integer.toString((b[off + i] & 0xFF) + 256, 16).substring(1);
            strb.append(str);
            ++i;
        }
        return strb.toString();
    }

    public static String getIp4(byte[] b, MInt off) {
        int offset = off.value;
        off.value += 4;
        return Bytes.getIp4(b, offset);
    }

    public static String getMac(byte[] b, MInt off) {
        int offset = off.value;
        off.value += 6;
        return Bytes.getMac(b, offset);
    }
}

