/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.constants.SignConstants;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Sqls;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Types;
import org.zhiqim.kernel.util.Validates;

@AnAlias(value={"Arrays"})
public class Arrays
implements SignConstants {
    public static <T> T[] slice(T[] src, int start) {
        Asserts.notNull(src, "\u539f\u6570\u7ec4");
        int len = start < 0 ? src.length + start + 1 : src.length - start;
        Object[] dest = (Object[])Array.newInstance(src.getClass().getComponentType(), len);
        int index = 0;
        if (start < 0) {
            int i = src.length + start;
            while (i >= 0) {
                dest[index++] = src[i];
                --i;
            }
        } else {
            int i = start;
            while (i < src.length) {
                dest[index++] = src[i];
                ++i;
            }
        }
        return dest;
    }

    public static <T> T[] slice(T[] src, int start, int end) {
        Asserts.notNull(src);
        if (start < 0 && end >= 0) {
            end -= src.length;
        }
        if (start >= 0 && end < 0) {
            end += src.length;
        }
        int len = start < 0 ? start - end : end - start;
        Object[] dest = (Object[])Array.newInstance(src.getClass().getComponentType(), len);
        int index = 0;
        if (start < 0) {
            int i = src.length - start;
            while (i > end) {
                dest[index++] = src[i];
                --i;
            }
        } else {
            int i = start;
            while (i < end) {
                dest[index++] = src[i];
                ++i;
            }
        }
        return dest;
    }

    public static int indexOf(Object[] objs, Object obj) {
        if (objs == null) {
            return -1;
        }
        if (obj == null) {
            int i = 0;
            while (i < objs.length) {
                if (objs[i] == null) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < objs.length) {
                if (obj.equals(objs[i])) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static int length(Object obj) {
        if (!Types.isArray(obj)) {
            return 0;
        }
        if (Types.isIntArray(obj)) {
            return ((int[])obj).length;
        }
        if (Types.isLongArray(obj)) {
            return ((long[])obj).length;
        }
        if (Types.isBooleanArray(obj)) {
            return ((boolean[])obj).length;
        }
        if (Types.isByteArray(obj)) {
            return ((byte[])obj).length;
        }
        if (Types.isCharArray(obj)) {
            return ((char[])obj).length;
        }
        if (Types.isShortArray(obj)) {
            return ((short[])obj).length;
        }
        if (Types.isFloatArray(obj)) {
            return ((float[])obj).length;
        }
        if (Types.isDoubleArray(obj)) {
            return ((double[])obj).length;
        }
        return ((Object[])obj).length;
    }

    public static boolean isEmpty(Object obj) {
        return Arrays.length(obj) == 0;
    }

    public static Object[] toArray(Object obj) {
        Asserts.as(Types.isArray(obj) ? null : "\u4f20\u5165\u7684\u53c2\u6570\u4e0d\u662f\u6570\u7ec4\u7c7b\u578b");
        if (Types.isIntArray(obj)) {
            int[] os = (int[])obj;
            Object[] arr = new Integer[os.length];
            int i = 0;
            while (i < os.length) {
                arr[i] = os[i];
                ++i;
            }
            return arr;
        }
        if (Types.isLongArray(obj)) {
            long[] os = (long[])obj;
            Object[] arr = new Long[os.length];
            int i = 0;
            while (i < os.length) {
                arr[i] = os[i];
                ++i;
            }
            return arr;
        }
        if (Types.isBooleanArray(obj)) {
            boolean[] os = (boolean[])obj;
            Object[] arr = new Boolean[os.length];
            int i = 0;
            while (i < os.length) {
                arr[i] = os[i];
                ++i;
            }
            return arr;
        }
        if (Types.isByteArray(obj)) {
            byte[] os = (byte[])obj;
            Object[] arr = new Byte[os.length];
            int i = 0;
            while (i < os.length) {
                arr[i] = os[i];
                ++i;
            }
            return arr;
        }
        if (Types.isCharArray(obj)) {
            char[] os = (char[])obj;
            Object[] arr = new Character[os.length];
            int i = 0;
            while (i < os.length) {
                arr[i] = Character.valueOf(os[i]);
                ++i;
            }
            return arr;
        }
        if (Types.isShortArray(obj)) {
            short[] os = (short[])obj;
            Object[] arr = new Short[os.length];
            int i = 0;
            while (i < os.length) {
                arr[i] = os[i];
                ++i;
            }
            return arr;
        }
        if (Types.isFloatArray(obj)) {
            float[] os = (float[])obj;
            Object[] arr = new Float[os.length];
            int i = 0;
            while (i < os.length) {
                arr[i] = Float.valueOf(os[i]);
                ++i;
            }
            return arr;
        }
        if (Types.isDoubleArray(obj)) {
            double[] os = (double[])obj;
            Object[] arr = new Double[os.length];
            int i = 0;
            while (i < os.length) {
                arr[i] = os[i];
                ++i;
            }
            return arr;
        }
        return (Object[])obj;
    }

    public static <T> T[] toArray(List<T> list, Class<T> clazz) {
        if (list == null) {
            return null;
        }
        clazz = Types.toObjectClass(clazz);
        return list.toArray((Object[])Array.newInstance(clazz, 0));
    }

    public static int[] toArrayInt(List<Integer> list) {
        if (list == null) {
            return new int[0];
        }
        return Arrays.convert(list.toArray(new Integer[0]));
    }

    public static long[] toArrayLong(List<Long> list) {
        if (list == null) {
            return new long[0];
        }
        return Arrays.convert(list.toArray(new Long[0]));
    }

    public static byte[] toArrayByte(List<Byte> list) {
        if (list == null) {
            return new byte[0];
        }
        return Arrays.convert(list.toArray(new Byte[0]));
    }

    public static short[] toArrayShort(List<Short> list) {
        if (list == null) {
            return new short[0];
        }
        return Arrays.convert(list.toArray(new Short[0]));
    }

    public static boolean[] toArrayBoolean(List<Boolean> list) {
        if (list == null) {
            return new boolean[0];
        }
        return Arrays.convert(list.toArray(new Boolean[0]));
    }

    public static char[] toArrayChar(List<Character> list) {
        if (list == null) {
            return new char[0];
        }
        return Arrays.convert(list.toArray(new Character[0]));
    }

    public static float[] toArrayFloat(List<Float> list) {
        if (list == null) {
            return new float[0];
        }
        return Arrays.convert(list.toArray(new Float[0]));
    }

    public static double[] toArrayDouble(List<Double> list) {
        if (list == null) {
            return new double[0];
        }
        return Arrays.convert(list.toArray(new Double[0]));
    }

    public static boolean[] convert(Boolean[] values) {
        if (values == null) {
            return null;
        }
        boolean[] results = new boolean[values.length];
        int i = 0;
        while (i < values.length) {
            results[i] = values[i];
            ++i;
        }
        return results;
    }

    public static Boolean[] convert(boolean[] values) {
        if (values == null) {
            return null;
        }
        Boolean[] results = new Boolean[values.length];
        int i = 0;
        while (i < values.length) {
            results[i] = values[i];
            ++i;
        }
        return results;
    }

    public static byte[] convert(Byte[] values) {
        if (values == null) {
            return null;
        }
        byte[] results = new byte[values.length];
        int i = 0;
        while (i < values.length) {
            results[i] = values[i];
            ++i;
        }
        return results;
    }

    public static Byte[] convert(byte[] values) {
        if (values == null) {
            return null;
        }
        Byte[] results = new Byte[values.length];
        int i = 0;
        while (i < values.length) {
            results[i] = values[i];
            ++i;
        }
        return results;
    }

    public static char[] convert(Character[] values) {
        if (values == null) {
            return null;
        }
        char[] results = new char[values.length];
        int i = 0;
        while (i < values.length) {
            results[i] = values[i].charValue();
            ++i;
        }
        return results;
    }

    public static Character[] convert(char[] values) {
        if (values == null) {
            return null;
        }
        Character[] results = new Character[values.length];
        int i = 0;
        while (i < values.length) {
            results[i] = Character.valueOf(values[i]);
            ++i;
        }
        return results;
    }

    public static short[] convert(Short[] values) {
        if (values == null) {
            return null;
        }
        short[] results = new short[values.length];
        int i = 0;
        while (i < values.length) {
            results[i] = values[i];
            ++i;
        }
        return results;
    }

    public static Short[] convert(short[] values) {
        if (values == null) {
            return null;
        }
        Short[] results = new Short[values.length];
        int i = 0;
        while (i < values.length) {
            results[i] = values[i];
            ++i;
        }
        return results;
    }

    public static int[] convert(Integer[] values) {
        if (values == null) {
            return null;
        }
        int[] results = new int[values.length];
        int i = 0;
        while (i < values.length) {
            results[i] = values[i];
            ++i;
        }
        return results;
    }

    public static Integer[] convert(int[] values) {
        if (values == null) {
            return null;
        }
        Integer[] results = new Integer[values.length];
        int i = 0;
        while (i < values.length) {
            results[i] = values[i];
            ++i;
        }
        return results;
    }

    public static long[] convert(Long[] values) {
        if (values == null) {
            return null;
        }
        long[] results = new long[values.length];
        int i = 0;
        while (i < values.length) {
            results[i] = values[i];
            ++i;
        }
        return results;
    }

    public static Long[] convert(long[] values) {
        if (values == null) {
            return null;
        }
        Long[] results = new Long[values.length];
        int i = 0;
        while (i < values.length) {
            results[i] = values[i];
            ++i;
        }
        return results;
    }

    public static float[] convert(Float[] values) {
        if (values == null) {
            return null;
        }
        float[] results = new float[values.length];
        int i = 0;
        while (i < values.length) {
            results[i] = values[i].floatValue();
            ++i;
        }
        return results;
    }

    public static Float[] convert(float[] values) {
        if (values == null) {
            return null;
        }
        Float[] results = new Float[values.length];
        int i = 0;
        while (i < values.length) {
            results[i] = Float.valueOf(values[i]);
            ++i;
        }
        return results;
    }

    public static double[] convert(Double[] values) {
        if (values == null) {
            return null;
        }
        double[] results = new double[values.length];
        int i = 0;
        while (i < values.length) {
            results[i] = values[i];
            ++i;
        }
        return results;
    }

    public static Double[] convert(double[] values) {
        if (values == null) {
            return null;
        }
        Double[] results = new Double[values.length];
        int i = 0;
        while (i < values.length) {
            results[i] = values[i];
            ++i;
        }
        return results;
    }

    public static String[] toStringArray(String strs, String separator) {
        if (Validates.isEmpty(strs)) {
            return new String[0];
        }
        String[] values = strs.split(separator);
        int i = 0;
        while (i < values.length) {
            values[i] = Strings.trim(values[i]);
            ++i;
        }
        return values;
    }

    public static String[] toStringArray(String strs) {
        return Arrays.toStringArray(strs, ",");
    }

    public static String[] toStringArray(Object[] objs) {
        if (objs == null) {
            return new String[0];
        }
        String[] strs = new String[objs.length];
        int i = 0;
        while (i < objs.length) {
            strs[i] = objs[i] == null ? null : Strings.trim(String.valueOf(objs[i]));
            ++i;
        }
        return strs;
    }

    public static boolean[] toBooleanArray(String strs) {
        String[] values = Arrays.toStringArray(strs, ",");
        return Arrays.toBooleanArray(values);
    }

    public static boolean[] toBooleanArray(String strs, String separator) {
        String[] values = Arrays.toStringArray(strs, separator);
        return Arrays.toBooleanArray(values);
    }

    public static boolean[] toBooleanArray(String[] values) {
        boolean[] results = new boolean[values.length];
        int i = 0;
        while (i < values.length) {
            results[i] = "true".equals(Strings.trim(values[i]));
            ++i;
        }
        return results;
    }

    public static boolean[] toBooleanArrayForm(String strs, String separator) {
        String[] values = Arrays.toStringArray(strs, separator);
        boolean[] results = new boolean[values.length];
        int i = 0;
        while (i < values.length) {
            results[i] = "true".equals(Strings.trim(values[i])) || "1".equals(Strings.trim(values[i]));
            ++i;
        }
        return results;
    }

    public static short[] toShortArray(String strs) {
        String[] values = Arrays.toStringArray(strs, ",");
        return Arrays.toShortArray(values);
    }

    public static short[] toShortArray(String strs, String separator) {
        String[] values = Arrays.toStringArray(strs, separator);
        return Arrays.toShortArray(values);
    }

    public static short[] toShortArray(String[] values) {
        short[] results = new short[values.length];
        int i = 0;
        while (i < values.length) {
            results[i] = Short.parseShort(Strings.trim(values[i]));
            ++i;
        }
        return results;
    }

    public static int[] toIntArray(String strs) {
        String[] values = Arrays.toStringArray(strs, ",");
        return Arrays.toIntArray(values);
    }

    public static int[] toIntArray(String strs, String separator) {
        String[] values = Arrays.toStringArray(strs, separator);
        return Arrays.toIntArray(values);
    }

    public static int[] toIntArray(String[] values) {
        int[] results = new int[values.length];
        int i = 0;
        while (i < values.length) {
            results[i] = Integer.parseInt(Strings.trim(values[i]));
            ++i;
        }
        return results;
    }

    public static long[] toLongArray(String strs) {
        String[] values = Arrays.toStringArray(strs, ",");
        return Arrays.toLongArray(values);
    }

    public static long[] toLongArray(String strs, String separator) {
        String[] values = Arrays.toStringArray(strs, separator);
        return Arrays.toLongArray(values);
    }

    public static long[] toLongArray(String[] values) {
        long[] results = new long[values.length];
        int i = 0;
        while (i < values.length) {
            results[i] = Long.parseLong(Strings.trim(values[i]));
            ++i;
        }
        return results;
    }

    public static float[] toFloatArray(String strs) {
        String[] values = Arrays.toStringArray(strs, ",");
        return Arrays.toFloatArray(values);
    }

    public static float[] toFloatArray(String strs, String separator) {
        String[] values = Arrays.toStringArray(strs, separator);
        return Arrays.toFloatArray(values);
    }

    public static float[] toFloatArray(String[] values) {
        float[] results = new float[values.length];
        int i = 0;
        while (i < values.length) {
            results[i] = Float.parseFloat(Strings.trim(values[i]));
            ++i;
        }
        return results;
    }

    public static double[] toDoubleArray(String strs) {
        String[] values = Arrays.toStringArray(strs, ",");
        return Arrays.toDoubleArray(values);
    }

    public static double[] toDoubleArray(String strs, String separator) {
        String[] values = Arrays.toStringArray(strs, separator);
        return Arrays.toDoubleArray(values);
    }

    public static double[] toDoubleArray(String[] values) {
        double[] results = new double[values.length];
        int i = 0;
        while (i < values.length) {
            results[i] = Double.parseDouble(Strings.trim(values[i]));
            ++i;
        }
        return results;
    }

    public static String toString(String[] values, String separator) {
        if (values == null || values.length == 0) {
            return "";
        }
        StringBuilder strb = new StringBuilder(values[0]);
        int i = 1;
        while (i < values.length) {
            strb.append(separator).append(values[i]);
            ++i;
        }
        return strb.toString();
    }

    public static String toString(String[] values) {
        return Arrays.toString(values, ",");
    }

    public static String toString(boolean[] values, String separator) {
        if (values == null || values.length == 0) {
            return "";
        }
        StringBuilder strb = new StringBuilder().append(values[0]);
        int i = 1;
        while (i < values.length) {
            strb.append(separator).append(values[i]);
            ++i;
        }
        return strb.toString();
    }

    public static String toString(boolean[] values) {
        return Arrays.toString(values, ",");
    }

    public static String toString(short[] values, String separator) {
        if (values == null || values.length == 0) {
            return "";
        }
        StringBuilder strb = new StringBuilder().append(values[0]);
        int i = 1;
        while (i < values.length) {
            strb.append(separator).append(values[i]);
            ++i;
        }
        return strb.toString();
    }

    public static String toString(short[] values) {
        return Arrays.toString(values, ",");
    }

    public static String toString(int[] values, String separator) {
        if (values == null || values.length == 0) {
            return "";
        }
        StringBuilder strb = new StringBuilder().append(values[0]);
        int i = 1;
        while (i < values.length) {
            strb.append(separator).append(values[i]);
            ++i;
        }
        return strb.toString();
    }

    public static String toString(int[] values) {
        return Arrays.toString(values, ",");
    }

    public static String toString(long[] values, String separator) {
        if (values == null || values.length == 0) {
            return "";
        }
        StringBuilder strb = new StringBuilder().append(values[0]);
        int i = 1;
        while (i < values.length) {
            strb.append(separator).append(values[i]);
            ++i;
        }
        return strb.toString();
    }

    public static String toString(long[] values) {
        return Arrays.toString(values, ",");
    }

    public static String toString(float[] values, String separator) {
        if (values == null || values.length == 0) {
            return "";
        }
        StringBuilder strb = new StringBuilder().append(values[0]);
        int i = 1;
        while (i < values.length) {
            strb.append(separator).append(values[i]);
            ++i;
        }
        return strb.toString();
    }

    public static String toString(float[] values) {
        return Arrays.toString(values, ",");
    }

    public static String toString(double[] values, String separator) {
        if (values == null || values.length == 0) {
            return "";
        }
        StringBuilder strb = new StringBuilder().append(values[0]);
        int i = 1;
        while (i < values.length) {
            strb.append(separator).append(values[i]);
            ++i;
        }
        return strb.toString();
    }

    public static String toString(double[] values) {
        return Arrays.toString(values, ",");
    }

    public static String toStringSql(String[] values, String separator) {
        if (values == null || values.length == 0) {
            return "";
        }
        String[] strSqlArr = new String[values.length];
        int i = 0;
        while (i < values.length) {
            strSqlArr[i] = Sqls.formatQuote(values[i]);
            ++i;
        }
        StringBuilder strb = new StringBuilder();
        strb.append("'").append(strSqlArr[0]).append("'");
        int i2 = 1;
        while (i2 < values.length) {
            strb.append(separator).append("'").append(values[i2]).append("'");
            ++i2;
        }
        return strb.toString();
    }

    public static String[] toFilterSame(String[] values) {
        HashSet<String> strSet = Arrays.toFilterSameSet(values);
        if (strSet.isEmpty()) {
            return new String[0];
        }
        String[] dStrArr = new String[strSet.size()];
        int i = 0;
        for (String str : strSet) {
            dStrArr[i++] = str;
        }
        return dStrArr;
    }

    public static String toFilterSameStr(String strs) {
        return Arrays.toFilterSameStr(Arrays.toStringArray(strs, ","), ",");
    }

    public static String toFilterSameStr(String strs, String separator) {
        return Arrays.toFilterSameStr(Arrays.toStringArray(strs, separator), separator);
    }

    public static String toFilterSameStr(String[] values, String separator) {
        List<String> strList = Arrays.toFilterSameList(values);
        if (strList.isEmpty()) {
            return "";
        }
        StringBuilder strb = new StringBuilder().append(strList.get(0));
        int i = 1;
        while (i < strList.size()) {
            strb.append(separator).append(strList.get(i));
            ++i;
        }
        return strb.toString();
    }

    public static String toFilterSameStr(String[] values) {
        return Arrays.toFilterSameStr(values, ",");
    }

    public static HashSet<String> toFilterSameSet(String[] values) {
        if (values == null || values.length == 0) {
            return new HashSet<String>(0);
        }
        HashSet<String> strSet = new HashSet<String>();
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            strSet.add(Strings.trim(str));
            ++n2;
        }
        return strSet;
    }

    public static String[] toFilterSameList(List<String> values) {
        if (values == null || values.isEmpty()) {
            return new String[0];
        }
        LinkedHashSet<String> strSet = new LinkedHashSet<String>(values.size());
        for (String str : values) {
            strSet.add(Strings.trim(str));
        }
        return strSet.toArray(new String[0]);
    }

    public static List<String> toFilterSameList(String[] values) {
        if (values == null || values.length == 0) {
            return new ArrayList<String>();
        }
        ArrayList<String> strList = new ArrayList<String>();
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (!strList.contains(str = Strings.trim(str))) {
                strList.add(str);
            }
            ++n2;
        }
        return strList;
    }
}

