/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.paging;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.paging.PageBuilder;
import org.zhiqim.kernel.paging.PageResult;
import org.zhiqim.kernel.util.Validates;

@AnAlias(value={"Pagings"})
public class Pagings {
    public static String toHtmlLinkAll5(PageResult<?> result, String link) {
        return Pagings.toHtmlLink(result, link, true, true, true, true, true, true, true, true, 5, false);
    }

    public static String toHtmlLinkAll10(PageResult<?> result, String link) {
        return Pagings.toHtmlLink(result, link, true, true, true, true, true, true, true, true, 10, false);
    }

    public static String toHtmlLinkAllDiv5(PageResult<?> result, String link) {
        return Pagings.toHtmlLink(result, link, true, true, true, true, true, true, true, true, 5, true);
    }

    public static String toHtmlLinkAllDiv10(PageResult<?> result, String link) {
        return Pagings.toHtmlLink(result, link, true, true, true, true, true, true, true, true, 10, true);
    }

    public static String toHtmlLinkSeg5(PageResult<?> result, String link) {
        return Pagings.toHtmlLink(result, link, false, false, false, false, false, false, false, false, 5, false);
    }

    public static String toHtmlLinkSeg10(PageResult<?> result, String link) {
        return Pagings.toHtmlLink(result, link, false, false, false, false, false, false, false, false, 10, false);
    }

    public static String toHtmlLinkSegDiv5(PageResult<?> result, String link) {
        return Pagings.toHtmlLink(result, link, false, false, false, false, false, false, false, false, 5, true);
    }

    public static String toHtmlLinkSegDiv10(PageResult<?> result, String link) {
        return Pagings.toHtmlLink(result, link, false, false, false, false, false, false, false, false, 10, true);
    }

    public static String toHtmlLinkPN(PageResult<?> result, String link) {
        return Pagings.toHtmlLink(result, link, false, false, false, false, false, true, true, false, 0, false);
    }

    public static String toHtmlLink(PageResult<?> result, String link, boolean isTotal, boolean isPageSize, boolean isTotalPages, boolean isPageNo, boolean isFirst, boolean isPrevious, boolean isNext, boolean isLast, int segmentSize, boolean isDiv) {
        if (result == null) {
            result = PageBuilder.newResult(20);
        }
        String absLink = String.valueOf(link) + result.getConditionUrl();
        absLink = Validates.isNotEmpty(result.getConditionUrl()) ? String.valueOf(absLink) + "&" : String.valueOf(absLink) + "?";
        StringBuilder strb = new StringBuilder();
        if (isTotal) {
            strb.append("\u5171<font color=\"red\">" + result.total() + "</font>\u6761&nbsp;");
        }
        if (isPageSize) {
            strb.append("\u6bcf\u9875<font color=\"red\">" + result.pageSize() + "</font>\u6761&nbsp;");
        }
        if (isTotalPages) {
            strb.append("\u5171<font color=\"red\">" + result.totalPages() + "</font>\u9875&nbsp;");
        }
        if (isPageNo) {
            strb.append("\u5f53\u524d\u7b2c<font color=\"red\">" + result.pageNo() + "</font>\u9875&nbsp;");
        }
        if (isFirst) {
            if (result.hasFirst()) {
                strb.append("<a href=\"" + absLink + "page=1\">\u9996\u9875</a>&nbsp;");
            } else {
                strb.append("\u9996\u9875&nbsp;");
            }
        }
        if (isPrevious) {
            if (result.hasPrevious()) {
                strb.append("<a href=\"" + absLink + "page=" + (result.pageNo() - 1) + "\">\u4e0a\u4e00\u9875</a>&nbsp;");
            } else {
                strb.append("\u4e0a\u4e00\u9875&nbsp;");
            }
        }
        if (isNext) {
            if (result.hasNext()) {
                strb.append("<a href=\"" + absLink + "page=" + (result.pageNo() + 1) + "\">\u4e0b\u4e00\u9875</a>&nbsp;");
            } else {
                strb.append("\u4e0b\u4e00\u9875&nbsp;");
            }
        }
        if (isLast) {
            if (result.hasLast()) {
                strb.append("<a href=\"" + absLink + "page=" + result.totalPages() + "\">\u672b\u9875</a>&nbsp;");
            } else {
                strb.append("\u672b\u9875&nbsp;");
            }
        }
        if (segmentSize > 0) {
            int lBound = result.getLSegmentNo(segmentSize);
            int rBound = result.getRSegmentNo(segmentSize);
            if (isDiv) {
                strb.append("<div style=\"float:right;height:20px;line-height:20px;min-width:20px;white-space:nowrap;\">");
                if (result.hasLSegment(segmentSize)) {
                    strb.append("<a href=\"" + absLink + "page=" + (lBound - 1) + "\"><div style='float:left;height:20px;line-height:20px;width:20px;border:1px solid #D3D3D3;text-align:center;cursor:pointer;'><<</div></a>");
                }
                int i = lBound;
                while (i < rBound) {
                    if (result.pageNo() != i) {
                        strb.append("<a href=\"" + absLink + "page=" + i + "\"><div style='float:left;height:20px;line-height:20px;min-width:20px;white-space:nowrap;border:1px solid #D3D3D3;text-align:center;margin-left:5px;cursor:pointer;'>" + i + "</div></a>");
                    } else {
                        strb.append("<div style='float:left;height:20px;line-height:20px;width:20px;color:#993333;background-color:#F2D2D2;border:1px solid #f9631f;text-align:center;margin-left:5px;cursor:pointer;'>" + i + "</div>");
                    }
                    ++i;
                }
                if (result.hasRSegment(segmentSize)) {
                    strb.append("<a href=\"" + absLink + "page=" + rBound + "\"><div style='float:left;height:20px;line-height:20px;width:20px;border:1px solid #D3D3D3;text-align:center;margin-left:5px;cursor:pointer;'>>></div></a>&nbsp;");
                }
                strb.append("</div>");
            } else {
                strb.append("\u9875\u7801:");
                if (result.hasLSegment(segmentSize)) {
                    strb.append("<a href=\"" + absLink + "page=" + (lBound - 1) + "\"><<<</a>&nbsp;");
                }
                int i = lBound;
                while (i < rBound) {
                    strb.append("<a href=\"" + absLink + "page=" + i + "\">" + i + "</a>&nbsp;");
                    ++i;
                }
                if (result.hasRSegment(segmentSize)) {
                    strb.append("<a href=\"" + absLink + "page=" + rBound + "\">>>></a>&nbsp;");
                }
            }
        }
        return strb.toString();
    }

    public static String toHtmlClickAll5(PageResult<?> result, String jsMethod) {
        return Pagings.toHtmlClick(result, jsMethod, true, true, true, true, true, true, true, true, 5, false);
    }

    public static String toHtmlClickAll10(PageResult<?> result, String jsMethod) {
        return Pagings.toHtmlClick(result, jsMethod, true, true, true, true, true, true, true, true, 10, false);
    }

    public static String toHtmlClickSeg5(PageResult<?> result, String jsMethod) {
        return Pagings.toHtmlClick(result, jsMethod, false, false, false, false, false, false, false, false, 5, false);
    }

    public static String toHtmlClickSeg10(PageResult<?> result, String jsMethod) {
        return Pagings.toHtmlClick(result, jsMethod, false, false, false, false, false, false, false, false, 10, false);
    }

    public static String toHtmlClickAllDiv5(PageResult<?> result, String jsMethod) {
        return Pagings.toHtmlClick(result, jsMethod, true, true, true, true, true, true, true, true, 5, true);
    }

    public static String toHtmlClickAllDiv10(PageResult<?> result, String jsMethod) {
        return Pagings.toHtmlClick(result, jsMethod, true, true, true, true, true, true, true, true, 10, true);
    }

    public static String toHtmlClickSegDiv5(PageResult<?> result, String jsMethod) {
        return Pagings.toHtmlClick(result, jsMethod, false, false, false, false, false, false, false, false, 5, true);
    }

    public static String toHtmlClickSegDiv10(PageResult<?> result, String jsMethod) {
        return Pagings.toHtmlClick(result, jsMethod, false, false, false, false, false, false, false, false, 10, true);
    }

    public static String toHtmlClickPN(PageResult<?> result, String jsMethod) {
        return Pagings.toHtmlClick(result, jsMethod, false, false, false, false, false, true, true, false, 0, false);
    }

    public static String toHtmlClick(PageResult<?> result, String jsMethod, boolean isTotal, boolean isPageSize, boolean isTotalPages, boolean isPageNo, boolean isFirst, boolean isPrevious, boolean isNext, boolean isLast, int segmentSize, boolean isDiv) {
        if (result == null) {
            result = PageBuilder.newResult(20);
        }
        StringBuilder strb = new StringBuilder();
        if (isTotal) {
            strb.append("\u5171<font color=\"red\">" + result.total() + "</font>\u6761&nbsp;");
        }
        if (isPageSize) {
            strb.append("\u6bcf\u9875<font color=\"red\">" + result.pageSize() + "</font>\u6761&nbsp;");
        }
        if (isTotalPages) {
            strb.append("\u5171<font color=\"red\">" + result.totalPages() + "</font>\u9875&nbsp;");
        }
        if (isPageNo) {
            strb.append("\u5f53\u524d\u7b2c<font color=\"red\">" + result.pageNo() + "</font>\u9875&nbsp;");
        }
        if (isFirst) {
            if (result.hasFirst()) {
                strb.append("<a href=\"javascript:void(0);\" onclick=\"" + jsMethod + "('1');\">\u9996\u9875</a>&nbsp;");
            } else {
                strb.append("\u9996\u9875&nbsp;");
            }
        }
        if (isPrevious) {
            if (result.hasPrevious()) {
                strb.append("<a href=\"javascript:void(0);\" onclick=\"" + jsMethod + "('" + (result.pageNo() - 1) + "');\">\u4e0a\u4e00\u9875</a>&nbsp;");
            } else {
                strb.append("\u4e0a\u4e00\u9875&nbsp;");
            }
        }
        if (isNext) {
            if (result.hasNext()) {
                strb.append("<a href=\"javascript:void(0);\" onclick=\"" + jsMethod + "('" + (result.pageNo() + 1) + "');\">\u4e0b\u4e00\u9875</a>&nbsp;");
            } else {
                strb.append("\u4e0b\u4e00\u9875&nbsp;");
            }
        }
        if (isLast) {
            if (result.hasLast()) {
                strb.append("<a href=\"javascript:void(0);\" onclick=\"" + jsMethod + "('" + result.totalPages() + "');\">\u672b\u9875</a>&nbsp;");
            } else {
                strb.append("\u672b\u9875&nbsp;");
            }
        }
        if (segmentSize > 0) {
            int lBound = result.getLSegmentNo(segmentSize);
            int rBound = result.getRSegmentNo(segmentSize);
            if (isDiv) {
                strb.append("<div style=\"float:right;height:20px;line-height:20px;min-width:20px;white-space:nowrap;\">");
                if (result.hasLSegment(segmentSize)) {
                    strb.append("<a href=\"javascript:void(0);\" onclick=\"" + jsMethod + "('" + (lBound - 1) + "');\"><div style='float:left;height:20px;line-height:20px;width:20px;border:1px solid #D3D3D3;text-align:center;cursor:pointer;'><<</div></a>");
                }
                int i = lBound;
                while (i < rBound) {
                    if (result.pageNo() != i) {
                        strb.append("<a href=\"javascript:void(0);\" onclick=\"" + jsMethod + "('" + i + "');\"><div style='float:left;height:20px;line-height:20px;min-width:20px;white-space:nowrap;border:1px solid #D3D3D3;text-align:center;margin-left:5px;cursor:pointer;'>" + i + "</div></a>");
                    } else {
                        strb.append("<div style='float:left;height:20px;line-height:20px;width:20px;color:#993333;background-color:#F2D2D2;border:1px solid #f9631f;text-align:center;margin-left:5px;cursor:pointer;'>" + i + "</div>");
                    }
                    ++i;
                }
                if (result.hasRSegment(segmentSize)) {
                    strb.append("<a href=\"javascript:void(0);\" onclick=\"" + jsMethod + "('" + rBound + "');\"><div style='float:left;height:20px;line-height:20px;width:20px;border:1px solid #D3D3D3;text-align:center;margin-left:5px;cursor:pointer;'>>></div></a>&nbsp;");
                }
                strb.append("</div>");
            } else {
                strb.append("\u9875\u7801:");
                if (result.hasLSegment(segmentSize)) {
                    strb.append("<a href=\"javascript:void(0);\" oonclick=\"" + jsMethod + "('" + (lBound - 1) + "');\"><<<</a>&nbsp;");
                }
                int i = lBound;
                while (i < rBound) {
                    strb.append("<a href=\"javascript:void(0);\" onclick=\"" + jsMethod + "('" + i + "');\">" + i + "</a>&nbsp;");
                    ++i;
                }
                if (result.hasRSegment(segmentSize)) {
                    strb.append("<a href=\"javascript:void(0);\" onclick=\"" + jsMethod + "('" + rBound + "');\">>>></a>&nbsp;");
                }
            }
        }
        return strb.toString();
    }
}

