/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.paging;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.annotation.AnGlobal;
import org.zhiqim.kernel.paging.PageBuilder;
import org.zhiqim.kernel.paging.PageResult;
import org.zhiqim.kernel.paging.Paging;
import org.zhiqim.kernel.util.Validates;

@AnAlias(value={"PagingUD"})
@AnGlobal
public class PagingUD
implements Paging {
    @Override
    public String toHtmlLink(PageResult<?> result) {
        return this.toHtmlLink(result, null);
    }

    @Override
    public String toHtmlLink(PageResult<?> result, String link) {
        String condition;
        if (result == null) {
            result = PageBuilder.newResult(20);
        }
        if (link == null) {
            link = "";
        }
        link = Validates.isNotEmpty(condition = result.getConditionUrl()) ? String.valueOf(link) + condition + "&" : String.valueOf(link) + "?";
        StringBuilder strb = new StringBuilder();
        strb.append("<div class=\"z-relative-center z-text-center\">");
        if (result.hasPrevious()) {
            strb.append("<span class=\"z-button z-mg-r3\" onclick=\"location.href='" + link + "page=" + (result.pageNo() - 1) + "'\">\u4e0a\u4e00\u9875</span>");
        } else {
            strb.append("<span class=\"z-button z-mg-r3 z-readonly\">\u4e0a\u4e00\u9875</span>");
        }
        if (result.hasNext()) {
            strb.append("<span class=\"z-button z-mg-r3\" onclick=\"location.href='" + link + "page=" + (result.pageNo() + 1) + "'\">\u4e0b\u4e00\u9875</span>");
        } else {
            strb.append("<span class=\"z-button z-mg-r3 z-readonly\">\u4e0b\u4e00\u9875</span>");
        }
        strb.append("</div>");
        return strb.toString();
    }

    @Override
    public String toHtmlClick(PageResult<?> result, String jsMethod) {
        if (result == null) {
            result = PageBuilder.newResult(20);
        }
        StringBuilder strb = new StringBuilder();
        strb.append("<div class=\"z-relative-center z-text-center\">");
        if (result.hasPrevious()) {
            strb.append("<span class=\"z-button z-mg-r3\" onclick=\"" + jsMethod + "('" + (result.pageNo() - 1) + "');\">\u4e0a\u4e00\u9875</span>");
        } else {
            strb.append("<span class=\"z-button z-mg-r3 z-readonly\">\u4e0a\u4e00\u9875</span>");
        }
        if (result.hasNext()) {
            strb.append("<span class=\"z-button z-mg-r3\" onclick=\"" + jsMethod + "('" + (result.pageNo() + 1) + "');\">\u4e0b\u4e00\u9875</span>");
        } else {
            strb.append("<span class=\"z-button z-mg-r3 z-readonly\">\u4e0b\u4e00\u9875</span>");
        }
        strb.append("</div>");
        return strb.toString();
    }
}

