/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.paging;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.annotation.AnGlobal;
import org.zhiqim.kernel.constants.SignConstants;
import org.zhiqim.kernel.paging.PageBuilder;
import org.zhiqim.kernel.paging.PageResult;
import org.zhiqim.kernel.paging.Paging;
import org.zhiqim.kernel.util.Validates;

@AnAlias(value={"PagingStd"})
@AnGlobal
public class PagingStd
implements Paging,
SignConstants {
    @Override
    public String toHtmlLink(PageResult<?> result) {
        return this.toHtmlLink(result, null);
    }

    @Override
    public String toHtmlLink(PageResult<?> result, String link) {
        String condition;
        if (result == null) {
            result = PageBuilder.newResult(20);
        }
        if (link == null) {
            link = "";
        }
        link = Validates.isNotEmpty(condition = result.getConditionUrl()) ? String.valueOf(link) + condition + "&" : String.valueOf(link) + "?";
        StringBuilder strb = new StringBuilder();
        strb.append("<div class=\"z-relative-center z-text-center\">");
        strb.append("<span class=\"z-button z-mg-r5 z-readonly\">\u603b&nbsp;<span class=\"z-bold z-text-red\">").append(result.total()).append("</span>&nbsp;\u6761</span>");
        if (result.hasFirst()) {
            strb.append("<span class=\"z-button z-mg-r3\" onclick=\"location.href='" + link + "page=1'\">\u9996\u9875</span>");
        } else {
            strb.append("<span class=\"z-button z-mg-r3 z-readonly\">\u9996\u9875</span>");
        }
        if (result.hasPrevious()) {
            strb.append("<span class=\"z-button z-mg-r3\" onclick=\"location.href='" + link + "page=" + (result.pageNo() - 1) + "'\">\u4e0a\u4e00\u9875</span>");
        } else {
            strb.append("<span class=\"z-button z-mg-r3 z-readonly\">\u4e0a\u4e00\u9875</span>");
        }
        int lBound = result.getLSegmentNo(5);
        int rBound = result.getRSegmentNo(5);
        if (result.hasLSegment(5)) {
            strb.append("<span class=\"z-button z-mg-r3\" onclick=\"location.href='" + link + "page=" + (lBound - 1) + "'\"><<</span>");
        }
        int i = lBound;
        while (i < rBound) {
            if (result.pageNo() != i) {
                strb.append("<span class=\"z-button z-mg-r3\" onclick=\"location.href='" + link + "page=" + i + "'\">" + i + "</span>");
            } else {
                strb.append("<span class=\"z-button z-mg-r3 z-red\" onclick=\"location.href='" + link + "page=" + i + "'\">" + i + "</span>");
            }
            ++i;
        }
        if (result.hasRSegment(5)) {
            strb.append("<span class=\"z-button z-mg-r3\" onclick=\"location.href='" + link + "page=" + rBound + "'\">>></span>");
        }
        if (result.hasNext()) {
            strb.append("<span class=\"z-button z-mg-r3\" onclick=\"location.href='" + link + "page=" + (result.pageNo() + 1) + "'\">\u4e0b\u4e00\u9875</span>");
        } else {
            strb.append("<span class=\"z-button z-mg-r3 z-readonly\">\u4e0b\u4e00\u9875</span>");
        }
        if (result.hasLast()) {
            strb.append("<span class=\"z-button\" onclick=\"location.href='" + link + "page=" + result.totalPages() + "'\">\u672b\u9875</span>");
        } else {
            strb.append("<span class=\"z-button z-readonly\">\u672b\u9875</span>");
        }
        strb.append("<span class=\"z-button z-mg-l5 z-readonly\">").append(result.pageNo()).append("/").append(result.totalPages()).append("(").append(result.pageSize()).append(")").append("</span>");
        strb.append("</div>");
        return strb.toString();
    }

    @Override
    public String toHtmlClick(PageResult<?> result, String jsMethod) {
        if (result == null) {
            result = PageBuilder.newResult(20);
        }
        StringBuilder strb = new StringBuilder();
        strb.append("<div class=\"z-relative-center z-text-center\">");
        strb.append("<span class=\"z-button z-mg-r5 z-readonly\">\u603b&nbsp;<span class=\"z-bold z-text-red\">").append(result.total()).append("</span>&nbsp;\u6761</span>");
        if (result.hasFirst()) {
            strb.append("<span class=\"z-button z-mg-r3\" onclick=\"" + jsMethod + "('1');\">\u9996\u9875</span>");
        } else {
            strb.append("<span class=\"z-button z-mg-r3 z-readonly\">\u9996\u9875</span>");
        }
        if (result.hasPrevious()) {
            strb.append("<span class=\"z-button z-mg-r3\" onclick=\"" + jsMethod + "('" + (result.pageNo() - 1) + "');\">\u4e0a\u4e00\u9875</span>");
        } else {
            strb.append("<span class=\"z-button z-mg-r3 z-readonly\">\u4e0a\u4e00\u9875</span>");
        }
        int lBound = result.getLSegmentNo(5);
        int rBound = result.getRSegmentNo(5);
        if (result.hasLSegment(5)) {
            strb.append("<span class=\"z-button z-mg-r3\" onclick=\"" + jsMethod + "('" + (lBound - 1) + "');\">&lt;&lt;</span>");
        }
        int i = lBound;
        while (i < rBound) {
            strb.append("<span class=\"z-button z-mg-r3");
            if (result.pageNo() == i) {
                strb.append(" z-red");
            }
            strb.append("\" onclick=\"" + jsMethod + "('" + i + "');\">" + i + "</span>");
            ++i;
        }
        if (result.hasRSegment(5)) {
            strb.append("<span class=\"z-button z-mg-r3\" onclick=\"" + jsMethod + "('" + rBound + "');\">&gt;&gt;</span>");
        }
        if (result.hasNext()) {
            strb.append("<span class=\"z-button z-mg-r3\" onclick=\"" + jsMethod + "('" + (result.pageNo() + 1) + "');\">\u4e0b\u4e00\u9875</span>");
        } else {
            strb.append("<span class=\"z-button z-mg-r3 z-readonly\">\u4e0b\u4e00\u9875</span>");
        }
        if (result.hasLast()) {
            strb.append("<span class=\"z-button\" onclick=\"" + jsMethod + "('" + result.totalPages() + "');\">\u672b\u9875</span>");
        } else {
            strb.append("<span class=\"z-button z-readonly\">\u672b\u9875</span>");
        }
        strb.append("<span class=\"z-button z-mg-l5 z-readonly\">").append(result.pageNo()).append("/").append(result.totalPages()).append("(").append(result.pageSize()).append(")").append("</span>");
        strb.append("</div>");
        return strb.toString();
    }
}

